/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableCollection;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LikePredicate
extends Expression {
    private final Expression value;
    private final Expression pattern;
    private final Optional<Expression> escape;

    public LikePredicate(Expression value, Expression pattern, Expression escape) {
        this(Optional.empty(), value, pattern, Optional.of(escape));
    }

    public LikePredicate(NodeLocation location, Expression value, Expression pattern, Optional<Expression> escape) {
        this(Optional.of(location), value, pattern, escape);
    }

    public LikePredicate(Expression value, Expression pattern, Optional<Expression> escape) {
        this(Optional.empty(), value, pattern, escape);
    }

    private LikePredicate(Optional<NodeLocation> location, Expression value, Expression pattern, Optional<Expression> escape) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(pattern, "pattern is null");
        Objects.requireNonNull(escape, "escape is null");
        this.value = value;
        this.pattern = pattern;
        this.escape = escape;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getPattern() {
        return this.pattern;
    }

    public Optional<Expression> getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLikePredicate(this, context);
    }

    public List<Node> getChildren() {
        ImmutableCollection.Builder result = ((ImmutableList.Builder)ImmutableList.builder().add(this.value)).add(this.pattern);
        this.escape.ifPresent(((ImmutableList.Builder)result)::add);
        return ((ImmutableList.Builder)result).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikePredicate that = (LikePredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.pattern, that.pattern) && Objects.equals(this.escape, that.escape);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.pattern, this.escape);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return LikePredicate.sameClass(this, other);
    }
}

