/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IsNullPredicate
extends Expression {
    private final Expression value;

    public IsNullPredicate(Expression value) {
        this(Optional.empty(), value);
    }

    public IsNullPredicate(NodeLocation location, Expression value) {
        this(Optional.of(location), value);
    }

    private IsNullPredicate(Optional<NodeLocation> location, Expression value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        this.value = value;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIsNullPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsNullPredicate that = (IsNullPredicate)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return IsNullPredicate.sameClass(this, other);
    }
}

