/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import io.trino.hive.$internal.com.google.common.collect.Lists;
import io.trino.hive.$internal.com.google.common.collect.Maps;
import io.trino.hive.$internal.com.google.common.collect.Sets;
import io.trino.hive.$internal.org.apache.commons.logging.Log;
import io.trino.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hive.common.util.ReflectionUtil;

class TablePropertyEnrichmentOptimizer
extends Transform {
    private static Log LOG = LogFactory.getLog(TablePropertyEnrichmentOptimizer.class);

    TablePropertyEnrichmentOptimizer() {
    }

    private static Map<String, String> getTableParameters(Table table) {
        HashMap<String, String> originalTableParameters = new HashMap<String, String>(table.getParameters());
        Properties tableMetadata = MetaStoreUtils.getTableMetadata(table);
        for (String property : tableMetadata.stringPropertyNames()) {
            if (originalTableParameters.containsKey(property)) continue;
            originalTableParameters.put(property, tableMetadata.getProperty(property));
        }
        return originalTableParameters;
    }

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LOG.info("TablePropertyEnrichmentOptimizer::transform().");
        LinkedHashMap<Rule, NodeProcessor> opRules = Maps.newLinkedHashMap();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), new Processor());
        WalkerCtx context = new WalkerCtx(pctx.getConf());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, context);
        ArrayList<Node> topNodes = Lists.newArrayList();
        topNodes.addAll(pctx.getTopOps().values());
        PreOrderWalker walker = new PreOrderWalker(disp);
        walker.startWalking(topNodes, null);
        LOG.info("TablePropertyEnrichmentOptimizer::transform() complete!");
        return pctx;
    }

    private static class Processor
    implements NodeProcessor {
        private Processor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tsOp = (TableScanOperator)nd;
            WalkerCtx context = (WalkerCtx)procCtx;
            TableScanDesc tableScanDesc = (TableScanDesc)tsOp.getConf();
            Table table = ((TableScanDesc)tsOp.getConf()).getTableMetadata().getTTable();
            Map originalTableParameters = TablePropertyEnrichmentOptimizer.getTableParameters(table);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Original Table parameters: " + originalTableParameters);
            }
            Properties clonedTableParameters = new Properties();
            clonedTableParameters.putAll((Map<?, ?>)originalTableParameters);
            String deserializerClassName = null;
            try {
                deserializerClassName = tableScanDesc.getTableMetadata().getSd().getSerdeInfo().getSerializationLib();
                Deserializer deserializer = ReflectionUtil.newInstance(context.conf.getClassByName(deserializerClassName).asSubclass(Deserializer.class), context.conf);
                if (context.serdeClassesUnderConsideration.contains(deserializerClassName)) {
                    deserializer.initialize(context.conf, clonedTableParameters);
                    LOG.debug("SerDe init succeeded for class: " + deserializerClassName);
                    for (Map.Entry<Object, Object> property : clonedTableParameters.entrySet()) {
                        if (property.getValue().equals(originalTableParameters.get(property.getKey()))) continue;
                        LOG.debug("Resolving changed parameters! key=" + property.getKey() + ", value=" + property.getValue());
                        table.getParameters().put((String)property.getKey(), (String)property.getValue());
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipping prefetch for " + deserializerClassName);
                }
            }
            catch (Throwable t) {
                LOG.error("SerDe init failed for SerDe class==" + deserializerClassName + ". Didn't change table-properties", t);
            }
            return nd;
        }
    }

    private static class WalkerCtx
    implements NodeProcessorCtx {
        Configuration conf;
        Set<String> serdeClassesUnderConsideration = Sets.newHashSet();

        WalkerCtx(Configuration conf) {
            this.conf = conf;
            this.serdeClassesUnderConsideration.addAll(Arrays.asList(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_OPTIMIZE_TABLE_PROPERTIES_FROM_SERDE_LIST).split(",")));
            if (LOG.isDebugEnabled()) {
                LOG.debug("TablePropertyEnrichmentOptimizer considers these SerDe classes:");
                for (String className : this.serdeClassesUnderConsideration) {
                    LOG.debug(className);
                }
            }
        }
    }
}

