/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.BigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.SizeBasedBigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class AvgPartitionSizeBasedBigTableSelectorForAutoSMJ
extends SizeBasedBigTableSelectorForAutoSMJ
implements BigTableSelectorForAutoSMJ {
    private static final Logger LOG = LoggerFactory.getLogger(AvgPartitionSizeBasedBigTableSelectorForAutoSMJ.class.getName());

    @Override
    public int getBigTablePosition(ParseContext parseCtx, JoinOperator joinOp, Set<Integer> bigTableCandidates) throws SemanticException {
        int bigTablePos = -1;
        long maxSize = -1L;
        int numPartitionsCurrentBigTable = 0;
        HiveConf conf = parseCtx.getConf();
        try {
            ArrayList<TableScanOperator> topOps = new ArrayList<TableScanOperator>();
            this.getListTopOps(joinOp, topOps);
            int currentPos = 0;
            for (TableScanOperator topOp : topOps) {
                if (topOp == null) {
                    return -1;
                }
                if (!bigTableCandidates.contains(currentPos)) {
                    ++currentPos;
                    continue;
                }
                int numPartitions = 1;
                Table table = ((TableScanDesc)topOp.getConf()).getTableMetadata();
                long averageSize = 0L;
                if (!table.isPartitioned()) {
                    averageSize = this.getSize(conf, table);
                } else {
                    PrunedPartitionList partsList = PartitionPruner.prune(topOp, parseCtx, null);
                    numPartitions = partsList.getNotDeniedPartns().size();
                    long totalSize = 0L;
                    for (Partition part : partsList.getNotDeniedPartns()) {
                        totalSize += this.getSize(conf, part);
                    }
                    long l = averageSize = numPartitions == 0 ? 0L : totalSize / (long)numPartitions;
                }
                if (averageSize > maxSize) {
                    maxSize = averageSize;
                    bigTablePos = currentPos;
                    numPartitionsCurrentBigTable = numPartitions;
                } else if (averageSize == maxSize && numPartitions < numPartitionsCurrentBigTable) {
                    bigTablePos = currentPos;
                    numPartitionsCurrentBigTable = numPartitions;
                }
                ++currentPos;
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage());
        }
        return bigTablePos;
    }
}

