/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.VectorizedOrcSerde;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.orc.OrcConf;

@SerDeSpec(schemaProps={"columns", "columns.types", "orc.compress"})
public class OrcSerde
extends VectorizedSerde {
    private static final Logger LOG = LoggerFactory.getLogger(OrcSerde.class);
    private final OrcSerdeRow row = new OrcSerdeRow();
    private ObjectInspector inspector = null;
    private VectorizedOrcSerde vos = null;
    public static final String COMPRESSION = "orc.compress";

    @Override
    public void initialize(Configuration conf, Properties table) {
        String columnNameProperty = table.getProperty("columns");
        String columnTypeProperty = table.getProperty("columns.types");
        String columnNameDelimiter = table.containsKey("column.name.delimiter") ? table.getProperty("column.name.delimiter") : String.valueOf(',');
        String compressType = OrcConf.COMPRESS.getString(table, conf);
        ArrayList<String> columnNames = new ArrayList<String>();
        if (columnNameProperty != null && columnNameProperty.length() > 0) {
            for (String name : columnNameProperty.split(columnNameDelimiter)) {
                columnNames.add(name);
            }
        }
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columnNames.size(); ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append("string");
            }
            columnTypeProperty = sb.toString();
        }
        ArrayList<TypeInfo> fieldTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        StructTypeInfo rootType = new StructTypeInfo();
        rootType.setAllStructFieldNames(columnNames);
        rootType.setAllStructFieldTypeInfos(fieldTypes);
        this.inspector = OrcStruct.createObjectInspector(rootType);
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return OrcSerdeRow.class;
    }

    @Override
    public Writable serialize(Object realRow, ObjectInspector inspector) {
        this.row.realRow = realRow;
        this.row.inspector = inspector;
        return this.row;
    }

    @Override
    public Object deserialize(Writable writable) throws SerDeException {
        return writable;
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    @Override
    public Writable serializeVector(VectorizedRowBatch vrg, ObjectInspector objInspector) throws SerDeException {
        if (this.vos == null) {
            this.vos = new VectorizedOrcSerde(this.getObjectInspector());
        }
        return this.vos.serialize(vrg, this.getObjectInspector());
    }

    @Override
    public void deserializeVector(Object rowBlob, int rowsInBatch, VectorizedRowBatch reuseBatch) throws SerDeException {
    }

    final class OrcSerdeRow
    implements Writable {
        Object realRow;
        ObjectInspector inspector;

        OrcSerdeRow() {
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("can't write the bundle");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("can't read the bundle");
        }

        ObjectInspector getInspector() {
            return this.inspector;
        }

        Object getRow() {
            return this.realRow;
        }
    }
}

