/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.$internal.com.codahale.metrics.jvm;

import io.trino.hive.$internal.com.codahale.metrics.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FileDescriptorRatioGauge
extends RatioGauge {
    private final OperatingSystemMXBean os;

    public FileDescriptorRatioGauge() {
        this(ManagementFactory.getOperatingSystemMXBean());
    }

    public FileDescriptorRatioGauge(OperatingSystemMXBean os) {
        this.os = os;
    }

    @Override
    protected RatioGauge.Ratio getRatio() {
        try {
            return RatioGauge.Ratio.of(this.invoke("getOpenFileDescriptorCount"), this.invoke("getMaxFileDescriptorCount"));
        }
        catch (NoSuchMethodException e) {
            return RatioGauge.Ratio.of(Double.NaN, Double.NaN);
        }
        catch (IllegalAccessException e) {
            return RatioGauge.Ratio.of(Double.NaN, Double.NaN);
        }
        catch (InvocationTargetException e) {
            return RatioGauge.Ratio.of(Double.NaN, Double.NaN);
        }
    }

    private long invoke(String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = this.os.getClass().getDeclaredMethod(name, new Class[0]);
        method.setAccessible(true);
        return (Long)method.invoke((Object)this.os, new Object[0]);
    }
}

