/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.shaded.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import org.weakref.shaded.jmx.MBeanAttribute;
import org.weakref.shaded.jmx.MBeanOperation;
import org.weakref.shaded.jmx.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MBean
implements DynamicMBean {
    private static final Object[] NO_PARAMS = new Object[0];
    private static final String[] NO_ARGS = new String[0];
    private final MBeanInfo mbeanInfo;
    private final Map<String, MBeanAttribute> attributes;
    private final Map<Signature, MBeanOperation> operations;

    public MBean(String className, String description, Collection<MBeanAttribute> attributes, Collection<MBeanOperation> operations) {
        ArrayList<MBeanAttributeInfo> attributeInfos = new ArrayList<MBeanAttributeInfo>();
        TreeMap<String, MBeanAttribute> attributesBuilder = new TreeMap<String, MBeanAttribute>();
        for (MBeanAttribute attribute : attributes) {
            attributesBuilder.put(attribute.getName(), attribute);
            attributeInfos.add(attribute.getInfo());
        }
        this.attributes = Collections.unmodifiableMap(attributesBuilder);
        HashMap<Signature, MBeanOperation> operationsBuilder = new HashMap<Signature, MBeanOperation>();
        ArrayList<MBeanOperationInfo> operationsInfos = new ArrayList<MBeanOperationInfo>();
        for (MBeanOperation operation : operations) {
            operationsBuilder.put(operation.getSignature(), operation);
            operationsInfos.add(operation.getInfo());
        }
        this.operations = Collections.unmodifiableMap(operationsBuilder);
        this.mbeanInfo = new MBeanInfo(className, description, attributeInfos.toArray(new MBeanAttributeInfo[attributeInfos.size()]), new ModelMBeanConstructorInfo[0], operationsInfos.toArray(new MBeanOperationInfo[operationsInfos.size()]), new ModelMBeanNotificationInfo[0]);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    public Collection<MBeanAttribute> getAttributes() {
        return this.attributes.values();
    }

    public Collection<MBeanOperation> getOperations() {
        return this.operations.values();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] argTypes) throws MBeanException, ReflectionException {
        this.assertNotNull("actionName", actionName);
        if (params == null) {
            params = NO_PARAMS;
        }
        if (argTypes == null) {
            argTypes = NO_ARGS;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            this.assertNotNull("argTypes[" + i + "]", argTypes[i]);
        }
        Signature signature = new Signature(actionName, argTypes);
        MBeanOperation operation = this.operations.get(signature);
        if (operation == null) {
            String message = "Operation " + signature + " not found";
            throw new MBeanException(new ServiceNotFoundException(message), message);
        }
        Object result = operation.invoke(params);
        return result;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        this.assertNotNull("attribute", name);
        MBeanAttribute mbeanAttribute = this.attributes.get(name);
        if (mbeanAttribute == null) {
            throw new AttributeNotFoundException(name);
        }
        Object value = mbeanAttribute.getValue();
        return value;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.assertNotNull("attribute", attribute);
        String name = attribute.getName();
        this.assertNotNull("attribute.name", name);
        Object value = attribute.getValue();
        MBeanAttribute mbeanAttribute = this.attributes.get(name);
        if (mbeanAttribute == null) {
            throw new AttributeNotFoundException(name);
        }
        mbeanAttribute.setValue(value);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            return null;
        }
        AttributeList attributeList = new AttributeList();
        for (String attribute : attributes) {
            try {
                attributeList.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            return null;
        }
        AttributeList response = new AttributeList();
        for (Attribute attribute : attributes.asList()) {
            try {
                this.setAttribute(attribute);
                response.add(attribute);
            }
            catch (Exception ignored) {}
        }
        return response;
    }

    private void assertNotNull(String name, Object value) {
        if (value == null) {
            throw new RuntimeOperationsException(new NullPointerException(name + " is null"));
        }
    }
}

