/*
 * Decompiled with CFR 0.152.
 */
package info.ganglia.gmetric4j;

import info.ganglia.gmetric4j.CoreSampler;
import info.ganglia.gmetric4j.DefaultGScheduler;
import info.ganglia.gmetric4j.GSampler;
import info.ganglia.gmetric4j.GScheduler;
import info.ganglia.gmetric4j.gmetric.GMetric;
import info.ganglia.gmetric4j.gmetric.GMetricPublisher;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class GMonitor {
    private static Logger log = Logger.getLogger(GMonitor.class.getName());
    private List<GSampler> samplers = new ArrayList<GSampler>();
    private boolean daemon = true;
    private GMetric gmetric = null;
    private GScheduler scheduler;

    public GMonitor() {
        this.scheduler = new DefaultGScheduler();
    }

    public GMonitor(GScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void start() {
        this.scheduler.onStart();
        log.info("Setting up " + this.samplers.size() + " samplers");
        for (GSampler s : this.samplers) {
            this.scheduler.scheduleAtFixedRate(s, s.getInitialDelay(), s.getDelay(), TimeUnit.SECONDS);
        }
    }

    public void stop() {
        this.scheduler.onStop();
    }

    public void addSampler(GSampler s) {
        this.samplers.add(s);
        s.setPublisher(new GMetricPublisher(this.gmetric));
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public GMetric getGmetric() {
        return this.gmetric;
    }

    public void setGmetric(GMetric gmetric) {
        this.gmetric = gmetric;
    }

    public static void main(String[] args) throws Exception {
        GMonitor a = null;
        try {
            a = new GMonitor();
            a.setGmetric(new GMetric("239.2.11.71", 8649, GMetric.UDPAddressingMode.MULTICAST, 1));
            a.addSampler(new CoreSampler());
            a.start();
        }
        catch (Exception ex) {
            log.severe("Exception starting GMonitor");
            ex.printStackTrace();
        }
        while (true) {
            Thread.sleep(300000L);
            System.out.println("Test wakeup");
        }
    }
}

