/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.google.shaded.shaded.common.cache.CacheBuilder;
import com.google.shaded.shaded.common.cache.CacheLoader;
import com.google.shaded.shaded.common.cache.LoadingCache;
import com.google.shaded.shaded.common.collect.ImmutableList;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.ClusterType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.ishugaliy.allgood.consistent.hash.ConsistentHash;
import org.ishugaliy.allgood.consistent.hash.HashRing;
import org.ishugaliy.allgood.consistent.hash.hasher.DefaultHasher;
import org.ishugaliy.allgood.consistent.hash.node.SimpleNode;

public abstract class ClusterManager {
    private static Log log = LogFactory.getLog(ClusterManager.class);
    private String currentNodeName;
    private String nodeHostname;
    private String nodeHostAddress;
    private final AtomicReference<LoadingCache<String, List<String>>> nodesCache = new AtomicReference();
    private final ConsistentHash<SimpleNode> consistentHashRing = HashRing.newBuilder().hasher(DefaultHasher.METRO_HASH).build();

    public abstract ClusterType getClusterType();

    protected abstract List<String> getNodesInternal();

    protected String getCurrentNodeHostname() {
        return this.nodeHostname;
    }

    protected String getCurrentNodeHostAddress() {
        return this.nodeHostAddress;
    }

    private List<String> getNodesAndUpdateState() {
        Objects.requireNonNull(this.nodesCache, "ClusterManager used before initialization");
        List<String> nodes = this.getNodesInternal();
        if (nodes == null) {
            nodes = ImmutableList.of();
        } else if (nodes.isEmpty()) {
            nodes = ImmutableList.of(this.getCurrentNodeHostAddress());
        }
        for (SimpleNode ringNode : this.consistentHashRing.getNodes()) {
            if (nodes.contains(ringNode.getKey())) continue;
            log.debug((Object)("Removing node: " + ringNode.getKey() + " from consistent hash ring, Total nodes: " + this.consistentHashRing.getNodes()));
            this.consistentHashRing.remove(ringNode);
        }
        for (String node : nodes) {
            SimpleNode ringNode = SimpleNode.of(node);
            if (this.consistentHashRing.contains(ringNode)) continue;
            log.debug((Object)("Adding node: " + ringNode.getKey() + " to consistent hash ring, Total nodes: " + this.consistentHashRing.getNodes()));
            this.consistentHashRing.add(ringNode);
        }
        if (this.currentNodeName == null) {
            if (this.consistentHashRing.contains(SimpleNode.of(this.getCurrentNodeHostname()))) {
                this.currentNodeName = this.getCurrentNodeHostname();
            } else if (this.consistentHashRing.contains(SimpleNode.of(this.getCurrentNodeHostAddress()))) {
                this.currentNodeName = this.getCurrentNodeHostAddress();
            } else {
                log.error((Object)String.format("Could not initialize cluster nodes=%s nodeHostName=%s nodeHostAddress=%s currentNodeIndex=%s", nodes, this.getCurrentNodeHostname(), this.getCurrentNodeHostAddress(), this.currentNodeName));
            }
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Configuration conf) throws UnknownHostException {
        if (this.nodesCache.get() == null) {
            AtomicReference<LoadingCache<String, List<String>>> atomicReference = this.nodesCache;
            synchronized (atomicReference) {
                if (this.nodesCache.get() == null) {
                    int nodeRefreshTime = CacheConfig.getClusterNodeRefreshTime(conf);
                    this.nodeHostname = InetAddress.getLocalHost().getCanonicalHostName();
                    this.nodeHostAddress = InetAddress.getLocalHost().getHostAddress();
                    ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
                        Thread t = Executors.defaultThreadFactory().newThread(r);
                        t.setName("rubix-get-nodes-thread");
                        t.setDaemon(true);
                        return t;
                    });
                    this.nodesCache.set(CacheBuilder.newBuilder().refreshAfterWrite(nodeRefreshTime, TimeUnit.SECONDS).build(CacheLoader.asyncReloading(new CacheLoader<String, List<String>>(){

                        @Override
                        public List<String> load(String s) {
                            return ClusterManager.this.getNodesAndUpdateState();
                        }
                    }, executor)));
                }
            }
        }
    }

    public String locateKey(String key) {
        return this.consistentHashRing.locate(key).orElseThrow(() -> new RuntimeException("Unable to locate key: " + key)).getKey();
    }

    public List<String> getNodes() {
        return this.nodesCache.get().getUnchecked("nodes");
    }

    public String getCurrentNodeName() {
        this.refreshClusterNodes();
        return this.currentNodeName;
    }

    private void refreshClusterNodes() {
        List<String> nodes = this.getNodes();
        if (nodes == null) {
            log.error((Object)("Initialization not done for Cluster Type: " + (Object)((Object)this.getClusterType())));
            throw new RuntimeException("Unable to find current node name");
        }
    }
}

