/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.hadoop2;

import com.google.shaded.common.shaded.base.Throwables;
import com.google.shaded.common.shaded.collect.ImmutableList;
import com.google.shaded.common.shaded.collect.Lists;
import com.qubole.rubix.hadoop2.Hadoop2ClusterManagerUtil;
import com.qubole.rubix.spi.ClusterManager;
import com.qubole.rubix.spi.ClusterType;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class Hadoop2ClusterManager
extends ClusterManager {
    YarnConfiguration yconf;
    private Log log = LogFactory.getLog(Hadoop2ClusterManager.class);

    @Override
    public void initialize(Configuration conf) throws UnknownHostException {
        super.initialize(conf);
        this.yconf = new YarnConfiguration(conf);
    }

    @Override
    public List<String> getNodesInternal() {
        try {
            List<Hadoop2ClusterManagerUtil.Node> allNodes = Hadoop2ClusterManagerUtil.getAllNodes(this.yconf);
            if (allNodes == null) {
                return null;
            }
            if (allNodes.isEmpty()) {
                return ImmutableList.of();
            }
            HashSet<String> hosts = new HashSet<String>();
            for (Hadoop2ClusterManagerUtil.Node node : allNodes) {
                String state = node.getState();
                this.log.debug((Object)("Hostname: " + node.getNodeHostName() + "State: " + state));
                if (!state.equalsIgnoreCase("Running") && !state.equalsIgnoreCase("New") && !state.equalsIgnoreCase("Rebooted")) continue;
                hosts.add(node.getNodeHostName());
            }
            if (hosts.isEmpty()) {
                throw new Exception("No healthy data nodes found.");
            }
            ArrayList<String> hostList = Lists.newArrayList(hosts.toArray(new String[0]));
            return hostList;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.HADOOP2_CLUSTER_MANAGER;
    }
}

