/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.common.utils;

import com.qubole.rubix.common.metrics.MetricsReporterType;
import com.qubole.rubix.spi.CacheConfig;
import java.io.File;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ClusterUtil {
    private static final Log log = LogFactory.getLog((String)ClusterUtil.class.getName());
    public static volatile AtomicReference<Boolean> rubixSiteExists = new AtomicReference();

    private ClusterUtil() {
    }

    public static String getMasterHostname(Configuration conf) {
        log.debug((Object)"Trying master.hostname");
        String host = CacheConfig.getCoordinatorHostName(conf);
        if (host != null) {
            return host;
        }
        log.debug((Object)"Trying yarn.resourcemanager.address");
        host = CacheConfig.getResourceManagerAddress(conf);
        if (host != null) {
            return host.contains(":") ? host.substring(0, host.indexOf(":")) : host;
        }
        log.debug((Object)"No hostname found in etc/*-site.xml, returning localhost");
        return "localhost";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration applyRubixSiteConfig(Configuration conf) {
        if (CacheConfig.isRubixSiteConfigApplied(conf).booleanValue()) {
            return conf;
        }
        if (rubixSiteExists.get() == null) {
            AtomicReference<Boolean> atomicReference = rubixSiteExists;
            synchronized (atomicReference) {
                if (rubixSiteExists.get() == null) {
                    String configFileLocation = CacheConfig.getRubixSiteLocation(conf);
                    File configFile = new File(configFileLocation);
                    if (configFile.exists() && configFile.isFile() && configFile.length() != 0L) {
                        rubixSiteExists.set(true);
                    } else {
                        rubixSiteExists.set(false);
                    }
                }
            }
        }
        if (rubixSiteExists.get().booleanValue()) {
            conf.addResource(new Path(CacheConfig.getRubixSiteLocation(conf)));
            CacheConfig.setRubixConfigApplied(conf, true);
        }
        return conf;
    }

    public static Set<MetricsReporterType> getMetricsReporters(Configuration configuration) {
        return Stream.of(CacheConfig.getMetricsReporters(configuration).split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toUpperCase).map(MetricsReporterType::valueOf).collect(Collectors.toSet());
    }
}

