/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.plugin.hive.util.DecimalUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.joda.time.DateTimeZone;

public final class SerDeUtils {
    private SerDeUtils() {
    }

    public static Block getBlockObject(Type type, Object object, ObjectInspector objectInspector) {
        Block serialized = SerDeUtils.serializeObject(type, null, object, objectInspector);
        return Objects.requireNonNull(serialized, "serialized is null");
    }

    public static Block serializeObject(Type type, BlockBuilder builder, Object object, ObjectInspector inspector) {
        return SerDeUtils.serializeObject(type, builder, object, inspector, true);
    }

    @VisibleForTesting
    public static Block serializeObject(Type type, BlockBuilder builder, Object object, ObjectInspector inspector, boolean filterNullMapKeys) {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                SerDeUtils.serializePrimitive(type, builder, object, (PrimitiveObjectInspector)inspector);
                return null;
            }
            case LIST: {
                return SerDeUtils.serializeList(type, builder, object, (ListObjectInspector)inspector);
            }
            case MAP: {
                return SerDeUtils.serializeMap(type, builder, object, (MapObjectInspector)inspector, filterNullMapKeys);
            }
            case STRUCT: {
                return SerDeUtils.serializeStruct(type, builder, object, (StructObjectInspector)inspector);
            }
            case UNION: {
                return SerDeUtils.serializeUnion(type, builder, object, (UnionObjectInspector)inspector);
            }
        }
        throw new RuntimeException("Unknown object inspector category: " + inspector.getCategory());
    }

    private static void serializePrimitive(Type type, BlockBuilder builder, Object object, PrimitiveObjectInspector inspector) {
        Objects.requireNonNull(builder, "builder is null");
        if (object == null) {
            builder.appendNull();
            return;
        }
        switch (inspector.getPrimitiveCategory()) {
            case BOOLEAN: {
                type.writeBoolean(builder, ((BooleanObjectInspector)inspector).get(object));
                return;
            }
            case BYTE: {
                type.writeLong(builder, (long)((ByteObjectInspector)inspector).get(object));
                return;
            }
            case SHORT: {
                type.writeLong(builder, (long)((ShortObjectInspector)inspector).get(object));
                return;
            }
            case INT: {
                type.writeLong(builder, (long)((IntObjectInspector)inspector).get(object));
                return;
            }
            case LONG: {
                type.writeLong(builder, ((LongObjectInspector)inspector).get(object));
                return;
            }
            case FLOAT: {
                type.writeLong(builder, (long)Float.floatToRawIntBits(((FloatObjectInspector)inspector).get(object)));
                return;
            }
            case DOUBLE: {
                type.writeDouble(builder, ((DoubleObjectInspector)inspector).get(object));
                return;
            }
            case STRING: {
                type.writeSlice(builder, Slices.utf8Slice((String)((StringObjectInspector)inspector).getPrimitiveJavaObject(object)));
                return;
            }
            case VARCHAR: {
                type.writeSlice(builder, Slices.utf8Slice((String)((HiveVarcharObjectInspector)inspector).getPrimitiveJavaObject(object).getValue()));
                return;
            }
            case CHAR: {
                HiveChar hiveChar = ((HiveCharObjectInspector)inspector).getPrimitiveJavaObject(object);
                type.writeSlice(builder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)hiveChar.getValue()), (int)((CharType)type).getLength()));
                return;
            }
            case DATE: {
                type.writeLong(builder, SerDeUtils.formatDateAsLong(object, (DateObjectInspector)inspector));
                return;
            }
            case TIMESTAMP: {
                TimestampType timestampType = (TimestampType)type;
                DecodedTimestamp timestamp = SerDeUtils.formatTimestamp(timestampType, object, (TimestampObjectInspector)inspector);
                TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)timestampType, (DateTimeZone)DateTimeZone.UTC).write(timestamp, builder);
                return;
            }
            case BINARY: {
                type.writeSlice(builder, Slices.wrappedBuffer((byte[])((BinaryObjectInspector)inspector).getPrimitiveJavaObject(object)));
                return;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                HiveDecimalWritable hiveDecimal = ((HiveDecimalObjectInspector)inspector).getPrimitiveWritableObject(object);
                if (decimalType.isShort()) {
                    type.writeLong(builder, DecimalUtils.getShortDecimalValue(hiveDecimal, decimalType.getScale()));
                } else {
                    type.writeSlice(builder, DecimalUtils.getLongDecimalValue(hiveDecimal, decimalType.getScale()));
                }
                return;
            }
        }
        throw new RuntimeException("Unknown primitive type: " + inspector.getPrimitiveCategory());
    }

    private static Block serializeList(Type type, BlockBuilder builder, Object object, ListObjectInspector inspector) {
        List list = inspector.getList(object);
        if (list == null) {
            Objects.requireNonNull(builder, "builder is null").appendNull();
            return null;
        }
        List typeParameters = type.getTypeParameters();
        Preconditions.checkArgument((typeParameters.size() == 1 ? 1 : 0) != 0, (Object)"list must have exactly 1 type parameter");
        Type elementType = (Type)typeParameters.get(0);
        ObjectInspector elementInspector = inspector.getListElementObjectInspector();
        BlockBuilder currentBuilder = builder != null ? builder.beginBlockEntry() : elementType.createBlockBuilder(null, list.size());
        for (Object element : list) {
            SerDeUtils.serializeObject(elementType, currentBuilder, element, elementInspector);
        }
        if (builder != null) {
            builder.closeEntry();
            return null;
        }
        Block resultBlock = currentBuilder.build();
        return resultBlock;
    }

    private static Block serializeMap(Type type, BlockBuilder builder, Object object, MapObjectInspector inspector, boolean filterNullMapKeys) {
        Map map = inspector.getMap(object);
        if (map == null) {
            Objects.requireNonNull(builder, "builder is null").appendNull();
            return null;
        }
        List typeParameters = type.getTypeParameters();
        Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"map must have exactly 2 type parameter");
        Type keyType = (Type)typeParameters.get(0);
        Type valueType = (Type)typeParameters.get(1);
        ObjectInspector keyInspector = inspector.getMapKeyObjectInspector();
        ObjectInspector valueInspector = inspector.getMapValueObjectInspector();
        boolean builderSynthesized = false;
        if (builder == null) {
            builderSynthesized = true;
            builder = type.createBlockBuilder(null, 1);
        }
        BlockBuilder currentBuilder = builder.beginBlockEntry();
        for (Map.Entry entry : map.entrySet()) {
            if (filterNullMapKeys && entry.getKey() == null) continue;
            SerDeUtils.serializeObject(keyType, currentBuilder, entry.getKey(), keyInspector);
            SerDeUtils.serializeObject(valueType, currentBuilder, entry.getValue(), valueInspector);
        }
        builder.closeEntry();
        if (builderSynthesized) {
            return (Block)type.getObject((Block)builder, 0);
        }
        return null;
    }

    private static Block serializeStruct(Type type, BlockBuilder builder, Object object, StructObjectInspector inspector) {
        if (object == null) {
            Objects.requireNonNull(builder, "builder is null").appendNull();
            return null;
        }
        List typeParameters = type.getTypeParameters();
        List allStructFieldRefs = inspector.getAllStructFieldRefs();
        Preconditions.checkArgument((typeParameters.size() == allStructFieldRefs.size() ? 1 : 0) != 0);
        boolean builderSynthesized = false;
        if (builder == null) {
            builderSynthesized = true;
            builder = type.createBlockBuilder(null, 1);
        }
        BlockBuilder currentBuilder = builder.beginBlockEntry();
        for (int i = 0; i < typeParameters.size(); ++i) {
            StructField field = (StructField)allStructFieldRefs.get(i);
            SerDeUtils.serializeObject((Type)typeParameters.get(i), currentBuilder, inspector.getStructFieldData(object, field), field.getFieldObjectInspector());
        }
        builder.closeEntry();
        if (builderSynthesized) {
            return (Block)type.getObject((Block)builder, 0);
        }
        return null;
    }

    private static Block serializeUnion(Type type, BlockBuilder builder, Object object, UnionObjectInspector inspector) {
        if (object == null) {
            Objects.requireNonNull(builder, "builder is null").appendNull();
            return null;
        }
        boolean builderSynthesized = false;
        if (builder == null) {
            builderSynthesized = true;
            builder = type.createBlockBuilder(null, 1);
        }
        BlockBuilder currentBuilder = builder.beginBlockEntry();
        byte tag = inspector.getTag(object);
        TinyintType.TINYINT.writeLong(currentBuilder, (long)tag);
        List typeParameters = type.getTypeParameters();
        for (int i = 1; i < typeParameters.size(); ++i) {
            if (i == tag + 1) {
                SerDeUtils.serializeObject((Type)typeParameters.get(i), currentBuilder, inspector.getField(object), (ObjectInspector)inspector.getObjectInspectors().get(tag));
                continue;
            }
            currentBuilder.appendNull();
        }
        builder.closeEntry();
        if (builderSynthesized) {
            return (Block)type.getObject((Block)builder, 0);
        }
        return null;
    }

    private static long formatDateAsLong(Object object, DateObjectInspector inspector) {
        if (object instanceof LazyDate) {
            return ((DateWritableV2)((LazyDate)object).getWritableObject()).getDays();
        }
        if (object instanceof DateWritable) {
            return ((DateWritable)object).getDays();
        }
        return inspector.getPrimitiveJavaObject(object).toEpochDay();
    }

    private static DecodedTimestamp formatTimestamp(TimestampType type, Object object, TimestampObjectInspector inspector) {
        int nanoOfSecond;
        long epochSecond;
        if (object instanceof TimestampWritable) {
            TimestampWritable timestamp = (TimestampWritable)object;
            epochSecond = timestamp.getSeconds();
            nanoOfSecond = timestamp.getNanos();
        } else {
            Timestamp timestamp = inspector.getPrimitiveJavaObject(object);
            epochSecond = timestamp.toEpochSecond();
            nanoOfSecond = timestamp.getNanos();
        }
        nanoOfSecond = (int)Timestamps.round((long)nanoOfSecond, (int)(9 - type.getPrecision()));
        if ((long)nanoOfSecond == 1000000000L) {
            ++epochSecond;
            nanoOfSecond = 0;
        }
        return new DecodedTimestamp(epochSecond, nanoOfSecond);
    }
}

