/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;

public interface ResumableTask {
    public TaskStatus process();

    public static class TaskStatus {
        private final boolean finished;
        private final ListenableFuture<Void> continuationFuture;

        private TaskStatus(boolean finished, ListenableFuture<Void> continuationFuture) {
            this.finished = finished;
            this.continuationFuture = continuationFuture;
        }

        public static TaskStatus finished() {
            return new TaskStatus(true, (ListenableFuture<Void>)Futures.immediateVoidFuture());
        }

        public static TaskStatus continueOn(ListenableFuture<Void> continuationFuture) {
            return new TaskStatus(false, continuationFuture);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public ListenableFuture<Void> getContinuationFuture() {
            return this.continuationFuture;
        }
    }
}

