/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.ArrayBlockEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.ByteArrayBlockEncoding;
import io.trino.spi.block.DictionaryBlockEncoding;
import io.trino.spi.block.Int128ArrayBlockEncoding;
import io.trino.spi.block.IntArrayBlockEncoding;
import io.trino.spi.block.LazyBlockEncoding;
import io.trino.spi.block.LongArrayBlockEncoding;
import io.trino.spi.block.RowBlockEncoding;
import io.trino.spi.block.RunLengthBlockEncoding;
import io.trino.spi.block.ShortArrayBlockEncoding;
import io.trino.spi.block.SingleRowBlockEncoding;
import io.trino.spi.block.VariableWidthBlockEncoding;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public final class HiveBlockEncodingSerde
implements BlockEncodingSerde {
    private static final List<Type> TYPES = ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR, (Object)VarbinaryType.VARBINARY, (Object)TimestampType.TIMESTAMP_MILLIS, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)DateType.DATE, (Object)HyperLogLogType.HYPER_LOG_LOG);
    private final ConcurrentMap<String, BlockEncoding> blockEncodings = new ConcurrentHashMap<String, BlockEncoding>();

    @Inject
    public HiveBlockEncodingSerde() {
        this.addBlockEncoding((BlockEncoding)new VariableWidthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ByteArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ShortArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new IntArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LongArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Int128ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new DictionaryBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new SingleRowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RunLengthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LazyBlockEncoding());
    }

    private void addBlockEncoding(BlockEncoding blockEncoding) {
        this.blockEncodings.put(blockEncoding.getName(), blockEncoding);
    }

    public Block readBlock(SliceInput input) {
        String encodingName = HiveBlockEncodingSerde.readLengthPrefixedString(input);
        BlockEncoding blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName);
        Preconditions.checkArgument((blockEncoding != null ? 1 : 0) != 0, (String)"Unknown block encoding %s", (Object)encodingName);
        return blockEncoding.readBlock((BlockEncodingSerde)this, input);
    }

    public void writeBlock(SliceOutput output, Block block) {
        String encodingName;
        BlockEncoding blockEncoding;
        Optional replacementBlock;
        while ((replacementBlock = (blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName = block.getEncodingName())).replacementBlockForWrite(block)).isPresent()) {
            block = (Block)replacementBlock.get();
        }
        HiveBlockEncodingSerde.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeBlock((BlockEncodingSerde)this, output, block);
    }

    public Type readType(SliceInput sliceInput) {
        Objects.requireNonNull(sliceInput, "sliceInput is null");
        TypeId id = TypeId.of((String)HiveBlockEncodingSerde.readLengthPrefixedString(sliceInput));
        for (Type type : TYPES) {
            if (!type.getTypeId().equals((Object)id)) continue;
            return type;
        }
        throw new IllegalArgumentException("Type not found: " + id);
    }

    public void writeType(SliceOutput sliceOutput, Type type) {
        Objects.requireNonNull(sliceOutput, "sliceOutput is null");
        Objects.requireNonNull(type, "type is null");
        HiveBlockEncodingSerde.writeLengthPrefixedString(sliceOutput, type.getTypeId().getId());
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

