/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.block.Block;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.joda.time.DateTimeZone;

public final class FieldSetterFactory {
    private final DateTimeZone timeZone;

    public FieldSetterFactory(DateTimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    public FieldSetter create(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanFieldSetter(rowInspector, row, field);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return new BigintFieldSetter(rowInspector, row, field);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return new IntFieldSetter(rowInspector, row, field);
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return new SmallintFieldSetter(rowInspector, row, field);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return new TinyintFieldSetter(rowInspector, row, field);
        }
        if (RealType.REAL.equals((Object)type)) {
            return new FloatFieldSetter(rowInspector, row, field);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleFieldSetter(rowInspector, row, field);
        }
        if (type instanceof VarcharType) {
            return new VarcharFieldSetter(rowInspector, row, field, type);
        }
        if (type instanceof CharType) {
            return new CharFieldSetter(rowInspector, row, field, type);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new BinaryFieldSetter(rowInspector, row, field);
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateFieldSetter(rowInspector, row, field);
        }
        if (type instanceof TimestampType) {
            return new TimestampFieldSetter(rowInspector, row, field, (TimestampType)type, this.timeZone);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalFieldSetter(rowInspector, row, field, decimalType);
        }
        if (type instanceof ArrayType) {
            return new ArrayFieldSetter(rowInspector, row, field, ((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return new MapFieldSetter(rowInspector, row, field, ((MapType)type).getKeyType(), ((MapType)type).getValueType());
        }
        if (type instanceof RowType) {
            return new RowFieldSetter(rowInspector, row, field, type.getTypeParameters());
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private class RowFieldSetter
    extends FieldSetter {
        private final List<Type> fieldTypes;

        public RowFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, List<Type> fieldTypes) {
            super(rowInspector, row, field);
            this.fieldTypes = ImmutableList.copyOf(fieldTypes);
        }

        @Override
        public void setField(Block block, int position) {
            Block rowBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> value = new ArrayList<Object>(this.fieldTypes.size());
            for (int i = 0; i < this.fieldTypes.size(); ++i) {
                value.add(HiveWriteUtils.getField(FieldSetterFactory.this.timeZone, this.fieldTypes.get(i), rowBlock, i));
            }
            this.rowInspector.setStructFieldData(this.row, this.field, value);
        }
    }

    private class MapFieldSetter
    extends FieldSetter {
        private final Type keyType;
        private final Type valueType;

        public MapFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type keyType, Type valueType) {
            super(rowInspector, row, field);
            this.keyType = Objects.requireNonNull(keyType, "keyType is null");
            this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        }

        @Override
        public void setField(Block block, int position) {
            Block mapBlock = (Block)block.getObject(position, Block.class);
            HashMap<Object, Object> map = new HashMap<Object, Object>(mapBlock.getPositionCount() * 2);
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                map.put(HiveWriteUtils.getField(FieldSetterFactory.this.timeZone, this.keyType, mapBlock, i), HiveWriteUtils.getField(FieldSetterFactory.this.timeZone, this.valueType, mapBlock, i + 1));
            }
            this.rowInspector.setStructFieldData(this.row, this.field, map);
        }
    }

    private class ArrayFieldSetter
    extends FieldSetter {
        private final Type elementType;

        public ArrayFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type elementType) {
            super(rowInspector, row, field);
            this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        }

        @Override
        public void setField(Block block, int position) {
            Block arrayBlock = (Block)block.getObject(position, Block.class);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                list.add(HiveWriteUtils.getField(FieldSetterFactory.this.timeZone, this.elementType, arrayBlock, i));
            }
            this.rowInspector.setStructFieldData(this.row, this.field, list);
        }
    }

    private static class DecimalFieldSetter
    extends FieldSetter {
        private final HiveDecimalWritable value = new HiveDecimalWritable();
        private final DecimalType decimalType;

        public DecimalFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, DecimalType decimalType) {
            super(rowInspector, row, field);
            this.decimalType = decimalType;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(HiveWriteUtils.getHiveDecimal(this.decimalType, block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class TimestampFieldSetter
    extends FieldSetter {
        private final DateTimeZone timeZone;
        private final TimestampType type;
        private final TimestampWritableV2 value = new TimestampWritableV2();

        public TimestampFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, TimestampType type, DateTimeZone timeZone) {
            super(rowInspector, row, field);
            this.type = Objects.requireNonNull(type, "type is null");
            this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        }

        @Override
        public void setField(Block block, int position) {
            int picosOfMicro;
            long epochMicros;
            if (this.type.isShort()) {
                epochMicros = this.type.getLong(block, position);
                picosOfMicro = 0;
            } else {
                LongTimestamp longTimestamp = (LongTimestamp)this.type.getObject(block, position);
                epochMicros = longTimestamp.getEpochMicros();
                picosOfMicro = longTimestamp.getPicosOfMicro();
            }
            long epochSeconds = Math.floorDiv(epochMicros, 1000000);
            long picosOfSecond = (long)Math.floorMod(epochMicros, 1000000) * 1000000L + (long)picosOfMicro;
            epochSeconds = this.convertLocalEpochSecondsToUtc(epochSeconds);
            int nanosOfSecond = Math.toIntExact(picosOfSecond / 1000L);
            Timestamp timestamp = Timestamp.ofEpochSecond((long)epochSeconds, (int)nanosOfSecond);
            this.value.set(timestamp);
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }

        private long convertLocalEpochSecondsToUtc(long epochSeconds) {
            long epochMillis = epochSeconds * 1000L;
            epochMillis = this.timeZone.convertLocalToUTC(epochMillis, false);
            return epochMillis / 1000L;
        }
    }

    private static class DateFieldSetter
    extends FieldSetter {
        private final DateWritableV2 value = new DateWritableV2();

        public DateFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Math.toIntExact(DateType.DATE.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BinaryFieldSetter
    extends FieldSetter {
        private final BytesWritable value = new BytesWritable();

        public BinaryFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            byte[] bytes = VarbinaryType.VARBINARY.getSlice(block, position).getBytes();
            this.value.set(bytes, 0, bytes.length);
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class CharFieldSetter
    extends FieldSetter {
        private final Text value = new Text();
        private final Type type;

        public CharFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
            super(rowInspector, row, field);
            this.type = type;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(this.type.getSlice(block, position).getBytes());
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class VarcharFieldSetter
    extends FieldSetter {
        private final Text value = new Text();
        private final Type type;

        public VarcharFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, Type type) {
            super(rowInspector, row, field);
            this.type = type;
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(this.type.getSlice(block, position).getBytes());
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class FloatFieldSetter
    extends FieldSetter {
        private final FloatWritable value = new FloatWritable();

        public FloatFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Float.intBitsToFloat((int)RealType.REAL.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class DoubleFieldSetter
    extends FieldSetter {
        private final DoubleWritable value = new DoubleWritable();

        public DoubleFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(DoubleType.DOUBLE.getDouble(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class TinyintFieldSetter
    extends FieldSetter {
        private final ByteWritable value = new ByteWritable();

        public TinyintFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(SignedBytes.checkedCast((long)TinyintType.TINYINT.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class SmallintFieldSetter
    extends FieldSetter {
        private final ShortWritable value = new ShortWritable();

        public SmallintFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Shorts.checkedCast((long)SmallintType.SMALLINT.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class IntFieldSetter
    extends FieldSetter {
        private final IntWritable value = new IntWritable();

        public IntFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(Math.toIntExact(IntegerType.INTEGER.getLong(block, position)));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BigintFieldSetter
    extends FieldSetter {
        private final LongWritable value = new LongWritable();

        public BigintFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(BigintType.BIGINT.getLong(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    private static class BooleanFieldSetter
    extends FieldSetter {
        private final BooleanWritable value = new BooleanWritable();

        public BooleanFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            super(rowInspector, row, field);
        }

        @Override
        public void setField(Block block, int position) {
            this.value.set(BooleanType.BOOLEAN.getBoolean(block, position));
            this.rowInspector.setStructFieldData(this.row, this.field, (Object)this.value);
        }
    }

    public static abstract class FieldSetter {
        protected final SettableStructObjectInspector rowInspector;
        protected final Object row;
        protected final StructField field;

        private FieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field) {
            this.rowInspector = Objects.requireNonNull(rowInspector, "rowInspector is null");
            this.row = Objects.requireNonNull(row, "row is null");
            this.field = Objects.requireNonNull(field, "field is null");
        }

        public abstract void setField(Block var1, int var2);
    }
}

