/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveViewNotSupportedException;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetadataMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.PrivilegeInfo;
import io.trino.spi.security.RoleGrant;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;

public class SqlStandardAccessControlMetadata
implements AccessControlMetadata {
    private static final Set<String> RESERVED_ROLES = ImmutableSet.of((Object)"all", (Object)"default", (Object)"none");
    private static final String PUBLIC_ROLE_NAME = "public";
    private final SqlStandardAccessControlMetadataMetastore metastore;

    public SqlStandardAccessControlMetadata(SqlStandardAccessControlMetadataMetastore metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    @Override
    public void createRole(ConnectorSession session, String role, Optional<HivePrincipal> grantor) {
        SqlStandardAccessControlMetadata.checkRoleIsNotReserved(role);
        this.metastore.createRole(role, null);
    }

    @Override
    public void dropRole(ConnectorSession session, String role) {
        SqlStandardAccessControlMetadata.checkRoleIsNotReserved(role);
        this.metastore.dropRole(role);
    }

    private static void checkRoleIsNotReserved(String role) {
        if (RESERVED_ROLES.contains(role.toLowerCase(Locale.ENGLISH))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Role name cannot be one of the reserved roles: " + RESERVED_ROLES);
        }
    }

    @Override
    public Set<String> listRoles(ConnectorSession session) {
        return ImmutableSet.copyOf(this.metastore.listRoles());
    }

    @Override
    public Set<RoleGrant> listAllRoleGrants(ConnectorSession session, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
        Set actualRoles = roles.orElseGet(() -> this.metastore.listRoles());
        if (grantees.isPresent() && actualRoles.size() > grantees.get().size() * 2) {
            return this.getRoleGrantsByGrantees(grantees.get(), limit);
        }
        return this.getRoleGrantsByRoles(actualRoles, limit);
    }

    private Set<RoleGrant> getRoleGrantsByGrantees(Set<String> grantees, OptionalLong limit) {
        ImmutableSet.Builder roleGrants = ImmutableSet.builder();
        int count = 0;
        for (String grantee : grantees) {
            for (PrincipalType type : new PrincipalType[]{PrincipalType.USER, PrincipalType.ROLE}) {
                if (limit.isPresent() && (long)count >= limit.getAsLong()) {
                    return roleGrants.build();
                }
                for (RoleGrant grant : this.metastore.listRoleGrants(new HivePrincipal(type, grantee))) {
                    if (PUBLIC_ROLE_NAME.equals(grant.getRoleName())) continue;
                    ++count;
                    roleGrants.add((Object)grant);
                }
            }
        }
        return roleGrants.build();
    }

    private Set<RoleGrant> getRoleGrantsByRoles(Set<String> roles, OptionalLong limit) {
        ImmutableSet.Builder roleGrants = ImmutableSet.builder();
        int count = 0;
        for (String role : roles) {
            if (limit.isPresent() && (long)count >= limit.getAsLong()) break;
            for (RoleGrant grant : this.metastore.listGrantedPrincipals(role)) {
                ++count;
                roleGrants.add((Object)grant);
            }
        }
        return roleGrants.build();
    }

    @Override
    public Set<RoleGrant> listRoleGrants(ConnectorSession session, HivePrincipal principal) {
        return ImmutableSet.copyOf(this.metastore.listRoleGrants(principal));
    }

    @Override
    public void grantRoles(ConnectorSession session, Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, Optional<HivePrincipal> grantor) {
        this.metastore.grantRoles(roles, grantees, adminOption, grantor.orElse(new HivePrincipal(PrincipalType.USER, session.getUser())));
    }

    @Override
    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, Optional<HivePrincipal> grantor) {
        this.metastore.revokeRoles(roles, grantees, adminOption, grantor.orElse(new HivePrincipal(PrincipalType.USER, session.getUser())));
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, HivePrincipal principal) {
        return (Set)ThriftMetastoreUtil.listApplicableRoles(principal, this.metastore::listRoleGrants).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<String> listEnabledRoles(ConnectorSession session) {
        return (Set)ThriftMetastoreUtil.listEnabledRoles(session.getIdentity(), this.metastore::listRoleGrants).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, HivePrincipal grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set<HivePrivilegeInfo> hivePrivilegeInfos = privileges.stream().map(privilege -> new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege(privilege), grantOption, new HivePrincipal(PrincipalType.USER, session.getUser()), new HivePrincipal(PrincipalType.USER, session.getUser()))).collect(Collectors.toSet());
        this.metastore.grantTablePrivileges(new HiveIdentity(session), schemaName, tableName, grantee, hivePrivilegeInfos);
    }

    @Override
    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, HivePrincipal grantee, boolean grantOption) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Set<HivePrivilegeInfo> hivePrivilegeInfos = privileges.stream().map(privilege -> new HivePrivilegeInfo(HivePrivilegeInfo.toHivePrivilege(privilege), grantOption, new HivePrincipal(PrincipalType.USER, session.getUser()), new HivePrincipal(PrincipalType.USER, session.getUser()))).collect(Collectors.toSet());
        this.metastore.revokeTablePrivileges(new HiveIdentity(session), schemaName, tableName, grantee, hivePrivilegeInfos);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(ConnectorSession session, List<SchemaTableName> tableNames) {
        Set principals = (Set)ThriftMetastoreUtil.listEnabledPrincipals(session.getIdentity(), this.metastore::listRoleGrants).collect(ImmutableSet.toImmutableSet());
        boolean isAdminRoleSet = SqlStandardAccessControlMetadata.hasAdminRole(principals);
        ImmutableList.Builder result = ImmutableList.builder();
        for (SchemaTableName tableName : tableNames) {
            try {
                result.addAll(this.buildGrants(session, principals, isAdminRoleSet, tableName));
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (HiveViewNotSupportedException hiveViewNotSupportedException) {}
        }
        return result.build();
    }

    private List<GrantInfo> buildGrants(ConnectorSession session, Set<HivePrincipal> principals, boolean isAdminRoleSet, SchemaTableName tableName) {
        if (isAdminRoleSet) {
            return this.buildGrants(session, tableName, Optional.empty());
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (HivePrincipal grantee : principals) {
            result.addAll(this.buildGrants(session, tableName, Optional.of(grantee)));
        }
        return result.build();
    }

    private List<GrantInfo> buildGrants(ConnectorSession session, SchemaTableName tableName, Optional<HivePrincipal> principal) {
        ImmutableList.Builder result = ImmutableList.builder();
        Set<HivePrivilegeInfo> hivePrivileges = this.metastore.listTablePrivileges(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName(), principal);
        for (HivePrivilegeInfo hivePrivilege : hivePrivileges) {
            Set<PrivilegeInfo> prestoPrivileges = hivePrivilege.toPrivilegeInfo();
            for (PrivilegeInfo prestoPrivilege : prestoPrivileges) {
                GrantInfo grant = new GrantInfo(prestoPrivilege, hivePrivilege.getGrantee().toTrinoPrincipal(), tableName, Optional.of(hivePrivilege.getGrantor().toTrinoPrincipal()), Optional.empty());
                result.add((Object)grant);
            }
        }
        return result.build();
    }

    private static boolean hasAdminRole(Set<HivePrincipal> roles) {
        return roles.stream().anyMatch(principal -> principal.getName().equalsIgnoreCase("admin"));
    }
}

