/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.Field;
import io.trino.parquet.GroupField;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOUtil;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.Type;

public final class HiveParquetColumnIOConverter {
    private HiveParquetColumnIOConverter() {
    }

    public static Optional<Field> constructField(Type type, ColumnIO columnIO) {
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = ColumnIOUtil.columnRepetitionLevel((ColumnIO)columnIO);
        int definitionLevel = ColumnIOUtil.columnDefinitionLevel((ColumnIO)columnIO);
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List fields = rowType.getFields();
            boolean structHasParameters = false;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field rowField = (RowType.Field)fields.get(i);
                String name = ((String)rowField.getName().orElseThrow()).toLowerCase(Locale.ENGLISH);
                Optional<Field> field = HiveParquetColumnIOConverter.constructField(rowField.getType(), ParquetTypeUtils.lookupColumnByName((GroupColumnIO)groupColumnIO, (String)name));
                structHasParameters |= field.isPresent();
                fieldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)fieldsBuilder.build()));
            }
            return Optional.empty();
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn((GroupColumnIO)groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() != 2) {
                return Optional.empty();
            }
            Optional<Field> keyField = HiveParquetColumnIOConverter.constructField(mapType.getKeyType(), keyValueColumnIO.getChild(0));
            Optional<Field> valueField = HiveParquetColumnIOConverter.constructField(mapType.getValueType(), keyValueColumnIO.getChild(1));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)ImmutableList.of(keyField, valueField)));
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            if (groupColumnIO.getChildrenCount() != 1) {
                return Optional.empty();
            }
            Optional<Field> field = HiveParquetColumnIOConverter.constructField(arrayType.getElementType(), ParquetTypeUtils.getArrayElementColumn((ColumnIO)groupColumnIO.getChild(0)));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        RichColumnDescriptor column = new RichColumnDescriptor(primitiveColumnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
        return Optional.of(new PrimitiveField(type, repetitionLevel, definitionLevel, required, column, primitiveColumnIO.getId()));
    }
}

