/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import io.trino.orc.OrcCorruptionException;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.BackgroundHiveSplitLoader;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;

@NotThreadSafe
public class OrcDeletedRows {
    private static final int ORIGINAL_TRANSACTION_INDEX = 0;
    private static final int BUCKET_ID_INDEX = 1;
    private static final int ROW_ID_INDEX = 2;
    private final String sourceFileName;
    private final OrcDeleteDeltaPageSourceFactory pageSourceFactory;
    private final ConnectorIdentity identity;
    private final Configuration configuration;
    private final HdfsEnvironment hdfsEnvironment;
    private final AcidInfo acidInfo;
    private final OptionalInt bucketNumber;
    @Nullable
    private Set<RowId> deletedRows;

    public OrcDeletedRows(String sourceFileName, OrcDeleteDeltaPageSourceFactory pageSourceFactory, ConnectorIdentity identity, Configuration configuration, HdfsEnvironment hdfsEnvironment, AcidInfo acidInfo, OptionalInt bucketNumber) {
        this.sourceFileName = Objects.requireNonNull(sourceFileName, "sourceFileName is null");
        this.pageSourceFactory = Objects.requireNonNull(pageSourceFactory, "pageSourceFactory is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.acidInfo = Objects.requireNonNull(acidInfo, "acidInfo is null");
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
    }

    public MaskDeletedRowsFunction getMaskDeletedRowsFunction(Page sourcePage, OptionalLong startRowId) {
        return new MaskDeletedRows(sourcePage, startRowId);
    }

    private Set<RowId> getDeletedRows() {
        if (this.deletedRows != null) {
            return this.deletedRows;
        }
        ImmutableSet.Builder deletedRowsBuilder = ImmutableSet.builder();
        for (AcidInfo.DeleteDeltaInfo deleteDeltaInfo : this.acidInfo.getDeleteDeltas()) {
            Path path = OrcDeletedRows.createPath(this.acidInfo, deleteDeltaInfo, this.sourceFileName);
            try {
                FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(this.identity, path, this.configuration);
                FileStatus fileStatus = this.hdfsEnvironment.doAs(this.identity, () -> fileSystem.getFileStatus(path));
                ConnectorPageSource pageSource = this.pageSourceFactory.createPageSource(fileStatus.getPath(), fileStatus.getLen()).orElseGet(() -> new EmptyPageSource());
                try {
                    while (!pageSource.isFinished()) {
                        Page page = pageSource.getNextPage();
                        if (page == null) continue;
                        for (int i = 0; i < page.getPositionCount(); ++i) {
                            long originalTransaction = BigintType.BIGINT.getLong(page.getBlock(0), i);
                            int encodedBucketValue = Math.toIntExact(IntegerType.INTEGER.getLong(page.getBlock(1), i));
                            BucketCodec bucketCodec = BucketCodec.determineVersion((int)encodedBucketValue);
                            int bucket = bucketCodec.decodeWriterId(encodedBucketValue);
                            int statement = bucketCodec.decodeStatementId(encodedBucketValue);
                            long row = BigintType.BIGINT.getLong(page.getBlock(2), i);
                            RowId rowId = new RowId(originalTransaction, bucket, statement, row);
                            deletedRowsBuilder.add((Object)rowId);
                        }
                    }
                }
                finally {
                    if (pageSource == null) continue;
                    pageSource.close();
                }
            }
            catch (FileNotFoundException fileSystem) {
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (OrcCorruptionException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Failed to read ORC delete delta file: " + path, (Throwable)e);
            }
            catch (IOException | RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, "Failed to read ORC delete delta file: " + path, (Throwable)e);
            }
        }
        this.deletedRows = deletedRowsBuilder.build();
        return this.deletedRows;
    }

    private static Path createPath(AcidInfo acidInfo, AcidInfo.DeleteDeltaInfo deleteDeltaInfo, String fileName) {
        Path directory = new Path(acidInfo.getPartitionLocation(), deleteDeltaInfo.getDirectoryName());
        if (BackgroundHiveSplitLoader.hasAttemptId(fileName)) {
            return new Path(directory, fileName.substring(0, fileName.lastIndexOf("_")));
        }
        if (acidInfo.getOriginalFiles().size() > 0) {
            return AcidUtils.createBucketFile((Path)directory, (int)acidInfo.getBucketId());
        }
        return new Path(directory, fileName);
    }

    private static class RowId {
        private final long originalTransaction;
        private final int bucket;
        private final int statementId;
        private final long rowId;

        public RowId(long originalTransaction, int bucket, int statementId, long rowId) {
            this.originalTransaction = originalTransaction;
            this.bucket = bucket;
            this.statementId = statementId;
            this.rowId = rowId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowId other = (RowId)o;
            return this.originalTransaction == other.originalTransaction && this.bucket == other.bucket && this.statementId == other.statementId && this.rowId == other.rowId;
        }

        public int hashCode() {
            return Objects.hash(this.originalTransaction, this.bucket, this.statementId, this.rowId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("originalTransaction", this.originalTransaction).add("bucket", this.bucket).add("statementId", this.statementId).add("rowId", this.rowId).toString();
        }
    }

    @NotThreadSafe
    private class MaskDeletedRows
    implements MaskDeletedRowsFunction {
        @Nullable
        private Page sourcePage;
        private int positionCount;
        @Nullable
        private int[] validPositions;
        private final OptionalLong startRowId;

        public MaskDeletedRows(Page sourcePage, OptionalLong startRowId) {
            this.sourcePage = Objects.requireNonNull(sourcePage, "sourcePage is null");
            this.startRowId = Objects.requireNonNull(startRowId, "startRowId is null");
        }

        @Override
        public int getPositionCount() {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            return this.positionCount;
        }

        @Override
        public Block apply(Block block) {
            if (this.sourcePage != null) {
                this.loadValidPositions();
                Verify.verify((this.sourcePage == null ? 1 : 0) != 0);
            }
            if (this.positionCount == block.getPositionCount()) {
                return block;
            }
            return new DictionaryBlock(this.positionCount, block, this.validPositions);
        }

        private void loadValidPositions() {
            Verify.verify((this.sourcePage != null ? 1 : 0) != 0, (String)"sourcePage is null", (Object[])new Object[0]);
            Set<RowId> deletedRows = OrcDeletedRows.this.getDeletedRows();
            if (deletedRows.isEmpty()) {
                this.positionCount = this.sourcePage.getPositionCount();
                this.sourcePage = null;
                return;
            }
            int[] validPositions = new int[this.sourcePage.getPositionCount()];
            int validPositionsIndex = 0;
            for (int position = 0; position < this.sourcePage.getPositionCount(); ++position) {
                RowId rowId = this.getRowId(position);
                if (deletedRows.contains(rowId)) continue;
                validPositions[validPositionsIndex] = position;
                ++validPositionsIndex;
            }
            this.positionCount = validPositionsIndex;
            this.validPositions = validPositions;
            this.sourcePage = null;
        }

        private RowId getRowId(int position) {
            long row;
            int statementId;
            int bucket;
            long originalTransaction;
            if (this.startRowId.isPresent()) {
                originalTransaction = 0L;
                bucket = OrcDeletedRows.this.bucketNumber.orElse(0);
                statementId = 0;
                row = this.startRowId.getAsLong() + (long)position;
            } else {
                originalTransaction = BigintType.BIGINT.getLong(this.sourcePage.getBlock(0), position);
                int encodedBucketValue = Math.toIntExact(IntegerType.INTEGER.getLong(this.sourcePage.getBlock(1), position));
                BucketCodec bucketCodec = BucketCodec.determineVersion((int)encodedBucketValue);
                bucket = bucketCodec.decodeWriterId(encodedBucketValue);
                statementId = bucketCodec.decodeStatementId(encodedBucketValue);
                row = BigintType.BIGINT.getLong(this.sourcePage.getBlock(2), position);
            }
            return new RowId(originalTransaction, bucket, statementId, row);
        }
    }

    public static interface MaskDeletedRowsFunction {
        public int getPositionCount();

        public Block apply(Block var1);

        public static MaskDeletedRowsFunction noMaskForPage(final Page page) {
            return new MaskDeletedRowsFunction(){
                int positionCount;
                {
                    this.positionCount = page.getPositionCount();
                }

                @Override
                public int getPositionCount() {
                    return this.positionCount;
                }

                @Override
                public Block apply(Block block) {
                    return block;
                }
            };
        }
    }
}

