/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveViewNotSupportedException;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.MetastoreConfig;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.CoalescingCounter;
import io.trino.plugin.hive.metastore.thrift.MetastoreLocator;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreAuthenticationConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.RetryDriver;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ThriftHiveMetastore
implements ThriftMetastore {
    private static final Logger log = Logger.get(ThriftHiveMetastore.class);
    private static final int MAX_SET_DATE_STATISTICS_ATTEMPTS = 100;
    private static final String DEFAULT_METASTORE_USER = "presto";
    private final ThriftMetastoreStats stats = new ThriftMetastoreStats();
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final MetastoreLocator clientProvider;
    private final double backoffScaleFactor;
    private final Duration minBackoffDelay;
    private final Duration maxBackoffDelay;
    private final Duration maxRetryTime;
    private final Duration maxWaitForLock;
    private final int maxRetries;
    private final boolean impersonationEnabled;
    private final boolean authenticationEnabled;
    private final LoadingCache<String, String> delegationTokenCache;
    private final boolean deleteFilesOnDrop;
    private final boolean translateHiveViews;
    private final AtomicInteger chosenGetTableAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger chosenTableParamAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger chosesGetAllViewsAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicReference<Optional<Boolean>> metastoreSupportsDateStatistics = new AtomicReference(Optional.empty());
    private final CoalescingCounter metastoreSetDateStatisticsFailures = new CoalescingCounter(new Duration(1.0, TimeUnit.SECONDS));
    private static final Pattern TABLE_PARAMETER_SAFE_KEY_PATTERN = Pattern.compile("^[a-zA-Z_]+$");
    private static final Pattern TABLE_PARAMETER_SAFE_VALUE_PATTERN = Pattern.compile("^[a-zA-Z0-9\\s]*$");
    private final boolean assumeCanonicalPartitionKeys;

    @Inject
    public ThriftHiveMetastore(MetastoreLocator metastoreLocator, HiveConfig hiveConfig, MetastoreConfig metastoreConfig, ThriftMetastoreConfig thriftConfig, ThriftMetastoreAuthenticationConfig authenticationConfig, HdfsEnvironment hdfsEnvironment) {
        this(metastoreLocator, hiveConfig, metastoreConfig, thriftConfig, hdfsEnvironment, authenticationConfig.getAuthenticationType() != ThriftMetastoreAuthenticationConfig.ThriftMetastoreAuthenticationType.NONE);
    }

    public ThriftHiveMetastore(MetastoreLocator metastoreLocator, HiveConfig hiveConfig, MetastoreConfig metastoreConfig, ThriftMetastoreConfig thriftConfig, HdfsEnvironment hdfsEnvironment, boolean authenticationEnabled) {
        this.hdfsContext = new HdfsEnvironment.HdfsContext(ConnectorIdentity.ofUser((String)DEFAULT_METASTORE_USER));
        this.clientProvider = Objects.requireNonNull(metastoreLocator, "metastoreLocator is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.backoffScaleFactor = thriftConfig.getBackoffScaleFactor();
        this.minBackoffDelay = thriftConfig.getMinBackoffDelay();
        this.maxBackoffDelay = thriftConfig.getMaxBackoffDelay();
        this.maxRetryTime = thriftConfig.getMaxRetryTime();
        this.maxRetries = thriftConfig.getMaxRetries();
        this.impersonationEnabled = thriftConfig.isImpersonationEnabled();
        this.deleteFilesOnDrop = thriftConfig.isDeleteFilesOnDrop();
        Objects.requireNonNull(hiveConfig, "hiveConfig is null");
        this.translateHiveViews = hiveConfig.isTranslateHiveViews();
        Objects.requireNonNull(metastoreConfig, "metastoreConfig is null");
        Preconditions.checkArgument((!metastoreConfig.isHideDeltaLakeTables() ? 1 : 0) != 0, (Object)"Hiding Delta Lake tables is not supported");
        this.maxWaitForLock = thriftConfig.getMaxWaitForTransactionLock();
        this.authenticationEnabled = authenticationEnabled;
        this.delegationTokenCache = CacheBuilder.newBuilder().expireAfterWrite(thriftConfig.getDelegationTokenCacheTtl().toMillis(), TimeUnit.MILLISECONDS).maximumSize(thriftConfig.getDelegationTokenCacheMaximumSize()).build(CacheLoader.from(this::loadDelegationToken));
        this.assumeCanonicalPartitionKeys = thriftConfig.isAssumeCanonicalPartitionKeys();
    }

    @Managed
    @Flatten
    public ThriftMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<String> list = client.getAllDatabases();
                    return list;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<Database> optional = Optional.of(client.getDatabase(databaseName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<String> list = client.getAllTables(databaseName);
                    return list;
                }
            });
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getTablesWithParameter", this.stats.getGetTablesWithParameter().wrap(() -> this.doGetTablesWithParameter(databaseName, parameterKey, parameterValue)));
        }
        catch (UnknownDBException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<org.apache.hadoop.hive.metastore.api.Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(() -> {
                org.apache.hadoop.hive.metastore.api.Table table = this.getTableFromMetastore(identity, databaseName, tableName);
                return Optional.of(table);
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private org.apache.hadoop.hive.metastore.api.Table getTableFromMetastore(HiveIdentity identity, String databaseName, String tableName) throws TException {
        return (org.apache.hadoop.hive.metastore.api.Table)this.alternativeCall(() -> this.createMetastoreClient(identity), ThriftHiveMetastore::defaultIsValidExceptionalResponse, this.chosenGetTableAlternative, client -> client.getTableWithCapabilities(databaseName, tableName), client -> client.getTable(databaseName, tableName));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ThriftMetastoreUtil.getSupportedColumnStatistics(type);
    }

    @Override
    public PartitionStatistics getTableStatistics(HiveIdentity identity, org.apache.hadoop.hive.metastore.api.Table table) {
        List dataColumns = (List)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        HiveBasicStatistics basicStatistics = ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters());
        Map<String, HiveColumnStatistics> columnStatistics = this.getTableColumnStatistics(identity, table.getDbName(), table.getTableName(), dataColumns, basicStatistics.getRowCount());
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private Map<String, HiveColumnStatistics> getTableColumnStatistics(HiveIdentity identity, String databaseName, String tableName, List<String> columns, OptionalLong rowCount) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTableColumnStatistics", this.stats.getGetTableColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Map<String, HiveColumnStatistics> map = this.groupStatisticsByColumn(client.getTableColumnStatistics(databaseName, tableName, columns), rowCount);
                    return map;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, org.apache.hadoop.hive.metastore.api.Table table, List<Partition> partitions) {
        List dataColumns = (List)table.getSd().getCols().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        List partitionColumns = (List)table.getPartitionKeys().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        Map partitionBasicStatistics = (Map)partitions.stream().collect(ImmutableMap.toImmutableMap(partition -> FileUtils.makePartName((List)partitionColumns, (List)partition.getValues()), partition -> ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters())));
        Map partitionRowCounts = (Map)partitionBasicStatistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((HiveBasicStatistics)entry.getValue()).getRowCount()));
        Map<String, Map<String, HiveColumnStatistics>> partitionColumnStatistics = this.getPartitionColumnStatistics(identity, table.getDbName(), table.getTableName(), partitionBasicStatistics.keySet(), dataColumns, partitionRowCounts);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (String partitionName : partitionBasicStatistics.keySet()) {
            HiveBasicStatistics basicStatistics = (HiveBasicStatistics)partitionBasicStatistics.get(partitionName);
            Map<String, HiveColumnStatistics> columnStatistics = partitionColumnStatistics.getOrDefault(partitionName, (Map<String, HiveColumnStatistics>)ImmutableMap.of());
            result.put((Object)partitionName, (Object)new PartitionStatistics(basicStatistics, columnStatistics));
        }
        return result.build();
    }

    @Override
    public Optional<List<FieldSchema>> getFields(HiveIdentity identity, String databaseName, String tableName) {
        try {
            return this.retry().stopOn(MetaException.class, UnknownTableException.class, UnknownDBException.class).stopOnIllegalExceptions().run("getFields", this.stats.getGetFields().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Optional<ImmutableList> optional = Optional.of(ImmutableList.copyOf(client.getFields(databaseName, tableName)));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames, Map<String, OptionalLong> partitionRowCounts) {
        return (Map)this.getMetastorePartitionColumnStatistics(identity, databaseName, tableName, partitionNames, columnNames).entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.groupStatisticsByColumn((List)entry.getValue(), partitionRowCounts.getOrDefault(entry.getKey(), OptionalLong.empty()))));
    }

    private Map<String, List<ColumnStatisticsObj>> getMetastorePartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, Set<String> partitionNames, List<String> columnNames) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getPartitionColumnStatistics", this.stats.getGetPartitionColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Map<String, List<ColumnStatisticsObj>> map = client.getPartitionColumnStatistics(databaseName, tableName, (List<String>)ImmutableList.copyOf((Collection)partitionNames), columnNames);
                    return map;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private Map<String, HiveColumnStatistics> groupStatisticsByColumn(List<ColumnStatisticsObj> statistics, OptionalLong rowCount) {
        return (Map)statistics.stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsObj::getColName, statisticsObj -> ThriftMetastoreUtil.fromMetastoreApiColumnStatistics(statisticsObj, rowCount)));
    }

    @Override
    public void updateTableStatistics(HiveIdentity identity, String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        org.apache.hadoop.hive.metastore.api.Table originalTable = this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        PartitionStatistics currentStatistics = this.getTableStatistics(identity, originalTable);
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        org.apache.hadoop.hive.metastore.api.Table modifiedTable = originalTable.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedTable.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedTable.getParameters(), basicStatistics));
        if (transaction.isAcidTransactionRunning()) {
            modifiedTable.setWriteId(transaction.getWriteId());
        }
        this.alterTable(identity, databaseName, tableName, modifiedTable);
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable(modifiedTable);
        OptionalLong rowCount = basicStatistics.getRowCount();
        List metastoreColumnStatistics = (List)updatedStatistics.getColumnStatistics().entrySet().stream().flatMap(entry -> {
            Optional<Column> column = table.getColumn((String)entry.getKey());
            if (column.isEmpty() && ThriftMetastoreUtil.isAvroTableWithSchemaSet(modifiedTable)) {
                return Stream.of(new ColumnStatisticsObj[0]);
            }
            HiveType type = column.orElseThrow(() -> new IllegalStateException("Column not found: " + (String)entry.getKey())).getType();
            return Stream.of(ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), type, (HiveColumnStatistics)entry.getValue(), rowCount));
        }).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setTableColumnStatistics(identity, databaseName, tableName, metastoreColumnStatistics);
        }
        Sets.SetView removedColumnStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedColumnStatistics.forEach(column -> this.deleteTableColumnStatistics(identity, databaseName, tableName, (String)column));
    }

    private void setTableColumnStatistics(HiveIdentity identity, String databaseName, String tableName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setTableColumnStatistics", this.stats.getSetTableColumnStatistics().wrap(() -> {
                this.setColumnStatistics(identity, String.format("table %s.%s", databaseName, tableName), statistics, (client, stats) -> client.setTableColumnStatistics(databaseName, tableName, (List<ColumnStatisticsObj>)stats));
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deleteTableColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deleteTableColumnStatistics", this.stats.getDeleteTableColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.deleteTableColumnStatistics(databaseName, tableName, columnName);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void updatePartitionStatistics(HiveIdentity identity, org.apache.hadoop.hive.metastore.api.Table table, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        List<Partition> partitions = this.getPartitionsByNames(identity, table.getDbName(), table.getTableName(), (List<String>)ImmutableList.of((Object)partitionName));
        if (partitions.size() != 1) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Metastore returned multiple partitions for name: " + partitionName);
        }
        Partition originalPartition = (Partition)Iterables.getOnlyElement(partitions);
        PartitionStatistics currentStatistics = Objects.requireNonNull(this.getPartitionStatistics(identity, table, partitions).get(partitionName), "getPartitionStatistics() did not return statistics for partition");
        PartitionStatistics updatedStatistics = update.apply(currentStatistics);
        Partition modifiedPartition = originalPartition.deepCopy();
        HiveBasicStatistics basicStatistics = updatedStatistics.getBasicStatistics();
        modifiedPartition.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(modifiedPartition.getParameters(), basicStatistics));
        this.alterPartitionWithoutStatistics(identity, table.getDbName(), table.getTableName(), modifiedPartition);
        Map columns = (Map)modifiedPartition.getSd().getCols().stream().collect(ImmutableMap.toImmutableMap(FieldSchema::getName, schema -> HiveType.valueOf(schema.getType())));
        this.setPartitionColumnStatistics(identity, table.getDbName(), table.getTableName(), partitionName, columns, updatedStatistics.getColumnStatistics(), basicStatistics.getRowCount());
        Sets.SetView removedStatistics = Sets.difference(currentStatistics.getColumnStatistics().keySet(), updatedStatistics.getColumnStatistics().keySet());
        removedStatistics.forEach(column -> this.deletePartitionColumnStatistics(identity, table.getDbName(), table.getTableName(), partitionName, (String)column));
    }

    private void setPartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, Map<String, HiveType> columns, Map<String, HiveColumnStatistics> columnStatistics, OptionalLong rowCount) {
        List metastoreColumnStatistics = (List)columnStatistics.entrySet().stream().filter(entry -> columns.containsKey(entry.getKey())).map(entry -> ThriftMetastoreUtil.createMetastoreColumnStatistics((String)entry.getKey(), (HiveType)columns.get(entry.getKey()), (HiveColumnStatistics)entry.getValue(), rowCount)).collect(ImmutableList.toImmutableList());
        if (!metastoreColumnStatistics.isEmpty()) {
            this.setPartitionColumnStatistics(identity, databaseName, tableName, partitionName, metastoreColumnStatistics);
        }
    }

    private void setPartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("setPartitionColumnStatistics", this.stats.getSetPartitionColumnStatistics().wrap(() -> {
                this.setColumnStatistics(identity, String.format("partition of table %s.%s", databaseName, tableName), statistics, (client, stats) -> client.setPartitionColumnStatistics(databaseName, tableName, partitionName, (List<ColumnStatisticsObj>)stats));
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void deletePartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, String columnName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidObjectException.class, MetaException.class, InvalidInputException.class).stopOnIllegalExceptions().run("deletePartitionColumnStatistics", this.stats.getDeletePartitionColumnStatistics().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.deletePartitionColumnStatistics(databaseName, tableName, partitionName, columnName);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void setColumnStatistics(HiveIdentity identity, String objectName, List<ColumnStatisticsObj> statistics, Call1<List<ColumnStatisticsObj>> saveColumnStatistics) throws TException {
        boolean containsDateStatistics = statistics.stream().anyMatch(stats -> stats.getStatsData().isSetDateStats());
        Optional<Boolean> metastoreSupportsDateStatistics = this.metastoreSupportsDateStatistics.get();
        if (containsDateStatistics && metastoreSupportsDateStatistics.equals(Optional.of(Boolean.FALSE))) {
            log.debug("Skipping date statistics for %s because metastore does not support them", new Object[]{objectName});
            statistics = (List)statistics.stream().filter(stats -> !stats.getStatsData().isSetDateStats()).collect(ImmutableList.toImmutableList());
            containsDateStatistics = false;
        }
        if (!containsDateStatistics || metastoreSupportsDateStatistics.equals(Optional.of(Boolean.TRUE))) {
            try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                saveColumnStatistics.call(client, statistics);
            }
            return;
        }
        List statisticsExceptDate = (List)statistics.stream().filter(stats -> !stats.getStatsData().isSetDateStats()).collect(ImmutableList.toImmutableList());
        List dateStatistics = (List)statistics.stream().filter(stats -> stats.getStatsData().isSetDateStats()).collect(ImmutableList.toImmutableList());
        Verify.verify((!dateStatistics.isEmpty() && metastoreSupportsDateStatistics.equals(Optional.empty()) ? 1 : 0) != 0);
        try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
            saveColumnStatistics.call(client, statisticsExceptDate);
            try {
                saveColumnStatistics.call(client, dateStatistics);
            }
            catch (TException e) {
                log.warn((Throwable)e, "Failed to save date statistics for %s. Metastore might not support date statistics", new Object[]{objectName});
                if (!statisticsExceptDate.isEmpty() && this.metastoreSetDateStatisticsFailures.incrementAndGet() >= 100L) {
                    this.metastoreSupportsDateStatistics.set(Optional.of(Boolean.FALSE));
                }
                if (client != null) {
                    client.close();
                }
                return;
            }
        }
        this.metastoreSupportsDateStatistics.set(Optional.of(Boolean.TRUE));
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("createRole", this.stats.getCreateRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.createRole(role, grantor);
                    Object var4_4 = null;
                    return var4_4;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("dropRole", this.stats.getDropRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.dropRole(role);
                    Object var3_3 = null;
                    return var3_3;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<String> listRoles() {
        try {
            return (Set)this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoles", this.stats.getListRoles().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    ImmutableSet immutableSet = ImmutableSet.copyOf(client.getRoleNames());
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        for (HivePrincipal grantee : grantees) {
            for (String role : roles) {
                this.grantRole(role, grantee.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(grantee.getType()), grantor.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(grantor.getType()), adminOption);
            }
        }
    }

    private void grantRole(String role, String granteeName, org.apache.hadoop.hive.metastore.api.PrincipalType granteeType, String grantorName, org.apache.hadoop.hive.metastore.api.PrincipalType grantorType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("grantRole", this.stats.getGrantRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.grantRole(role, granteeName, granteeType, grantorName, grantorType, grantOption);
                    Object var8_8 = null;
                    return var8_8;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        for (HivePrincipal grantee : grantees) {
            for (String role : roles) {
                this.revokeRole(role, grantee.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(grantee.getType()), adminOption);
            }
        }
    }

    private void revokeRole(String role, String granteeName, org.apache.hadoop.hive.metastore.api.PrincipalType granteeType, boolean grantOption) {
        try {
            this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("revokeRole", this.stats.getRevokeRole().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    client.revokeRole(role, granteeName, granteeType, grantOption);
                    Object var6_6 = null;
                    return var6_6;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        try {
            return this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listPrincipals", this.stats.getListGrantedPrincipals().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Set<RoleGrant> set = ThriftMetastoreUtil.fromRolePrincipalGrants(client.listGrantedPrincipals(role));
                    return set;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        try {
            return this.retry().stopOn(MetaException.class).stopOnIllegalExceptions().run("listRoleGrants", this.stats.getListRoleGrants().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    Set<RoleGrant> set = ThriftMetastoreUtil.fromRolePrincipalGrants(client.listRoleGrants(principal.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(principal.getType())));
                    return set;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getGetAllViews().wrap(() -> {
                if (this.translateHiveViews) {
                    return (List)this.alternativeCall(this::createMetastoreClient, exception -> !ThriftHiveMetastore.isUnknownMethodExceptionalResponse(exception), this.chosesGetAllViewsAlternative, client -> client.getTableNamesByType(databaseName, TableType.VIRTUAL_VIEW.name()), client -> this.doGetTablesWithParameter(databaseName, "presto_view", "true"));
                }
                return this.doGetTablesWithParameter(databaseName, "presto_view", "true");
            }));
        }
        catch (UnknownDBException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private List<String> doGetTablesWithParameter(String databaseName, String parameterKey, String parameterValue) throws TException {
        Preconditions.checkArgument((boolean)TABLE_PARAMETER_SAFE_KEY_PATTERN.matcher(parameterKey).matches(), (String)"Parameter key contains invalid characters: '%s'", (Object)parameterKey);
        Preconditions.checkArgument((boolean)TABLE_PARAMETER_SAFE_VALUE_PATTERN.matcher(parameterValue).matches(), (String)"Parameter value contains invalid characters: '%s'", (Object)parameterValue);
        String filterWithEquals = "hive_filter_field_params__" + parameterKey + " = \"" + parameterValue + "\"";
        String filterWithLike = "hive_filter_field_params__" + parameterKey + " LIKE \"" + parameterValue + "\"";
        return (List)this.alternativeCall(this::createMetastoreClient, ThriftHiveMetastore::defaultIsValidExceptionalResponse, this.chosenTableParamAlternative, client -> client.getTableNamesByFilter(databaseName, filterWithEquals), client -> client.getTableNamesByFilter(databaseName, filterWithLike));
    }

    @Override
    public void createDatabase(HiveIdentity identity, Database database) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class).stopOnIllegalExceptions().run("createDatabase", this.stats.getCreateDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.createDatabase(database);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getName());
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropDatabase(HiveIdentity identity, String databaseName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidOperationException.class).stopOnIllegalExceptions().run("dropDatabase", this.stats.getDropDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.dropDatabase(databaseName, true, false);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterDatabase(HiveIdentity identity, String databaseName, Database database) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterDatabase", this.stats.getAlterDatabase().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.alterDatabase(databaseName, database);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void createTable(HiveIdentity identity, org.apache.hadoop.hive.metastore.api.Table table) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.createTable(table);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(table.getDbName());
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropTable(HiveIdentity identity, String databaseName, String tableName, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    org.apache.hadoop.hive.metastore.api.Table table = client.getTable(databaseName, tableName);
                    client.dropTable(databaseName, tableName, deleteData);
                    String tableLocation = table.getSd().getLocation();
                    if (this.deleteFilesOnDrop && deleteData && ThriftHiveMetastore.isManagedTable(table) && !Strings.isNullOrEmpty((String)tableLocation)) {
                        ThriftHiveMetastore.deleteDirRecursive(this.hdfsContext, this.hdfsEnvironment, new Path(tableLocation));
                    }
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private static void deleteDirRecursive(HdfsEnvironment.HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        try {
            hdfsEnvironment.getFileSystem(context, path).delete(path, true);
        }
        catch (IOException | RuntimeException e) {
            log.warn((Throwable)e, "Failed to delete path: " + path.toString());
        }
    }

    private static boolean isManagedTable(org.apache.hadoop.hive.metastore.api.Table table) {
        return table.getTableType().equals(TableType.MANAGED_TABLE.name());
    }

    @Override
    public void alterTable(HiveIdentity identity, String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) {
        try {
            this.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("alterTable", this.stats.getAlterTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    EnvironmentContext context = new EnvironmentContext();
                    context.setProperties((Map)ImmutableMap.of((Object)"DO_NOT_UPDATE_STATS", (Object)"true"));
                    client.alterTableWithEnvironmentContext(databaseName, tableName, table, context);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterTransactionalTable(HiveIdentity identity, org.apache.hadoop.hive.metastore.api.Table table, long transactionId, long writeId) {
        try {
            this.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("alterTransactionalTable", this.stats.getAlterTransactionalTable().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.alterTransactionalTable(table, transactionId, writeId, new EnvironmentContext());
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(HiveIdentity identity, String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        Preconditions.checkArgument((!columnNames.isEmpty() || partitionKeysFilter.isAll() ? 1 : 0) != 0, (Object)"must pass in all columnNames or the filter must be all");
        Optional<List<String>> parts = MetastoreUtil.partitionKeyFilterToStringList(columnNames, partitionKeysFilter, this.assumeCanonicalPartitionKeys);
        if (parts.isEmpty()) {
            return Optional.of(ImmutableList.of());
        }
        try {
            if (partitionKeysFilter.isAll()) {
                return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(() -> {
                    try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                        Optional<List<String>> optional = Optional.of(client.getPartitionNames(databaseName, tableName));
                        return optional;
                    }
                }));
            }
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesByParts().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Optional<List<String>> optional = Optional.of(client.getPartitionNamesFiltered(databaseName, tableName, (List)parts.get()));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void addPartitions(HiveIdentity identity, String databaseName, String tableName, List<PartitionWithStatistics> partitionsWithStatistics) {
        List partitions = (List)partitionsWithStatistics.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).collect(ImmutableList.toImmutableList());
        this.addPartitionsWithoutStatistics(identity, databaseName, tableName, partitions);
        for (PartitionWithStatistics partitionWithStatistics : partitionsWithStatistics) {
            this.storePartitionColumnStatistics(identity, databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        }
    }

    private void addPartitionsWithoutStatistics(HiveIdentity identity, String databaseName, String tableName, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class, TrinoException.class).stopOnIllegalExceptions().run("addPartitions", this.stats.getAddPartitions().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    int partitionsAdded = client.addPartitions(partitions);
                    if (partitionsAdded != partitions.size()) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, String.format("Hive metastore only added %s of %s partitions", partitionsAdded, partitions.size()));
                    }
                    Object var5_6 = null;
                    return var5_6;
                }
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("One or more partitions already exist for table '%s.%s'", databaseName, tableName), (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void dropPartition(HiveIdentity identity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("dropPartition", this.stats.getDropPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.dropPartition(databaseName, tableName, parts, deleteData);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts);
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        this.alterPartitionWithoutStatistics(identity, databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiPartition(partitionWithStatistics));
        this.storePartitionColumnStatistics(identity, databaseName, tableName, partitionWithStatistics.getPartitionName(), partitionWithStatistics);
        this.dropExtraColumnStatisticsAfterAlterPartition(identity, databaseName, tableName, partitionWithStatistics);
    }

    private void alterPartitionWithoutStatistics(HiveIdentity identity, String databaseName, String tableName, Partition partition) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterPartition", this.stats.getAlterPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    client.alterPartition(databaseName, tableName, partition);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getValues());
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private void storePartitionColumnStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, PartitionWithStatistics partitionWithStatistics) {
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        Map<String, HiveColumnStatistics> columnStatistics = statistics.getColumnStatistics();
        if (columnStatistics.isEmpty()) {
            return;
        }
        Map columnTypes = (Map)partitionWithStatistics.getPartition().getColumns().stream().collect(ImmutableMap.toImmutableMap(Column::getName, Column::getType));
        this.setPartitionColumnStatistics(identity, databaseName, tableName, partitionName, columnTypes, columnStatistics, statistics.getBasicStatistics().getRowCount());
    }

    private void dropExtraColumnStatisticsAfterAlterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        List dataColumns = (List)partitionWithStatistics.getPartition().getColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        HashSet columnsWithMissingStatistics = new HashSet(dataColumns);
        columnsWithMissingStatistics.removeAll(partitionWithStatistics.getStatistics().getColumnStatistics().keySet());
        if (columnsWithMissingStatistics.isEmpty()) {
            return;
        }
        String partitionName = partitionWithStatistics.getPartitionName();
        List<ColumnStatisticsObj> statisticsToBeRemoved = this.getMetastorePartitionColumnStatistics(identity, databaseName, tableName, (Set<String>)ImmutableSet.of((Object)partitionName), (List<String>)ImmutableList.copyOf(columnsWithMissingStatistics)).getOrDefault(partitionName, (List<ColumnStatisticsObj>)ImmutableList.of());
        for (ColumnStatisticsObj statistics : statisticsToBeRemoved) {
            this.deletePartitionColumnStatistics(identity, databaseName, tableName, partitionName, statistics.getColName());
        }
    }

    @Override
    public Optional<Partition> getPartition(HiveIdentity identity, String databaseName, String tableName, List<String> partitionValues) {
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartition", this.stats.getGetPartition().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    Optional<Partition> optional = Optional.of(client.getPartition(databaseName, tableName, partitionValues));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public List<Partition> getPartitionsByNames(HiveIdentity identity, String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!partitionNames.isEmpty() ? 1 : 0) != 0, (Object)"partitionNames is empty");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient(identity);){
                    List<Partition> list = client.getPartitionsByNames(databaseName, tableName, partitionNames);
                    return list;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        Set requestedPrivileges = (Set)privileges.stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("grantTablePrivileges", this.stats.getGrantTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Set<HivePrivilegeInfo> existingPrivileges = this.listTablePrivileges(databaseName, tableName, tableOwner, Optional.of(grantee));
                    HashSet<PrivilegeGrantInfo> privilegesToGrant = new HashSet<PrivilegeGrantInfo>(requestedPrivileges);
                    Iterator iterator = privilegesToGrant.iterator();
                    while (iterator.hasNext()) {
                        HivePrivilegeInfo requestedPrivilege = (HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege((PrivilegeGrantInfo)iterator.next(), Optional.empty()));
                        for (HivePrivilegeInfo existingPrivilege : existingPrivileges) {
                            if (requestedPrivilege.isContainedIn(existingPrivilege)) {
                                iterator.remove();
                                continue;
                            }
                            if (!existingPrivilege.isContainedIn(requestedPrivilege)) continue;
                            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Granting %s WITH GRANT OPTION is not supported while %s possesses %s", requestedPrivilege.getHivePrivilege().name(), grantee, requestedPrivilege.getHivePrivilege().name()));
                        }
                    }
                    if (privilegesToGrant.isEmpty()) {
                        Object var10_12 = null;
                        return var10_12;
                    }
                    metastoreClient.grantPrivileges(this.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToGrant));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        Set requestedPrivileges = (Set)privileges.stream().map(ThriftMetastoreUtil::toMetastoreApiPrivilegeGrantInfo).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("revokeTablePrivileges", this.stats.getRevokeTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Set existingHivePrivileges = (Set)this.listTablePrivileges(databaseName, tableName, tableOwner, Optional.of(grantee)).stream().map(HivePrivilegeInfo::getHivePrivilege).collect(ImmutableSet.toImmutableSet());
                    Set privilegesToRevoke = (Set)requestedPrivileges.stream().filter(privilegeGrantInfo -> existingHivePrivileges.contains((Object)((HivePrivilegeInfo)Iterables.getOnlyElement(ThriftMetastoreUtil.parsePrivilege(privilegeGrantInfo, Optional.empty()))).getHivePrivilege())).collect(ImmutableSet.toImmutableSet());
                    if (privilegesToRevoke.isEmpty()) {
                        Object var9_11 = null;
                        return var9_11;
                    }
                    metastoreClient.revokePrivileges(this.buildPrivilegeBag(databaseName, tableName, grantee, privilegesToRevoke));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, String tableOwner, Optional<HivePrincipal> principal) {
        try {
            return (Set)this.retry().stopOnIllegalExceptions().run("listTablePrivileges", this.stats.getListTablePrivileges().wrap(() -> {
                try (ThriftMetastoreClient client = this.createMetastoreClient();){
                    List<HiveObjectPrivilege> hiveObjectPrivilegeList;
                    ImmutableSet.Builder privileges = ImmutableSet.builder();
                    if (principal.isEmpty()) {
                        HivePrincipal ownerPrincipal = new HivePrincipal(PrincipalType.USER, tableOwner);
                        privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, ownerPrincipal, ownerPrincipal));
                        hiveObjectPrivilegeList = client.listPrivileges(null, null, new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                    } else {
                        if (((HivePrincipal)principal.get()).getType() == PrincipalType.USER && tableOwner.equals(((HivePrincipal)principal.get()).getName())) {
                            privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true, (HivePrincipal)principal.get(), (HivePrincipal)principal.get()));
                        }
                        hiveObjectPrivilegeList = client.listPrivileges(((HivePrincipal)principal.get()).getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(((HivePrincipal)principal.get()).getType()), new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
                    }
                    for (HiveObjectPrivilege hiveObjectPrivilege : hiveObjectPrivilegeList) {
                        HivePrincipal grantee = new HivePrincipal(ThriftMetastoreUtil.fromMetastoreApiPrincipalType(hiveObjectPrivilege.getPrincipalType()), hiveObjectPrivilege.getPrincipalName());
                        privileges.addAll(ThriftMetastoreUtil.parsePrivilege(hiveObjectPrivilege.getGrantInfo(), Optional.of(grantee)));
                    }
                    ImmutableSet immutableSet = privileges.build();
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public long openTransaction(HiveIdentity identity) {
        Preconditions.checkArgument((identity.getUsername().map(String::isEmpty).orElse(true) == false ? 1 : 0) != 0, (Object)"User should be provided to open transaction");
        try {
            return this.retry().stopOnIllegalExceptions().run("openTransaction", this.stats.getOpenTransaction().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    Long l = metastoreClient.openTransaction(identity.getUsername().get());
                    return l;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void commitTransaction(HiveIdentity identity, long transactionId) {
        try {
            this.retry().stopOnIllegalExceptions().run("commitTransaction", this.stats.getCommitTransaction().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    metastoreClient.commitTransaction(transactionId);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void sendTransactionHeartbeat(HiveIdentity identity, long transactionId) {
        try {
            this.retry().stopOnIllegalExceptions().run("sendTransactionHeartbeat", () -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    metastoreClient.sendTransactionHeartbeat(transactionId);
                }
                return null;
            });
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void acquireSharedReadLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.acquireSharedLock(DataOperationType.SELECT, false, identity, queryId, transactionId, fullTables, partitions);
    }

    @Override
    public void acquireTableWriteLock(HiveIdentity identity, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        this.acquireSharedLock(operation, isDynamicPartitionWrite, identity, queryId, transactionId, (List<SchemaTableName>)ImmutableList.of((Object)new SchemaTableName(dbName, tableName)), Collections.emptyList());
    }

    private void acquireSharedLock(DataOperationType operation, boolean isDynamicPartitionWrite, HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        Objects.requireNonNull(operation, "operation is null");
        Preconditions.checkArgument((identity.getUsername().map(String::isEmpty).orElse(true) == false ? 1 : 0) != 0, (Object)"User should be provided to acquire locks");
        Objects.requireNonNull(queryId, "queryId is null");
        if (fullTables.isEmpty() && partitions.isEmpty()) {
            return;
        }
        LockRequestBuilder request = new LockRequestBuilder(queryId).setTransactionId(transactionId).setUser(identity.getUsername().get());
        for (SchemaTableName table : fullTables) {
            request.addLockComponent(ThriftHiveMetastore.createLockComponentForOperation(table, operation, isDynamicPartitionWrite, Optional.empty()));
        }
        for (HivePartition partition : partitions) {
            request.addLockComponent(ThriftHiveMetastore.createLockComponentForOperation(partition.getTableName(), operation, isDynamicPartitionWrite, Optional.of(partition.getPartitionId())));
        }
        LockRequest lockRequest = request.build();
        try {
            LockResponse response = this.retry().stopOn(NoSuchTxnException.class, TxnAbortedException.class, MetaException.class).run("acquireLock", this.stats.getAcquireLock().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    LockResponse lockResponse = metastoreClient.acquireLock(lockRequest);
                    return lockResponse;
                }
            }));
            long waitStart = System.nanoTime();
            while (response.getState() == LockState.WAITING) {
                long lockId = response.getLockid();
                if (Duration.nanosSince((long)waitStart).compareTo(this.maxWaitForLock) > 0) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_LOCK_NOT_ACQUIRED, String.format("Timed out waiting for lock %d in hive transaction %s for query %s", lockId, transactionId, queryId));
                }
                log.debug("Waiting for lock %d in hive transaction %s for query %s", new Object[]{lockId, transactionId, queryId});
                response = this.retry().stopOn(NoSuchTxnException.class, NoSuchLockException.class, TxnAbortedException.class, MetaException.class).run("checkLock", this.stats.getCheckLock().wrap(() -> {
                    try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                        LockResponse lockResponse = metastoreClient.checkLock(lockId);
                        return lockResponse;
                    }
                }));
            }
            if (response.getState() != LockState.ACQUIRED) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_LOCK_NOT_ACQUIRED, "Could not acquire lock. Lock in state " + response.getState());
            }
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    private static LockComponent createLockComponentForOperation(SchemaTableName table, DataOperationType operation, boolean isDynamicPartitionWrite, Optional<String> partitionName) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        LockComponentBuilder builder = new LockComponentBuilder();
        builder.setShared();
        builder.setOperationType(operation);
        builder.setDbName(table.getSchemaName());
        builder.setTableName(table.getTableName());
        Objects.requireNonNull(partitionName, "partitionName is null").ifPresent(arg_0 -> ((LockComponentBuilder)builder).setPartitionName(arg_0));
        builder.setIsTransactional(true);
        builder.setIsDynamicPartitionWrite(isDynamicPartitionWrite);
        return builder.build();
    }

    @Override
    public String getValidWriteIds(HiveIdentity identity, List<SchemaTableName> tables, long currentTransactionId) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getValidWriteIds", this.stats.getValidWriteIds().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    String string = metastoreClient.getValidWriteIds((List)tables.stream().map(table -> String.format("%s.%s", table.getSchemaName(), table.getTableName())).collect(ImmutableList.toImmutableList()), currentTransactionId);
                    return string;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed to open transaction. Transactional tables support requires Hive metastore version at least 3.0", (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        try {
            return this.retry().stopOnIllegalExceptions().run("getConfigValueFromServer", () -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient();){
                    Optional<String> optional = Optional.ofNullable(metastoreClient.getConfigValue(name, null));
                    return optional;
                }
            });
        }
        catch (ConfigValSecurityException e) {
            log.debug((Throwable)e, "Could not fetch value for config '%s' from Hive", new Object[]{name});
            return Optional.empty();
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public long allocateWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId) {
        try {
            return this.retry().stopOnIllegalExceptions().run("allocateWriteId", this.stats.getAllocateWriteId().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    List<TxnToWriteId> list = metastoreClient.allocateTableWriteIds(dbName, tableName, (List<Long>)ImmutableList.of((Object)transactionId));
                    Long l = ((TxnToWriteId)Iterables.getOnlyElement(list)).getWriteId();
                    return l;
                }
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void updateTableWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        Preconditions.checkArgument((transactionId > 0L ? 1 : 0) != 0, (String)"transactionId should be a positive integer, but was %s", (long)transactionId);
        Objects.requireNonNull(dbName, "dbName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Preconditions.checkArgument((writeId > 0L ? 1 : 0) != 0, (String)"writeId should be a positive integer, but was %s", (long)writeId);
        try {
            this.retry().stopOnIllegalExceptions().run("updateTableWriteId", this.stats.getUpdateTableWriteId().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    metastoreClient.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void alterPartitions(HiveIdentity identity, String dbName, String tableName, List<Partition> partitions, long writeId) {
        Preconditions.checkArgument((writeId > 0L ? 1 : 0) != 0, (String)"writeId should be a positive integer, but was %s", (long)writeId);
        try {
            this.retry().stopOnIllegalExceptions().run("alterPartitions", this.stats.getAlterPartitions().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    metastoreClient.alterPartitions(dbName, tableName, partitions, writeId);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public void addDynamicPartitions(HiveIdentity identity, String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        Preconditions.checkArgument((writeId > 0L ? 1 : 0) != 0, (String)"writeId should be a positive integer, but was %s", (long)writeId);
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!partitionNames.isEmpty() ? 1 : 0) != 0, (Object)"partitionNames is empty");
        try {
            this.retry().stopOnIllegalExceptions().run("alterPartitions", this.stats.getAddDynamicPartitions().wrap(() -> {
                try (ThriftMetastoreClient metastoreClient = this.createMetastoreClient(identity);){
                    metastoreClient.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, operation);
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw ThriftHiveMetastore.propagate(e);
        }
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    private PrivilegeBag buildPrivilegeBag(String databaseName, String tableName, HivePrincipal grantee, Set<PrivilegeGrantInfo> privilegeGrantInfos) {
        ImmutableList.Builder privilegeBagBuilder = ImmutableList.builder();
        for (PrivilegeGrantInfo privilegeGrantInfo : privilegeGrantInfos) {
            privilegeBagBuilder.add((Object)new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null), grantee.getName(), ThriftMetastoreUtil.fromTrinoPrincipalType(grantee.getType()), privilegeGrantInfo, "SQL"));
        }
        return new PrivilegeBag((List)privilegeBagBuilder.build());
    }

    private boolean containsAllPrivilege(Set<PrivilegeGrantInfo> requestedPrivileges) {
        return requestedPrivileges.stream().anyMatch(privilege -> privilege.getPrivilege().equalsIgnoreCase("all"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeVarargs
    private final <T> T alternativeCall(ClientSupplier clientSupplier, Predicate<Exception> isValidExceptionalResponse, AtomicInteger chosenAlternative, Call<T> ... alternatives) throws TException {
        Preconditions.checkArgument((alternatives.length > 0 ? 1 : 0) != 0, (Object)"No alternatives");
        int chosen = chosenAlternative.get();
        Preconditions.checkArgument((chosen == Integer.MAX_VALUE || 0 <= chosen && chosen < alternatives.length ? 1 : 0) != 0, (String)"Bad chosen alternative value: %s", (int)chosen);
        if (chosen != Integer.MAX_VALUE) {
            try (ThriftMetastoreClient client = clientSupplier.createMetastoreClient();){
                T t = alternatives[chosen].callOn(client);
                return t;
            }
        }
        Throwable firstException = null;
        int i = 0;
        while (true) {
            if (i >= alternatives.length) {
                Verify.verifyNotNull(firstException);
                Throwables.propagateIfPossible(firstException, TException.class);
                throw ThriftHiveMetastore.propagate(firstException);
            }
            int position = i;
            try (ThriftMetastoreClient client = clientSupplier.createMetastoreClient();){
                T result = alternatives[i].callOn(client);
                chosenAlternative.updateAndGet(currentChosen -> Math.min(currentChosen, position));
                T t = result;
                return t;
            }
            catch (RuntimeException | TException exception) {
                if (isValidExceptionalResponse.test((Exception)exception)) {
                    throw exception;
                }
                if (firstException == null) {
                    firstException = exception;
                } else if (firstException != exception) {
                    firstException.addSuppressed(exception);
                }
                ++i;
                continue;
            }
            break;
        }
    }

    private static boolean defaultIsValidExceptionalResponse(Exception exception) {
        if (exception instanceof NoSuchObjectException) {
            return true;
        }
        return exception.toString().contains("AccessControlException");
    }

    private static boolean isUnknownMethodExceptionalResponse(Exception exception) {
        if (!(exception instanceof TApplicationException)) {
            return false;
        }
        TApplicationException applicationException = (TApplicationException)exception;
        return applicationException.getType() == 1;
    }

    private ThriftMetastoreClient createMetastoreClient() throws TException {
        return this.clientProvider.createMetastoreClient(Optional.empty());
    }

    private ThriftMetastoreClient createMetastoreClient(HiveIdentity identity) throws TException {
        if (!this.impersonationEnabled) {
            return this.createMetastoreClient();
        }
        String username = identity.getUsername().orElseThrow(() -> new IllegalStateException("End-user name should exist when metastore impersonation is enabled"));
        if (this.authenticationEnabled) {
            String delegationToken;
            try {
                delegationToken = (String)this.delegationTokenCache.getUnchecked((Object)username);
            }
            catch (UncheckedExecutionException e) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
                throw e;
            }
            return this.clientProvider.createMetastoreClient(Optional.of(delegationToken));
        }
        ThriftMetastoreClient client = this.createMetastoreClient();
        ThriftHiveMetastore.setMetastoreUserOrClose(client, username);
        return client;
    }

    private String loadDelegationToken(String username) {
        ThriftMetastoreClient client = this.createMetastoreClient();
        try {
            String string = client.getDelegationToken(username);
            if (client != null) {
                client.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (TException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
            }
        }
    }

    private static void setMetastoreUserOrClose(ThriftMetastoreClient client, String username) throws TException {
        try {
            client.setUGI(username);
        }
        catch (Throwable t) {
            try {
                ThriftMetastoreClient ignored = client;
                try {
                    throw t;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private RetryDriver retry() {
        return RetryDriver.retry().exponentialBackoff(this.minBackoffDelay, this.maxBackoffDelay, this.maxRetryTime, this.backoffScaleFactor).maxAttempts(this.maxRetries + 1).stopOn(TrinoException.class);
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }

    @FunctionalInterface
    private static interface Call1<A> {
        public void call(ThriftMetastoreClient var1, A var2) throws TException;
    }

    @FunctionalInterface
    private static interface Call<T> {
        public T callOn(ThriftMetastoreClient var1) throws TException;
    }

    @FunctionalInterface
    private static interface ClientSupplier {
        public ThriftMetastoreClient createMetastoreClient() throws TException;
    }
}

