/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.ForHiveMetastore;
import io.trino.plugin.hive.authentication.HadoopAuthentication;
import io.trino.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.trino.plugin.hive.authentication.MetastoreKerberosConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.client.TUGIAssumingTransport;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TTransport;

public class KerberosHiveMetastoreAuthentication
implements HiveMetastoreAuthentication {
    private final String hiveMetastoreServicePrincipal;
    private final HadoopAuthentication authentication;

    @Inject
    public KerberosHiveMetastoreAuthentication(MetastoreKerberosConfig config, @ForHiveMetastore HadoopAuthentication authentication) {
        this(config.getHiveMetastoreServicePrincipal(), authentication);
    }

    public KerberosHiveMetastoreAuthentication(String hiveMetastoreServicePrincipal, HadoopAuthentication authentication) {
        this.hiveMetastoreServicePrincipal = Objects.requireNonNull(hiveMetastoreServicePrincipal, "hiveMetastoreServicePrincipal is null");
        this.authentication = Objects.requireNonNull(authentication, "authentication is null");
    }

    @Override
    public TTransport authenticate(TTransport rawTransport, String hiveMetastoreHost, Optional<String> delegationToken) {
        try {
            String serverPrincipal = SecurityUtil.getServerPrincipal((String)this.hiveMetastoreServicePrincipal, (String)hiveMetastoreHost);
            String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
            Preconditions.checkState((names.length == 3 ? 1 : 0) != 0, (String)"Kerberos principal name does NOT have the expected hostname part: %s", (Object)serverPrincipal);
            ImmutableMap saslProps = ImmutableMap.of((Object)"javax.security.sasl.qop", (Object)"auth-conf,auth", (Object)"javax.security.sasl.server.authentication", (Object)"true");
            TSaslClientTransport saslTransport = delegationToken.isPresent() ? new TSaslClientTransport(SaslRpcServer.AuthMethod.TOKEN.getMechanismName(), null, null, "default", (Map)saslProps, (CallbackHandler)new SaslClientCallbackHandler(KerberosHiveMetastoreAuthentication.decodeDelegationToken(delegationToken.get())), rawTransport) : new TSaslClientTransport(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), null, names[0], names[1], (Map)saslProps, null, rawTransport);
            return new TUGIAssumingTransport((TTransport)saslTransport, this.authentication.getUserGroupInformation());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Token<DelegationTokenIdentifier> decodeDelegationToken(String tokenValue) throws IOException {
        Token token = new Token();
        token.decodeFromUrlString(tokenValue);
        return token;
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        SaslClientCallbackHandler(Token<DelegationTokenIdentifier> token) {
            this.username = Base64.getEncoder().encodeToString(token.getIdentifier());
            this.password = Base64.getEncoder().encodeToString(token.getPassword());
        }

        @Override
        public void handle(Callback[] callbacks) {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                }
                if (!(callback instanceof RealmCallback)) continue;
                RealmCallback realmCallback = (RealmCallback)callback;
                realmCallback.setText(realmCallback.getDefaultText());
            }
        }
    }
}

