/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;

public class BridgingHiveMetastore
implements HiveMetastore {
    private final ThriftMetastore delegate;

    @Inject
    public BridgingHiveMetastore(ThriftMetastore delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName).map(ThriftMetastoreUtil::fromMetastoreApiDatabase);
    }

    @Override
    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.delegate.getTable(identity, databaseName, tableName).map(table -> {
            if (ThriftMetastoreUtil.isAvroTableWithSchemaSet(table)) {
                return ThriftMetastoreUtil.fromMetastoreApiTable(table, this.delegate.getFields(identity, databaseName, tableName).orElseThrow());
            }
            if (ThriftMetastoreUtil.isCsvTable(table)) {
                return ThriftMetastoreUtil.fromMetastoreApiTable(table, ThriftMetastoreUtil.csvSchemaFields(table.getSd().getCols()));
            }
            return ThriftMetastoreUtil.fromMetastoreApiTable(table);
        });
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    @Override
    public PartitionStatistics getTableStatistics(HiveIdentity identity, Table table) {
        return this.delegate.getTableStatistics(identity, ThriftMetastoreUtil.toMetastoreApiTable(table));
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, Table table, List<Partition> partitions) {
        return this.delegate.getPartitionStatistics(identity, ThriftMetastoreUtil.toMetastoreApiTable(table), (List)partitions.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public void updateTableStatistics(HiveIdentity identity, String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        this.delegate.updateTableStatistics(identity, databaseName, tableName, transaction, update);
    }

    @Override
    public void updatePartitionStatistics(HiveIdentity identity, Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        org.apache.hadoop.hive.metastore.api.Table metastoreTable = ThriftMetastoreUtil.toMetastoreApiTable(table);
        updates.forEach((partitionName, update) -> this.delegate.updatePartitionStatistics(identity, metastoreTable, (String)partitionName, (Function<PartitionStatistics, PartitionStatistics>)update));
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        return this.delegate.getTablesWithParameter(databaseName, parameterKey, parameterValue);
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(HiveIdentity identity, Database database) {
        this.delegate.createDatabase(identity, ThriftMetastoreUtil.toMetastoreApiDatabase(database));
    }

    @Override
    public void dropDatabase(HiveIdentity identity, String databaseName) {
        this.delegate.dropDatabase(identity, databaseName);
    }

    @Override
    public void renameDatabase(HiveIdentity identity, String databaseName, String newDatabaseName) {
        org.apache.hadoop.hive.metastore.api.Database database = this.delegate.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
        database.setName(newDatabaseName);
        this.delegate.alterDatabase(identity, databaseName, database);
        this.delegate.getDatabase(databaseName).ifPresent(newDatabase -> {
            if (newDatabase.getName().equals(databaseName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive metastore does not support renaming schemas");
            }
        });
    }

    @Override
    public void setDatabaseOwner(HiveIdentity identity, String databaseName, HivePrincipal principal) {
        Database database = ThriftMetastoreUtil.fromMetastoreApiDatabase(this.delegate.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName)));
        Database newDatabase = Database.builder(database).setOwnerName(principal.getName()).setOwnerType(principal.getType()).build();
        this.delegate.alterDatabase(identity, databaseName, ThriftMetastoreUtil.toMetastoreApiDatabase(newDatabase));
    }

    @Override
    public void createTable(HiveIdentity identity, Table table, PrincipalPrivileges principalPrivileges) {
        this.delegate.createTable(identity, ThriftMetastoreUtil.toMetastoreApiTable(table, principalPrivileges));
    }

    @Override
    public void dropTable(HiveIdentity identity, String databaseName, String tableName, boolean deleteData) {
        this.delegate.dropTable(identity, databaseName, tableName, deleteData);
    }

    @Override
    public void replaceTable(HiveIdentity identity, String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.alterTable(identity, databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiTable(newTable, principalPrivileges));
    }

    @Override
    public void renameTable(HiveIdentity identity, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        table.setDbName(newDatabaseName);
        table.setTableName(newTableName);
        this.alterTable(identity, databaseName, tableName, table);
    }

    @Override
    public void commentTable(HiveIdentity identity, String databaseName, String tableName, Optional<String> comment) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        Map<String, String> parameters = table.getParameters().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("comment")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        comment.ifPresent(value -> parameters.put("comment", (String)value));
        table.setParameters(parameters);
        this.alterTable(identity, databaseName, tableName, table);
    }

    @Override
    public void setTableOwner(HiveIdentity identity, String databaseName, String tableName, HivePrincipal principal) {
        if (principal.getType() != PrincipalType.USER) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting table owner type as a role is not supported");
        }
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable(this.delegate.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName))));
        Table newTable = Table.builder(table).setOwner(principal.getName()).build();
        this.delegate.alterTable(identity, databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiTable(newTable));
    }

    @Override
    public void commentColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, Optional<String> comment) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        for (FieldSchema fieldSchema : table.getSd().getCols()) {
            if (!fieldSchema.getName().equals(columnName)) continue;
            if (comment.isPresent()) {
                fieldSchema.setComment(comment.get());
                continue;
            }
            fieldSchema.unsetComment();
        }
        this.alterTable(identity, databaseName, tableName, table);
    }

    @Override
    public void addColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        table.getSd().getCols().add(new FieldSchema(columnName, columnType.getHiveTypeName().toString(), columnComment));
        this.alterTable(identity, databaseName, tableName, table);
    }

    @Override
    public void renameColumn(HiveIdentity identity, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Optional<org.apache.hadoop.hive.metastore.api.Table> source = this.delegate.getTable(identity, databaseName, tableName);
        if (source.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        org.apache.hadoop.hive.metastore.api.Table table = source.get();
        for (FieldSchema fieldSchema : table.getPartitionKeys()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        for (FieldSchema fieldSchema : table.getSd().getCols()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            fieldSchema.setName(newColumnName);
        }
        this.alterTable(identity, databaseName, tableName, table);
    }

    @Override
    public void dropColumn(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, identity, databaseName, tableName, columnName);
        org.apache.hadoop.hive.metastore.api.Table table = this.delegate.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        table.getSd().getCols().removeIf(fieldSchema -> fieldSchema.getName().equals(columnName));
        this.alterTable(identity, databaseName, tableName, table);
    }

    private void alterTable(HiveIdentity identity, String databaseName, String tableName, org.apache.hadoop.hive.metastore.api.Table table) {
        this.delegate.alterTable(identity, databaseName, tableName, table);
    }

    @Override
    public Optional<Partition> getPartition(HiveIdentity identity, Table table, List<String> partitionValues) {
        return this.delegate.getPartition(identity, table.getDatabaseName(), table.getTableName(), partitionValues).map(partition -> this.fromMetastoreApiPartition(table, (org.apache.hadoop.hive.metastore.api.Partition)partition));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(HiveIdentity identity, String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.delegate.getPartitionNamesByFilter(identity, databaseName, tableName, columnNames, partitionKeysFilter);
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity identity, Table table, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), HiveUtil::toPartitionValues));
        Map partitionValuesToPartitionMap = this.delegate.getPartitionsByNames(identity, table.getDatabaseName(), table.getTableName(), partitionNames).stream().map(partition -> this.fromMetastoreApiPartition(table, (org.apache.hadoop.hive.metastore.api.Partition)partition)).collect(Collectors.toMap(Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            Partition partition2 = (Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put((Object)((String)entry.getKey()), Optional.ofNullable(partition2));
        }
        return resultBuilder.build();
    }

    private Partition fromMetastoreApiPartition(Table table, org.apache.hadoop.hive.metastore.api.Partition partition) {
        if (MetastoreUtil.isAvroTableWithSchemaSet(table)) {
            List schema = (List)table.getDataColumns().stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList());
            return ThriftMetastoreUtil.fromMetastoreApiPartition(partition, schema);
        }
        return ThriftMetastoreUtil.fromMetastoreApiPartition(partition);
    }

    @Override
    public void addPartitions(HiveIdentity identity, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.delegate.addPartitions(identity, databaseName, tableName, partitions);
    }

    @Override
    public void dropPartition(HiveIdentity identity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.delegate.dropPartition(identity, databaseName, tableName, parts, deleteData);
    }

    @Override
    public void alterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partition) {
        this.delegate.alterPartition(identity, databaseName, tableName, partition);
    }

    @Override
    public void createRole(String role, String grantor) {
        this.delegate.createRole(role, grantor);
    }

    @Override
    public void dropRole(String role) {
        this.delegate.dropRole(role);
    }

    @Override
    public Set<String> listRoles() {
        return this.delegate.listRoles();
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.grantRoles(roles, grantees, adminOption, grantor);
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        return this.delegate.listGrantedPrincipals(role);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, privileges);
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, privileges);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, String tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.delegate.isImpersonationEnabled();
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    @Override
    public long openTransaction(HiveIdentity identity) {
        return this.delegate.openTransaction(identity);
    }

    @Override
    public void commitTransaction(HiveIdentity identity, long transactionId) {
        this.delegate.commitTransaction(identity, transactionId);
    }

    @Override
    public void sendTransactionHeartbeat(HiveIdentity identity, long transactionId) {
        this.delegate.sendTransactionHeartbeat(identity, transactionId);
    }

    @Override
    public void acquireSharedReadLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(identity, queryId, transactionId, fullTables, partitions);
    }

    @Override
    public String getValidWriteIds(HiveIdentity identity, List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(identity, tables, currentTransactionId);
    }

    @Override
    public long allocateWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(identity, dbName, tableName, transactionId);
    }

    @Override
    public void acquireTableWriteLock(HiveIdentity identity, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        this.delegate.acquireTableWriteLock(identity, queryId, transactionId, dbName, tableName, operation, isDynamicPartitionWrite);
    }

    @Override
    public void updateTableWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        this.delegate.updateTableWriteId(identity, dbName, tableName, transactionId, writeId, rowCountChange);
    }

    @Override
    public void alterPartitions(HiveIdentity identity, String dbName, String tableName, List<Partition> partitions, long writeId) {
        List hadoopPartitions = (List)partitions.stream().map(ThriftMetastoreUtil::toMetastoreApiPartition).peek(partition -> partition.setWriteId(writeId)).collect(ImmutableList.toImmutableList());
        this.delegate.alterPartitions(identity, dbName, tableName, hadoopPartitions, writeId);
    }

    @Override
    public void addDynamicPartitions(HiveIdentity identity, String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        this.delegate.addDynamicPartitions(identity, dbName, tableName, partitionNames, transactionId, writeId, operation);
    }

    @Override
    public void alterTransactionalTable(HiveIdentity identity, Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        this.delegate.alterTransactionalTable(identity, ThriftMetastoreUtil.toMetastoreApiTable(table, principalPrivileges), transactionId, writeId);
    }
}

