/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.model.Table;
import io.trino.plugin.hive.metastore.MetastoreConfig;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Provider;

public class DefaultGlueMetastoreTableFilterProvider
implements Provider<Predicate<Table>> {
    private final boolean hideDeltaLakeTables;

    @Inject
    public DefaultGlueMetastoreTableFilterProvider(MetastoreConfig metastoreConfig) {
        Objects.requireNonNull(metastoreConfig, "metastoreConfig is null");
        this.hideDeltaLakeTables = metastoreConfig.isHideDeltaLakeTables();
    }

    public Predicate<Table> get() {
        if (this.hideDeltaLakeTables) {
            return Predicate.not(DefaultGlueMetastoreTableFilterProvider::isDeltaLakeTable);
        }
        return table -> true;
    }

    public static boolean isDeltaLakeTable(Table table) {
        return table.getParameters().getOrDefault("spark.sql.sources.provider", "").equalsIgnoreCase("delta");
    }
}

