/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.trino.plugin.hive.ForRecordingHiveMetastore;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.RecordingMetastoreConfig;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePartitionName;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.HiveTableName;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionFilter;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.TablesWithParameterCacheKey;
import io.trino.plugin.hive.metastore.UserTableKey;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class RecordingHiveMetastore
implements HiveMetastore {
    private final HiveMetastore delegate;
    private final JsonCodec<Recording> recordingCodec;
    private final Path recordingPath;
    private final boolean replay;
    private volatile Optional<List<String>> allDatabases = Optional.empty();
    private volatile Optional<Set<String>> allRoles = Optional.empty();
    private final Cache<String, Optional<Database>> databaseCache;
    private final Cache<HiveTableName, Optional<Table>> tableCache;
    private final Cache<String, Set<ColumnStatisticType>> supportedColumnStatisticsCache;
    private final Cache<HiveTableName, PartitionStatistics> tableStatisticsCache;
    private final Cache<Set<HivePartitionName>, Map<String, PartitionStatistics>> partitionStatisticsCache;
    private final Cache<String, List<String>> allTablesCache;
    private final Cache<TablesWithParameterCacheKey, List<String>> tablesWithParameterCache;
    private final Cache<String, List<String>> allViewsCache;
    private final Cache<HivePartitionName, Optional<Partition>> partitionCache;
    private final Cache<HiveTableName, Optional<List<String>>> partitionNamesCache;
    private final Cache<PartitionFilter, Optional<List<String>>> partitionNamesByPartsCache;
    private final Cache<Set<HivePartitionName>, Map<String, Optional<Partition>>> partitionsByNamesCache;
    private final Cache<UserTableKey, Set<HivePrivilegeInfo>> tablePrivilegesCache;
    private final Cache<HivePrincipal, Set<RoleGrant>> roleGrantsCache;
    private final Cache<String, Set<RoleGrant>> grantedPrincipalsCache;

    @Inject
    public RecordingHiveMetastore(@ForRecordingHiveMetastore HiveMetastore delegate, RecordingMetastoreConfig config, JsonCodec<Recording> recordingCodec) throws IOException {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.recordingCodec = recordingCodec;
        Objects.requireNonNull(config, "config is null");
        this.recordingPath = Paths.get(Objects.requireNonNull(config.getRecordingPath(), "recordingPath is null"), new String[0]);
        this.replay = config.isReplay();
        Duration recordingDuration = config.getRecordingDuration();
        this.databaseCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.tableCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.supportedColumnStatisticsCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.tableStatisticsCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.partitionStatisticsCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.allTablesCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.tablesWithParameterCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.allViewsCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.partitionCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.partitionNamesCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.partitionNamesByPartsCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.partitionsByNamesCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.tablePrivilegesCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.roleGrantsCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        this.grantedPrincipalsCache = RecordingHiveMetastore.createCache(this.replay, recordingDuration);
        if (this.replay) {
            this.loadRecording();
        }
    }

    @VisibleForTesting
    void loadRecording() throws IOException {
        Recording recording = (Recording)this.recordingCodec.fromJson(Files.readAllBytes(this.recordingPath));
        this.allDatabases = recording.getAllDatabases();
        this.allRoles = recording.getAllRoles();
        this.databaseCache.putAll(RecordingHiveMetastore.toMap(recording.getDatabases()));
        this.tableCache.putAll(RecordingHiveMetastore.toMap(recording.getTables()));
        this.supportedColumnStatisticsCache.putAll(RecordingHiveMetastore.toMap(recording.getSupportedColumnStatistics()));
        this.tableStatisticsCache.putAll(RecordingHiveMetastore.toMap(recording.getTableStatistics()));
        this.partitionStatisticsCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitionStatistics()));
        this.allTablesCache.putAll(RecordingHiveMetastore.toMap(recording.getAllTables()));
        this.tablesWithParameterCache.putAll(RecordingHiveMetastore.toMap(recording.getTablesWithParameter()));
        this.allViewsCache.putAll(RecordingHiveMetastore.toMap(recording.getAllViews()));
        this.partitionCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitions()));
        this.partitionNamesCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitionNames()));
        this.partitionNamesByPartsCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitionNamesByParts()));
        this.partitionsByNamesCache.putAll(RecordingHiveMetastore.toMap(recording.getPartitionsByNames()));
        this.tablePrivilegesCache.putAll(RecordingHiveMetastore.toMap(recording.getTablePrivileges()));
        this.roleGrantsCache.putAll(RecordingHiveMetastore.toMap(recording.getRoleGrants()));
        this.grantedPrincipalsCache.putAll(RecordingHiveMetastore.toMap(recording.getGrantedPrincipals()));
    }

    private static <K, V> Cache<K, V> createCache(boolean reply, Duration recordingDuration) {
        if (reply) {
            return CacheBuilder.newBuilder().build();
        }
        return CacheBuilder.newBuilder().expireAfterWrite(recordingDuration.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    @Managed
    public void writeRecording() throws IOException {
        if (this.replay) {
            throw new IllegalStateException("Cannot write recording in replay mode");
        }
        Recording recording = new Recording(this.allDatabases, this.allRoles, RecordingHiveMetastore.toPairs(this.databaseCache), RecordingHiveMetastore.toPairs(this.tableCache), RecordingHiveMetastore.toPairs(this.supportedColumnStatisticsCache), RecordingHiveMetastore.toPairs(this.tableStatisticsCache), RecordingHiveMetastore.toPairs(this.partitionStatisticsCache), RecordingHiveMetastore.toPairs(this.allTablesCache), RecordingHiveMetastore.toPairs(this.tablesWithParameterCache), RecordingHiveMetastore.toPairs(this.allViewsCache), RecordingHiveMetastore.toPairs(this.partitionCache), RecordingHiveMetastore.toPairs(this.partitionNamesCache), RecordingHiveMetastore.toPairs(this.partitionNamesByPartsCache), RecordingHiveMetastore.toPairs(this.partitionsByNamesCache), RecordingHiveMetastore.toPairs(this.tablePrivilegesCache), RecordingHiveMetastore.toPairs(this.roleGrantsCache), RecordingHiveMetastore.toPairs(this.grantedPrincipalsCache));
        Files.write(this.recordingPath, this.recordingCodec.toJsonBytes((Object)recording), new OpenOption[0]);
    }

    private static <K, V> Map<K, V> toMap(List<Pair<K, V>> pairs) {
        return (Map)pairs.stream().collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
    }

    private static <K, V> List<Pair<K, V>> toPairs(Cache<K, V> cache) {
        return (List)cache.asMap().entrySet().stream().map(entry -> new Pair(entry.getKey(), entry.getValue())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.loadValue(this.databaseCache, databaseName, () -> this.delegate.getDatabase(databaseName));
    }

    @Override
    public List<String> getAllDatabases() {
        if (this.replay) {
            return this.allDatabases.orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry for all databases"));
        }
        List<String> result = this.delegate.getAllDatabases();
        this.allDatabases = Optional.of(result);
        return result;
    }

    @Override
    public Optional<Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.loadValue(this.tableCache, HiveTableName.hiveTableName(databaseName, tableName), () -> this.delegate.getTable(identity, databaseName, tableName));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.loadValue(this.supportedColumnStatisticsCache, type.getTypeSignature().toString(), () -> this.delegate.getSupportedColumnStatistics(type));
    }

    @Override
    public PartitionStatistics getTableStatistics(HiveIdentity identity, Table table) {
        return this.loadValue(this.tableStatisticsCache, HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), () -> this.delegate.getTableStatistics(identity, table));
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, Table table, List<Partition> partitions) {
        return this.loadValue(this.partitionStatisticsCache, (Set)partitions.stream().map(partition -> HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partition.getValues())).collect(ImmutableSet.toImmutableSet()), () -> this.delegate.getPartitionStatistics(identity, table, partitions));
    }

    @Override
    public void updateTableStatistics(HiveIdentity identity, String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        this.verifyRecordingMode();
        this.delegate.updateTableStatistics(identity, databaseName, tableName, transaction, update);
    }

    @Override
    public void updatePartitionStatistics(HiveIdentity identity, Table table, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.verifyRecordingMode();
        this.delegate.updatePartitionStatistics(identity, table, partitionName, update);
    }

    @Override
    public void updatePartitionStatistics(HiveIdentity identity, Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        this.verifyRecordingMode();
        this.delegate.updatePartitionStatistics(identity, table, updates);
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return this.loadValue(this.allTablesCache, databaseName, () -> this.delegate.getAllTables(databaseName));
    }

    @Override
    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        TablesWithParameterCacheKey key = new TablesWithParameterCacheKey(databaseName, parameterKey, parameterValue);
        return this.loadValue(this.tablesWithParameterCache, key, () -> this.delegate.getTablesWithParameter(databaseName, parameterKey, parameterValue));
    }

    @Override
    public List<String> getAllViews(String databaseName) {
        return this.loadValue(this.allViewsCache, databaseName, () -> this.delegate.getAllViews(databaseName));
    }

    @Override
    public void createDatabase(HiveIdentity identity, Database database) {
        this.verifyRecordingMode();
        this.delegate.createDatabase(identity, database);
    }

    @Override
    public void dropDatabase(HiveIdentity identity, String databaseName) {
        this.verifyRecordingMode();
        this.delegate.dropDatabase(identity, databaseName);
    }

    @Override
    public void renameDatabase(HiveIdentity identity, String databaseName, String newDatabaseName) {
        this.verifyRecordingMode();
        this.delegate.renameDatabase(identity, databaseName, newDatabaseName);
    }

    @Override
    public void setDatabaseOwner(HiveIdentity identity, String databaseName, HivePrincipal principal) {
        this.verifyRecordingMode();
        this.delegate.setDatabaseOwner(identity, databaseName, principal);
    }

    @Override
    public void createTable(HiveIdentity identity, Table table, PrincipalPrivileges principalPrivileges) {
        this.verifyRecordingMode();
        this.delegate.createTable(identity, table, principalPrivileges);
    }

    @Override
    public void dropTable(HiveIdentity identity, String databaseName, String tableName, boolean deleteData) {
        this.verifyRecordingMode();
        this.delegate.dropTable(identity, databaseName, tableName, deleteData);
    }

    @Override
    public void replaceTable(HiveIdentity identity, String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.verifyRecordingMode();
        this.delegate.replaceTable(identity, databaseName, tableName, newTable, principalPrivileges);
    }

    @Override
    public void renameTable(HiveIdentity identity, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.verifyRecordingMode();
        this.delegate.renameTable(identity, databaseName, tableName, newDatabaseName, newTableName);
    }

    @Override
    public void commentTable(HiveIdentity identity, String databaseName, String tableName, Optional<String> comment) {
        this.verifyRecordingMode();
        this.delegate.commentTable(identity, databaseName, tableName, comment);
    }

    @Override
    public void setTableOwner(HiveIdentity identity, String databaseName, String tableName, HivePrincipal principal) {
        this.verifyRecordingMode();
        this.delegate.setTableOwner(identity, databaseName, tableName, principal);
    }

    @Override
    public void commentColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, Optional<String> comment) {
        this.verifyRecordingMode();
        this.delegate.commentColumn(identity, databaseName, tableName, columnName, comment);
    }

    @Override
    public void addColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.verifyRecordingMode();
        this.delegate.addColumn(identity, databaseName, tableName, columnName, columnType, columnComment);
    }

    @Override
    public void renameColumn(HiveIdentity identity, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.verifyRecordingMode();
        this.delegate.renameColumn(identity, databaseName, tableName, oldColumnName, newColumnName);
    }

    @Override
    public void dropColumn(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        this.verifyRecordingMode();
        this.delegate.dropColumn(identity, databaseName, tableName, columnName);
    }

    @Override
    public Optional<Partition> getPartition(HiveIdentity identity, Table table, List<String> partitionValues) {
        return this.loadValue(this.partitionCache, HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionValues), () -> this.delegate.getPartition(identity, table, partitionValues));
    }

    @Override
    public Optional<List<String>> getPartitionNamesByFilter(HiveIdentity identity, String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.loadValue(this.partitionNamesByPartsCache, PartitionFilter.partitionFilter(databaseName, tableName, columnNames, partitionKeysFilter), () -> this.delegate.getPartitionNamesByFilter(identity, databaseName, tableName, columnNames, partitionKeysFilter));
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity identity, Table table, List<String> partitionNames) {
        return this.loadValue(this.partitionsByNamesCache, (Set)partitionNames.stream().map(partitionName -> HivePartitionName.hivePartitionName(HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()), partitionName)).collect(ImmutableSet.toImmutableSet()), () -> this.delegate.getPartitionsByNames(identity, table, partitionNames));
    }

    @Override
    public void addPartitions(HiveIdentity identity, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.verifyRecordingMode();
        this.delegate.addPartitions(identity, databaseName, tableName, partitions);
    }

    @Override
    public void dropPartition(HiveIdentity identity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.verifyRecordingMode();
        this.delegate.dropPartition(identity, databaseName, tableName, parts, deleteData);
    }

    @Override
    public void alterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partition) {
        this.verifyRecordingMode();
        this.delegate.alterPartition(identity, databaseName, tableName, partition);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, String tableOwner, Optional<HivePrincipal> principal) {
        return this.loadValue(this.tablePrivilegesCache, new UserTableKey(principal, databaseName, tableName, tableOwner), () -> this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal));
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.verifyRecordingMode();
        this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, privileges);
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.verifyRecordingMode();
        this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, privileges);
    }

    @Override
    public void createRole(String role, String grantor) {
        this.verifyRecordingMode();
        this.delegate.createRole(role, grantor);
    }

    @Override
    public void dropRole(String role) {
        this.verifyRecordingMode();
        this.delegate.dropRole(role);
    }

    @Override
    public Set<String> listRoles() {
        if (this.replay) {
            return this.allRoles.orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry for roles"));
        }
        Set<String> result = this.delegate.listRoles();
        this.allRoles = Optional.of(result);
        return result;
    }

    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.verifyRecordingMode();
        this.delegate.grantRoles(roles, grantees, adminOption, grantor);
    }

    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.verifyRecordingMode();
        this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
    }

    @Override
    public Set<RoleGrant> listGrantedPrincipals(String role) {
        return this.loadValue(this.grantedPrincipalsCache, role, () -> this.delegate.listGrantedPrincipals(role));
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return this.loadValue(this.roleGrantsCache, principal, () -> this.delegate.listRoleGrants(principal));
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.delegate.isImpersonationEnabled();
    }

    private <K, V> V loadValue(Cache<K, V> cache, K key, Supplier<V> valueSupplier) {
        if (this.replay) {
            return (V)Optional.ofNullable(cache.getIfPresent(key)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Missing entry found for key: " + key));
        }
        V value = valueSupplier.get();
        cache.put(key, value);
        return value;
    }

    private void verifyRecordingMode() {
        if (this.replay) {
            throw new IllegalStateException("Cannot perform Metastore updates in replay mode");
        }
    }

    @Immutable
    public static class Pair<K, V> {
        private final K key;
        private final V value;

        @JsonCreator
        public Pair(@JsonProperty(value="key") K key, @JsonProperty(value="value") V value) {
            this.key = Objects.requireNonNull(key, "key is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        @JsonProperty
        public K getKey() {
            return this.key;
        }

        @JsonProperty
        public V getValue() {
            return this.value;
        }
    }

    @Immutable
    public static class Recording {
        private final Optional<List<String>> allDatabases;
        private final Optional<Set<String>> allRoles;
        private final List<Pair<String, Optional<Database>>> databases;
        private final List<Pair<HiveTableName, Optional<Table>>> tables;
        private final List<Pair<String, Set<ColumnStatisticType>>> supportedColumnStatistics;
        private final List<Pair<HiveTableName, PartitionStatistics>> tableStatistics;
        private final List<Pair<Set<HivePartitionName>, Map<String, PartitionStatistics>>> partitionStatistics;
        private final List<Pair<String, List<String>>> allTables;
        private final List<Pair<TablesWithParameterCacheKey, List<String>>> tablesWithParameter;
        private final List<Pair<String, List<String>>> allViews;
        private final List<Pair<HivePartitionName, Optional<Partition>>> partitions;
        private final List<Pair<HiveTableName, Optional<List<String>>>> partitionNames;
        private final List<Pair<PartitionFilter, Optional<List<String>>>> partitionNamesByParts;
        private final List<Pair<Set<HivePartitionName>, Map<String, Optional<Partition>>>> partitionsByNames;
        private final List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> tablePrivileges;
        private final List<Pair<HivePrincipal, Set<RoleGrant>>> roleGrants;
        private final List<Pair<String, Set<RoleGrant>>> grantedPrincipals;

        @JsonCreator
        public Recording(@JsonProperty(value="allDatabases") Optional<List<String>> allDatabases, @JsonProperty(value="allRoles") Optional<Set<String>> allRoles, @JsonProperty(value="databases") List<Pair<String, Optional<Database>>> databases, @JsonProperty(value="tables") List<Pair<HiveTableName, Optional<Table>>> tables, @JsonProperty(value="supportedColumnStatistics") List<Pair<String, Set<ColumnStatisticType>>> supportedColumnStatistics, @JsonProperty(value="tableStatistics") List<Pair<HiveTableName, PartitionStatistics>> tableStatistics, @JsonProperty(value="partitionStatistics") List<Pair<Set<HivePartitionName>, Map<String, PartitionStatistics>>> partitionStatistics, @JsonProperty(value="allTables") List<Pair<String, List<String>>> allTables, @JsonProperty(value="tablesWithParameter") List<Pair<TablesWithParameterCacheKey, List<String>>> tablesWithParameter, @JsonProperty(value="allViews") List<Pair<String, List<String>>> allViews, @JsonProperty(value="partitions") List<Pair<HivePartitionName, Optional<Partition>>> partitions, @JsonProperty(value="partitionNames") List<Pair<HiveTableName, Optional<List<String>>>> partitionNames, @JsonProperty(value="partitionNamesByParts") List<Pair<PartitionFilter, Optional<List<String>>>> partitionNamesByParts, @JsonProperty(value="partitionsByNames") List<Pair<Set<HivePartitionName>, Map<String, Optional<Partition>>>> partitionsByNames, @JsonProperty(value="tablePrivileges") List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> tablePrivileges, @JsonProperty(value="roleGrants") List<Pair<HivePrincipal, Set<RoleGrant>>> roleGrants, @JsonProperty(value="grantedPrincipals") List<Pair<String, Set<RoleGrant>>> grantedPrincipals) {
            this.allDatabases = allDatabases;
            this.allRoles = allRoles;
            this.databases = databases;
            this.tables = tables;
            this.supportedColumnStatistics = supportedColumnStatistics;
            this.tableStatistics = tableStatistics;
            this.partitionStatistics = partitionStatistics;
            this.allTables = allTables;
            this.tablesWithParameter = tablesWithParameter;
            this.allViews = allViews;
            this.partitions = partitions;
            this.partitionNames = partitionNames;
            this.partitionNamesByParts = partitionNamesByParts;
            this.partitionsByNames = partitionsByNames;
            this.tablePrivileges = tablePrivileges;
            this.roleGrants = roleGrants;
            this.grantedPrincipals = grantedPrincipals;
        }

        @JsonProperty
        public Optional<List<String>> getAllDatabases() {
            return this.allDatabases;
        }

        @JsonProperty
        public Optional<Set<String>> getAllRoles() {
            return this.allRoles;
        }

        @JsonProperty
        public List<Pair<String, Optional<Database>>> getDatabases() {
            return this.databases;
        }

        @JsonProperty
        public List<Pair<HiveTableName, Optional<Table>>> getTables() {
            return this.tables;
        }

        @JsonProperty
        public List<Pair<TablesWithParameterCacheKey, List<String>>> getTablesWithParameter() {
            return this.tablesWithParameter;
        }

        @JsonProperty
        public List<Pair<String, Set<ColumnStatisticType>>> getSupportedColumnStatistics() {
            return this.supportedColumnStatistics;
        }

        @JsonProperty
        public List<Pair<HiveTableName, PartitionStatistics>> getTableStatistics() {
            return this.tableStatistics;
        }

        @JsonProperty
        public List<Pair<Set<HivePartitionName>, Map<String, PartitionStatistics>>> getPartitionStatistics() {
            return this.partitionStatistics;
        }

        @JsonProperty
        public List<Pair<String, List<String>>> getAllTables() {
            return this.allTables;
        }

        @JsonProperty
        public List<Pair<String, List<String>>> getAllViews() {
            return this.allViews;
        }

        @JsonProperty
        public List<Pair<HivePartitionName, Optional<Partition>>> getPartitions() {
            return this.partitions;
        }

        @JsonProperty
        public List<Pair<HiveTableName, Optional<List<String>>>> getPartitionNames() {
            return this.partitionNames;
        }

        @JsonProperty
        public List<Pair<PartitionFilter, Optional<List<String>>>> getPartitionNamesByParts() {
            return this.partitionNamesByParts;
        }

        @JsonProperty
        public List<Pair<Set<HivePartitionName>, Map<String, Optional<Partition>>>> getPartitionsByNames() {
            return this.partitionsByNames;
        }

        @JsonProperty
        public List<Pair<UserTableKey, Set<HivePrivilegeInfo>>> getTablePrivileges() {
            return this.tablePrivileges;
        }

        @JsonProperty
        public List<Pair<String, Set<RoleGrant>>> getGrantedPrincipals() {
            return this.grantedPrincipals;
        }

        @JsonProperty
        public List<Pair<HivePrincipal, Set<RoleGrant>>> getRoleGrants() {
            return this.roleGrants;
        }
    }
}

