/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.api.DataOperationType;

public interface HiveMetastore {
    public Optional<Database> getDatabase(String var1);

    public List<String> getAllDatabases();

    public Optional<Table> getTable(HiveIdentity var1, String var2, String var3);

    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type var1);

    public PartitionStatistics getTableStatistics(HiveIdentity var1, Table var2);

    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity var1, Table var2, List<Partition> var3);

    public void updateTableStatistics(HiveIdentity var1, String var2, String var3, AcidTransaction var4, Function<PartitionStatistics, PartitionStatistics> var5);

    default public void updatePartitionStatistics(HiveIdentity identity, Table table, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.updatePartitionStatistics(identity, table, (Map<String, Function<PartitionStatistics, PartitionStatistics>>)ImmutableMap.of((Object)partitionName, update));
    }

    public void updatePartitionStatistics(HiveIdentity var1, Table var2, Map<String, Function<PartitionStatistics, PartitionStatistics>> var3);

    public List<String> getAllTables(String var1);

    public List<String> getTablesWithParameter(String var1, String var2, String var3);

    public List<String> getAllViews(String var1);

    public void createDatabase(HiveIdentity var1, Database var2);

    public void dropDatabase(HiveIdentity var1, String var2);

    public void renameDatabase(HiveIdentity var1, String var2, String var3);

    public void setDatabaseOwner(HiveIdentity var1, String var2, HivePrincipal var3);

    public void createTable(HiveIdentity var1, Table var2, PrincipalPrivileges var3);

    public void dropTable(HiveIdentity var1, String var2, String var3, boolean var4);

    public void replaceTable(HiveIdentity var1, String var2, String var3, Table var4, PrincipalPrivileges var5);

    public void renameTable(HiveIdentity var1, String var2, String var3, String var4, String var5);

    public void commentTable(HiveIdentity var1, String var2, String var3, Optional<String> var4);

    public void setTableOwner(HiveIdentity var1, String var2, String var3, HivePrincipal var4);

    public void commentColumn(HiveIdentity var1, String var2, String var3, String var4, Optional<String> var5);

    public void addColumn(HiveIdentity var1, String var2, String var3, String var4, HiveType var5, String var6);

    public void renameColumn(HiveIdentity var1, String var2, String var3, String var4, String var5);

    public void dropColumn(HiveIdentity var1, String var2, String var3, String var4);

    public Optional<Partition> getPartition(HiveIdentity var1, Table var2, List<String> var3);

    public Optional<List<String>> getPartitionNamesByFilter(HiveIdentity var1, String var2, String var3, List<String> var4, TupleDomain<String> var5);

    public Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity var1, Table var2, List<String> var3);

    public void addPartitions(HiveIdentity var1, String var2, String var3, List<PartitionWithStatistics> var4);

    public void dropPartition(HiveIdentity var1, String var2, String var3, List<String> var4, boolean var5);

    public void alterPartition(HiveIdentity var1, String var2, String var3, PartitionWithStatistics var4);

    public void createRole(String var1, String var2);

    public void dropRole(String var1);

    public Set<String> listRoles();

    public void grantRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public void revokeRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public Set<RoleGrant> listGrantedPrincipals(String var1);

    public Set<RoleGrant> listRoleGrants(HivePrincipal var1);

    public void grantTablePrivileges(String var1, String var2, String var3, HivePrincipal var4, Set<HivePrivilegeInfo> var5);

    public void revokeTablePrivileges(String var1, String var2, String var3, HivePrincipal var4, Set<HivePrivilegeInfo> var5);

    public Set<HivePrivilegeInfo> listTablePrivileges(String var1, String var2, String var3, Optional<HivePrincipal> var4);

    public boolean isImpersonationEnabled();

    default public long openTransaction(HiveIdentity identity) {
        throw new UnsupportedOperationException();
    }

    default public void commitTransaction(HiveIdentity identity, long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void sendTransactionHeartbeat(HiveIdentity identity, long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void acquireSharedReadLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        throw new UnsupportedOperationException();
    }

    default public String getValidWriteIds(HiveIdentity identity, List<SchemaTableName> tables, long currentTransactionId) {
        throw new UnsupportedOperationException();
    }

    default public Optional<String> getConfigValue(String name) {
        return Optional.empty();
    }

    default public long allocateWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void acquireTableWriteLock(HiveIdentity identity, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        throw new UnsupportedOperationException();
    }

    default public void updateTableWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        throw new UnsupportedOperationException();
    }

    default public void alterPartitions(HiveIdentity identity, String dbName, String tableName, List<Partition> partitions, long writeId) {
        throw new UnsupportedOperationException();
    }

    default public void addDynamicPartitions(HiveIdentity identity, String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        throw new UnsupportedOperationException();
    }

    default public void alterTransactionalTable(HiveIdentity identity, Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        throw new UnsupportedOperationException();
    }
}

