/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import io.trino.plugin.hive.ConfigurationInitializer;
import io.trino.plugin.hive.gcs.GcsAccessTokenProvider;
import io.trino.plugin.hive.gcs.HiveGcsConfig;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class GoogleGcsConfigurationInitializer
implements ConfigurationInitializer {
    private final boolean useGcsAccessToken;
    private final String jsonKeyFilePath;

    @Inject
    public GoogleGcsConfigurationInitializer(HiveGcsConfig config) {
        this.useGcsAccessToken = config.isUseGcsAccessToken();
        this.jsonKeyFilePath = config.getJsonKeyFilePath();
    }

    @Override
    public void initializeConfiguration(Configuration config) {
        config.set("fs.gs.impl", GoogleHadoopFileSystem.class.getName());
        if (this.useGcsAccessToken) {
            config.set(GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_ENABLE.getKey(), "false");
            config.set("fs.gs.auth.access.token.provider.impl", GcsAccessTokenProvider.class.getName());
        } else if (this.jsonKeyFilePath != null) {
            config.set(GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_ENABLE.getKey(), "true");
            config.set("fs.gs.auth.service.account.json.keyfile", this.jsonKeyFilePath);
        }
    }
}

