/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.authentication;

import io.trino.plugin.hive.authentication.GenericExceptionAction;
import org.apache.hadoop.security.UserGroupInformation;

public final class UserGroupInformationUtils {
    private UserGroupInformationUtils() {
    }

    public static <R, E extends Exception> R executeActionInDoAs(UserGroupInformation userGroupInformation, GenericExceptionAction<R, E> action) throws E {
        return (R)((ResultOrException)userGroupInformation.doAs(() -> {
            try {
                return new ResultOrException(action.run(), null);
            }
            catch (Throwable e) {
                return new ResultOrException(null, e);
            }
        })).get();
    }

    private static class ResultOrException<T, E extends Exception> {
        private final T result;
        private final Throwable exception;

        public ResultOrException(T result, Throwable exception) {
            this.result = result;
            this.exception = exception;
        }

        public T get() throws E {
            if (this.exception != null) {
                if (this.exception instanceof Error) {
                    throw (Error)this.exception;
                }
                if (this.exception instanceof RuntimeException) {
                    throw (RuntimeException)this.exception;
                }
                throw (Exception)this.exception;
            }
            return this.result;
        }
    }
}

