/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.authentication;

import io.trino.plugin.hive.ForHdfs;
import io.trino.plugin.hive.authentication.GenericExceptionAction;
import io.trino.plugin.hive.authentication.HadoopAuthentication;
import io.trino.plugin.hive.authentication.HdfsAuthentication;
import io.trino.plugin.hive.authentication.UserGroupInformationUtils;
import io.trino.plugin.hive.authentication.UserNameProvider;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.security.UserGroupInformation;

public class ImpersonatingHdfsAuthentication
implements HdfsAuthentication {
    private final HadoopAuthentication hadoopAuthentication;
    private final UserNameProvider userNameProvider;

    @Inject
    public ImpersonatingHdfsAuthentication(@ForHdfs HadoopAuthentication hadoopAuthentication, @ForHdfs UserNameProvider userNameProvider) {
        this.hadoopAuthentication = Objects.requireNonNull(hadoopAuthentication);
        this.userNameProvider = Objects.requireNonNull(userNameProvider);
    }

    @Override
    public <R, E extends Exception> R doAs(ConnectorIdentity identity, GenericExceptionAction<R, E> action) throws E {
        return UserGroupInformationUtils.executeActionInDoAs(this.createProxyUser(this.userNameProvider.get(identity)), action);
    }

    private UserGroupInformation createProxyUser(String user) {
        return UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)this.hadoopAuthentication.getUserGroupInformation());
    }
}

