/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.authentication;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.authentication.KerberosAuthentication;
import io.trino.plugin.hive.ForHdfs;
import io.trino.plugin.hive.HdfsConfigurationInitializer;
import io.trino.plugin.hive.authentication.CachingKerberosHadoopAuthentication;
import io.trino.plugin.hive.authentication.DirectHdfsAuthentication;
import io.trino.plugin.hive.authentication.HadoopAuthentication;
import io.trino.plugin.hive.authentication.HdfsAuthentication;
import io.trino.plugin.hive.authentication.HdfsKerberosConfig;
import io.trino.plugin.hive.authentication.ImpersonatingHdfsAuthentication;
import io.trino.plugin.hive.authentication.KerberosHadoopAuthentication;
import io.trino.plugin.hive.authentication.NoHdfsAuthentication;
import io.trino.plugin.hive.authentication.SimpleHadoopAuthentication;
import io.trino.plugin.hive.authentication.SimpleUserNameProvider;
import io.trino.plugin.hive.authentication.UserNameProvider;
import javax.inject.Inject;

public final class AuthenticationModules {
    private AuthenticationModules() {
    }

    public static Module noHdfsAuthenticationModule() {
        return binder -> binder.bind(HdfsAuthentication.class).to(NoHdfsAuthentication.class).in(Scopes.SINGLETON);
    }

    public static Module simpleImpersonatingHdfsAuthenticationModule() {
        return binder -> {
            binder.bind(HadoopAuthentication.class).annotatedWith(ForHdfs.class).to(SimpleHadoopAuthentication.class);
            OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(UserNameProvider.class, ForHdfs.class)).setDefault().to(SimpleUserNameProvider.class).in(Scopes.SINGLETON);
            binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
        };
    }

    public static Module kerberosHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HdfsAuthentication.class).to(DirectHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config, HdfsConfigurationInitializer updater) {
                String principal = config.getHdfsTrinoPrincipal();
                String keytabLocation = config.getHdfsTrinoKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
            }
        };
    }

    public static Module kerberosImpersonatingHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(UserNameProvider.class, ForHdfs.class)).setDefault().to(SimpleUserNameProvider.class).in(Scopes.SINGLETON);
                binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config, HdfsConfigurationInitializer updater) {
                String principal = config.getHdfsTrinoPrincipal();
                String keytabLocation = config.getHdfsTrinoKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation, updater);
            }
        };
    }

    public static HadoopAuthentication createCachingKerberosHadoopAuthentication(String principal, String keytabLocation, HdfsConfigurationInitializer updater) {
        KerberosAuthentication kerberosAuthentication = new KerberosAuthentication(principal, keytabLocation);
        KerberosHadoopAuthentication kerberosHadoopAuthentication = KerberosHadoopAuthentication.createKerberosHadoopAuthentication(kerberosAuthentication, updater);
        return new CachingKerberosHadoopAuthentication(kerberosHadoopAuthentication);
    }
}

