/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.acid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.orc.OrcWriter;
import io.trino.plugin.hive.HiveUpdateProcessor;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidOperation;
import java.util.Objects;
import java.util.Optional;

public class AcidTransaction {
    public static final AcidTransaction NO_ACID_TRANSACTION = new AcidTransaction(AcidOperation.NONE, 0L, 0L, Optional.empty());
    private final AcidOperation operation;
    private final long transactionId;
    private final long writeId;
    private final Optional<HiveUpdateProcessor> updateProcessor;

    @JsonCreator
    public AcidTransaction(@JsonProperty(value="operation") AcidOperation operation, @JsonProperty(value="transactionId") long transactionId, @JsonProperty(value="writeId") long writeId, @JsonProperty(value="updateProcessor") Optional<HiveUpdateProcessor> updateProcessor) {
        this.operation = Objects.requireNonNull(operation, "operation is null");
        this.transactionId = transactionId;
        this.writeId = writeId;
        this.updateProcessor = updateProcessor;
    }

    @JsonProperty(value="operation")
    public AcidOperation getOperation() {
        return this.operation;
    }

    @JsonProperty(value="transactionId")
    public long getAcidTransactionIdForSerialization() {
        return this.transactionId;
    }

    @JsonProperty(value="writeId")
    public long getWriteIdForSerialization() {
        return this.writeId;
    }

    @JsonProperty
    public Optional<HiveUpdateProcessor> getUpdateProcessor() {
        return this.updateProcessor;
    }

    @JsonIgnore
    public boolean isAcidTransactionRunning() {
        return this.operation == AcidOperation.INSERT || this.operation == AcidOperation.DELETE || this.operation == AcidOperation.UPDATE;
    }

    @JsonIgnore
    public boolean isTransactional() {
        return this.operation != AcidOperation.NONE;
    }

    @JsonIgnore
    public Optional<OrcWriter.OrcOperation> getOrcOperation() {
        this.ensureTransactionRunning("accessing orcOperation");
        return this.operation.getOrcOperation();
    }

    @JsonIgnore
    public long getAcidTransactionId() {
        this.ensureTransactionRunning("accessing transactionId");
        return this.transactionId;
    }

    @JsonIgnore
    public long getWriteId() {
        this.ensureTransactionRunning("accessing writeId");
        return this.writeId;
    }

    private void ensureTransactionRunning(String description) {
        Preconditions.checkState((boolean)this.isAcidTransactionRunning(), (String)"Not in ACID transaction while %s", (Object)description);
    }

    @JsonIgnore
    public boolean isInsert() {
        return this.operation == AcidOperation.INSERT;
    }

    @JsonIgnore
    public boolean isDelete() {
        return this.operation == AcidOperation.DELETE;
    }

    @JsonIgnore
    public boolean isUpdate() {
        return this.operation == AcidOperation.UPDATE;
    }

    public boolean isAcidInsertOperation(WriterKind writerKind) {
        return this.isInsert() || this.isUpdate() && writerKind == WriterKind.INSERT;
    }

    public boolean isAcidDeleteOperation(WriterKind writerKind) {
        return this.isDelete() || this.isUpdate() && writerKind == WriterKind.DELETE;
    }

    public static AcidTransaction forCreateTable() {
        return new AcidTransaction(AcidOperation.CREATE_TABLE, 0L, 0L, Optional.empty());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.operation).add("transactionId", this.transactionId).add("writeId", this.writeId).toString();
    }
}

