/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import io.trino.plugin.hive.HiveMetadata;
import io.trino.plugin.hive.SystemTableHandler;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.SystemTables;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class PropertiesSystemTableProvider
implements SystemTableProvider {
    @Override
    public Optional<SchemaTableName> getSourceTableName(SchemaTableName tableName) {
        if (!SystemTableHandler.PROPERTIES.matches(tableName)) {
            return Optional.empty();
        }
        return Optional.of(SystemTableHandler.PROPERTIES.getSourceTableName(tableName));
    }

    @Override
    public Optional<SystemTable> getSystemTable(HiveMetadata metadata, ConnectorSession session, SchemaTableName tableName) {
        if (!SystemTableHandler.PROPERTIES.matches(tableName)) {
            return Optional.empty();
        }
        SchemaTableName sourceTableName = SystemTableHandler.PROPERTIES.getSourceTableName(tableName);
        Optional<Table> table = metadata.getMetastore().getTable(new HiveIdentity(session), sourceTableName.getSchemaName(), sourceTableName.getTableName());
        if (table.isEmpty()) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableSortedMap sortedTableParameters = ImmutableSortedMap.copyOf(table.get().getParameters());
        List columns = (List)sortedTableParameters.keySet().stream().map(key -> new ColumnMetadata(key, (Type)VarcharType.VARCHAR)).collect(ImmutableList.toImmutableList());
        List types = (List)columns.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        ImmutableList propertyValues = ImmutableList.of((Object)ImmutableList.copyOf(sortedTableParameters.values()));
        return Optional.of(SystemTables.createSystemTable(new ConnectorTableMetadata(sourceTableName, columns), arg_0 -> PropertiesSystemTableProvider.lambda$getSystemTable$1(types, (Iterable)propertyValues, arg_0)));
    }

    private static /* synthetic */ RecordCursor lambda$getSystemTable$1(List types, Iterable propertyValues, TupleDomain constraint) {
        return new InMemoryRecordSet((Collection)types, propertyValues).cursor();
    }
}

