/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.util.ForwardingRecordCursor;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class HiveRecordCursor
extends ForwardingRecordCursor {
    private final RecordCursor delegate;
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Type[] types;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;

    public HiveRecordCursor(List<HivePageSourceProvider.ColumnMapping> columnMappings, RecordCursor delegate) {
        Objects.requireNonNull(columnMappings, "columnMappings is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        int size = columnMappings.size();
        this.types = new Type[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.EMPTY) {
                this.nulls[columnIndex] = true;
            }
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.PREFILLED) continue;
            String columnValue = columnMapping.getPrefilledValue();
            byte[] bytes = columnValue.getBytes(StandardCharsets.UTF_8);
            String name = columnMapping.getHiveColumnHandle().getName();
            this.types[columnIndex] = type = columnMapping.getHiveColumnHandle().getType();
            if (HiveUtil.isHiveNull(bytes)) {
                this.nulls[columnIndex] = true;
                continue;
            }
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                this.booleans[columnIndex] = HiveUtil.booleanPartitionKey(columnValue, name);
                continue;
            }
            if (TinyintType.TINYINT.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.tinyintPartitionKey(columnValue, name);
                continue;
            }
            if (SmallintType.SMALLINT.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.smallintPartitionKey(columnValue, name);
                continue;
            }
            if (IntegerType.INTEGER.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.integerPartitionKey(columnValue, name);
                continue;
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.bigintPartitionKey(columnValue, name);
                continue;
            }
            if (RealType.REAL.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.floatPartitionKey(columnValue, name);
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)type)) {
                this.doubles[columnIndex] = HiveUtil.doublePartitionKey(columnValue, name);
                continue;
            }
            if (type instanceof VarcharType) {
                this.slices[columnIndex] = HiveUtil.varcharPartitionKey(columnValue, name, type);
                continue;
            }
            if (type instanceof CharType) {
                this.slices[columnIndex] = HiveUtil.charPartitionKey(columnValue, name, type);
                continue;
            }
            if (DateType.DATE.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.datePartitionKey(columnValue, name);
                continue;
            }
            if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.timestampPartitionKey(columnValue, name);
                continue;
            }
            if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
                this.longs[columnIndex] = DateTimeEncoding.packDateTimeWithZone((long)Math.floorDiv(HiveUtil.timestampPartitionKey(columnValue, name), 1000), (String)DateTimeZone.getDefault().getID());
                continue;
            }
            if (Decimals.isShortDecimal((Type)type)) {
                this.longs[columnIndex] = HiveUtil.shortDecimalPartitionKey(columnValue, (DecimalType)type, name);
                continue;
            }
            if (Decimals.isLongDecimal((Type)type)) {
                this.slices[columnIndex] = HiveUtil.longDecimalPartitionKey(columnValue, (DecimalType)type, name);
                continue;
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for prefilled column: %s", type.getDisplayName(), name));
        }
    }

    @Override
    protected RecordCursor delegate() {
        return this.delegate;
    }

    @Override
    public Type getType(int field) {
        return this.types[field];
    }

    @Override
    public boolean getBoolean(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getBoolean(columnMapping.getIndex());
        }
        return this.booleans[field];
    }

    @Override
    public long getLong(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getLong(columnMapping.getIndex());
        }
        return this.longs[field];
    }

    @Override
    public double getDouble(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getDouble(columnMapping.getIndex());
        }
        return this.doubles[field];
    }

    @Override
    public Slice getSlice(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getSlice(columnMapping.getIndex());
        }
        return this.slices[field];
    }

    @Override
    public Object getObject(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.getObject(columnMapping.getIndex());
        }
        return this.objects[field];
    }

    @Override
    public boolean isNull(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (columnMapping.getKind() == HivePageSourceProvider.ColumnMappingKind.REGULAR) {
            return this.delegate.isNull(columnMapping.getIndex());
        }
        return this.nulls[field];
    }

    @VisibleForTesting
    RecordCursor getRegularColumnRecordCursor() {
        return this.delegate;
    }
}

