/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;
import java.util.Optional;

public class HiveNotReadableException
extends TrinoException {
    private final SchemaTableName tableName;
    private final Optional<String> partition;

    public HiveNotReadableException(SchemaTableName tableName, Optional<String> partition, String message) {
        super((ErrorCodeSupplier)(partition.isPresent() ? HiveErrorCode.HIVE_PARTITION_NOT_READABLE : HiveErrorCode.HIVE_TABLE_READ_ONLY), HiveNotReadableException.composeMessage(tableName, partition, message));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partition = Objects.requireNonNull(partition, "partition is null");
    }

    private static String composeMessage(SchemaTableName tableName, Optional<String> partition, String message) {
        return partition.isPresent() ? String.format("Table '%s' partition '%s' is not readable: %s", tableName, partition.get(), message) : String.format("Table '%s' is not readable: %s", tableName, message);
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public Optional<String> getPartition() {
        return this.partition;
    }
}

