/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveAnalyzeProperties;
import io.trino.plugin.hive.HiveApplyProjectionUtil;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveInputInfo;
import io.trino.plugin.hive.HiveInsertTableHandle;
import io.trino.plugin.hive.HiveMaterializedViewMetadata;
import io.trino.plugin.hive.HiveOutputTableHandle;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HivePartitionResult;
import io.trino.plugin.hive.HivePartitioningHandle;
import io.trino.plugin.hive.HiveRedirectionsProvider;
import io.trino.plugin.hive.HiveSchemaProperties;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTableProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveUpdateProcessor;
import io.trino.plugin.hive.HiveViewNotSupportedException;
import io.trino.plugin.hive.HiveWritableTableHandle;
import io.trino.plugin.hive.HiveWriterFactory;
import io.trino.plugin.hive.HiveWrittenPartitions;
import io.trino.plugin.hive.LocationHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.PartitionAndStatementId;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.ViewAlreadyExistsException;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidSchema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.statistics.HiveStatisticsProvider;
import io.trino.plugin.hive.util.CompressionConfigUtil;
import io.trino.plugin.hive.util.ConfigurationUtils;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.plugin.hive.util.Statistics;
import io.trino.plugin.hive.util.SystemTables;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorNewTableLayout;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTablePartitioning;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.DiscretePredicates;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortingProperty;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.mapred.JobConf;

public class HiveMetadata
implements TransactionalMetadata {
    public static final String PRESTO_VERSION_NAME = "presto_version";
    public static final String TRINO_CREATED_BY = "trino_created_by";
    public static final String PRESTO_QUERY_ID_NAME = "presto_query_id";
    public static final String BUCKETING_VERSION = "bucketing_version";
    public static final String TABLE_COMMENT = "comment";
    public static final String STORAGE_TABLE = "storage_table";
    private static final String TRANSACTIONAL = "transactional";
    public static final String PRESTO_VIEW_COMMENT = "Presto View";
    public static final String PRESTO_VIEW_EXPANDED_TEXT_MARKER = "/* Presto View */";
    private static final String ORC_BLOOM_FILTER_COLUMNS_KEY = "orc.bloom.filter.columns";
    private static final String ORC_BLOOM_FILTER_FPP_KEY = "orc.bloom.filter.fpp";
    public static final String SKIP_HEADER_COUNT_KEY = "skip.header.line.count";
    public static final String SKIP_FOOTER_COUNT_KEY = "skip.footer.line.count";
    private static final String TEXT_FIELD_SEPARATOR_KEY = "field.delim";
    private static final String TEXT_FIELD_SEPARATOR_ESCAPE_KEY = "escape.delim";
    private static final String NULL_FORMAT_KEY = "serialization.null.format";
    public static final String AVRO_SCHEMA_URL_KEY = "avro.schema.url";
    private static final String CSV_SEPARATOR_KEY = "separatorChar";
    private static final String CSV_QUOTE_KEY = "quoteChar";
    private static final String CSV_ESCAPE_KEY = "escapeChar";
    private final CatalogName catalogName;
    private final SemiTransactionalHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final boolean translateHiveViews;
    private final boolean hideDeltaLakeTables;
    private final String prestoVersion;
    private final HiveStatisticsProvider hiveStatisticsProvider;
    private final HiveRedirectionsProvider hiveRedirectionsProvider;
    private final Set<SystemTableProvider> systemTableProviders;
    private final HiveMaterializedViewMetadata hiveMaterializedViewMetadata;
    private final AccessControlMetadata accessControlMetadata;

    public HiveMetadata(CatalogName catalogName, SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, boolean translateHiveViews, boolean hideDeltaLakeTables, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, String trinoVersion, HiveStatisticsProvider hiveStatisticsProvider, HiveRedirectionsProvider hiveRedirectionsProvider, Set<SystemTableProvider> systemTableProviders, HiveMaterializedViewMetadata hiveMaterializedViewMetadata, AccessControlMetadata accessControlMetadata) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.translateHiveViews = translateHiveViews;
        this.hideDeltaLakeTables = hideDeltaLakeTables;
        this.prestoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.hiveStatisticsProvider = Objects.requireNonNull(hiveStatisticsProvider, "hiveStatisticsProvider is null");
        this.hiveRedirectionsProvider = Objects.requireNonNull(hiveRedirectionsProvider, "hiveRedirectionsProvider is null");
        this.systemTableProviders = Objects.requireNonNull(systemTableProviders, "systemTableProviders is null");
        this.hiveMaterializedViewMetadata = Objects.requireNonNull(hiveMaterializedViewMetadata, "hiveMaterializedViewMetadata is null");
        this.accessControlMetadata = Objects.requireNonNull(accessControlMetadata, "accessControlMetadata is null");
    }

    @Override
    public SemiTransactionalHiveMetastore getMetastore() {
        return this.metastore;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.metastore.getAllDatabases().stream().filter(schemaName -> !HiveUtil.isHiveSystemSchema(schemaName)).collect(ImmutableList.toImmutableList());
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (HiveUtil.isHiveSystemSchema(tableName.getSchemaName())) {
            return null;
        }
        Optional<Table> table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        if (table.isEmpty()) {
            return null;
        }
        if (HiveUtil.isDeltaLakeTable(table.get())) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Cannot query Delta Lake table");
        }
        if (SystemTables.getSourceTableNameFromSystemTable(this.systemTableProviders, tableName).isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Unexpected table present in Hive metastore: " + tableName);
        }
        MetastoreUtil.verifyOnline(tableName, Optional.empty(), MetastoreUtil.getProtectMode(table.get()), table.get().getParameters());
        return new HiveTableHandle(tableName.getSchemaName(), tableName.getTableName(), table.get().getParameters(), HiveUtil.getPartitionKeyColumnHandles(table.get(), this.typeManager), HiveUtil.getRegularColumnHandles(table.get(), this.typeManager, HiveSessionProperties.getTimestampPrecision(session)), HiveBucketing.getHiveBucketHandle(session, table.get(), this.typeManager));
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        HiveTableHandle handle = this.getTableHandle(session, tableName);
        if (handle == null) {
            return null;
        }
        Optional<List<List<String>>> partitionValuesList = HiveAnalyzeProperties.getPartitionList(analyzeProperties);
        Optional<Set<String>> analyzeColumnNames = HiveAnalyzeProperties.getColumnNames(analyzeProperties);
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, handle.getSchemaTableName());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        if (partitionValuesList.isPresent()) {
            List<List<String>> list = partitionValuesList.get();
            if (partitionedBy.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Partition list provided but table is not partitioned");
            }
            for (List<String> values : list) {
                if (values.size() == partitionedBy.size()) continue;
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Partition value count does not match partition column count");
            }
            handle = handle.withAnalyzePartitionValues(list);
            HivePartitionResult partitions = this.partitionManager.getPartitions(handle, list);
            handle = this.partitionManager.applyPartitionResult(handle, partitions, Optional.empty());
        }
        if (analyzeColumnNames.isPresent()) {
            Set<String> columnNames = analyzeColumnNames.get();
            Set allColumnNames = (Set)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
            if (!allColumnNames.containsAll(columnNames)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid columns specified for analysis: %s", Sets.difference(columnNames, (Set)allColumnNames)));
            }
            handle = handle.withAnalyzeColumnNames(columnNames);
        }
        return handle;
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        for (SystemTableProvider systemTableProvider : this.systemTableProviders) {
            Optional<SystemTable> systemTable = systemTableProvider.getSystemTable(this, session, tableName);
            if (!systemTable.isPresent()) continue;
            return systemTable;
        }
        return Optional.empty();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, hiveTableHandle.getSchemaTableName());
        return hiveTableHandle.getAnalyzeColumnNames().map(columnNames -> new ConnectorTableMetadata(tableMetadata.getTable(), tableMetadata.getColumns(), (Map)ImmutableMap.builder().putAll(tableMetadata.getProperties()).put((Object)"presto.analyze_columns", columnNames).build(), tableMetadata.getComment())).orElse(tableMetadata);
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        try {
            return this.doGetTableMetadata(session, tableName);
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to construct table metadata for table " + tableName, e);
        }
    }

    private ConnectorTableMetadata doGetTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        String avroSchemaUrl;
        String orcBloomFilterFfp;
        String orcBloomFilterColumns;
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        if (!this.translateHiveViews && ViewReaderUtil.isHiveOrPrestoView(table)) {
            throw new TableNotFoundException(tableName);
        }
        Function<HiveColumnHandle, ColumnMetadata> metadataGetter = HiveMetadata.columnMetadataGetter(table);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(table, this.typeManager, HiveSessionProperties.getTimestampPrecision(session))) {
            columns.add((Object)metadataGetter.apply(columnHandle));
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        if (table.getTableType().equals(TableType.EXTERNAL_TABLE.name())) {
            properties.put((Object)"external_location", (Object)table.getStorage().getLocation());
        }
        try {
            HiveStorageFormat format = HiveMetadata.extractHiveStorageFormat(table);
            properties.put((Object)"format", (Object)format);
        }
        catch (TrinoException format) {
            // empty catch block
        }
        List partitionedBy = table.getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        if (!partitionedBy.isEmpty()) {
            properties.put((Object)"partitioned_by", partitionedBy);
        }
        table.getStorage().getBucketProperty().ifPresent(property -> {
            properties.put((Object)BUCKETING_VERSION, (Object)property.getBucketingVersion().getVersion());
            properties.put((Object)"bucket_count", (Object)property.getBucketCount());
            properties.put((Object)"bucketed_by", property.getBucketedBy());
            properties.put((Object)"sorted_by", property.getSortedBy());
        });
        String transactionalProperty = table.getParameters().get(TRANSACTIONAL);
        if (Boolean.parseBoolean(transactionalProperty)) {
            properties.put((Object)TRANSACTIONAL, (Object)true);
        }
        if ((orcBloomFilterColumns = table.getParameters().get(ORC_BLOOM_FILTER_COLUMNS_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_columns", (Object)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)orcBloomFilterColumns));
        }
        if ((orcBloomFilterFfp = table.getParameters().get(ORC_BLOOM_FILTER_FPP_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_fpp", (Object)Double.parseDouble(orcBloomFilterFfp));
        }
        if ((avroSchemaUrl = table.getParameters().get(AVRO_SCHEMA_URL_KEY)) != null) {
            properties.put((Object)"avro_schema_url", (Object)avroSchemaUrl);
        }
        HiveMetadata.getSerdeProperty(table, SKIP_HEADER_COUNT_KEY).ifPresent(skipHeaderCount -> properties.put((Object)"skip_header_line_count", (Object)Integer.valueOf(skipHeaderCount)));
        HiveMetadata.getSerdeProperty(table, SKIP_FOOTER_COUNT_KEY).ifPresent(skipFooterCount -> properties.put((Object)"skip_footer_line_count", (Object)Integer.valueOf(skipFooterCount)));
        HiveMetadata.getSerdeProperty(table, NULL_FORMAT_KEY).ifPresent(nullFormat -> properties.put((Object)"null_format", nullFormat));
        HiveMetadata.getSerdeProperty(table, TEXT_FIELD_SEPARATOR_KEY).ifPresent(fieldSeparator -> properties.put((Object)"textfile_field_separator", fieldSeparator));
        HiveMetadata.getSerdeProperty(table, TEXT_FIELD_SEPARATOR_ESCAPE_KEY).ifPresent(fieldEscape -> properties.put((Object)"textfile_field_separator_escape", fieldEscape));
        HiveMetadata.getCsvSerdeProperty(table, CSV_SEPARATOR_KEY).ifPresent(csvSeparator -> properties.put((Object)"csv_separator", csvSeparator));
        HiveMetadata.getCsvSerdeProperty(table, CSV_QUOTE_KEY).ifPresent(csvQuote -> properties.put((Object)"csv_quote", csvQuote));
        HiveMetadata.getCsvSerdeProperty(table, CSV_ESCAPE_KEY).ifPresent(csvEscape -> properties.put((Object)"csv_escape", csvEscape));
        Optional<String> comment = Optional.ofNullable(table.getParameters().get(TABLE_COMMENT));
        return new ConnectorTableMetadata(tableName, (List)columns.build(), (Map)properties.build(), comment);
    }

    private static Optional<String> getCsvSerdeProperty(Table table, String key) {
        return HiveMetadata.getSerdeProperty(table, key).map(csvSerdeProperty -> csvSerdeProperty.substring(0, 1));
    }

    private static Optional<String> getSerdeProperty(Table table, String key) {
        String serdePropertyValue = table.getStorage().getSerdeParameters().get(key);
        String tablePropertyValue = table.getParameters().get(key);
        if (serdePropertyValue != null && tablePropertyValue != null && !tablePropertyValue.equals(serdePropertyValue)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Different values for '%s' set in serde properties and table properties: '%s' and '%s'", key, serdePropertyValue, tablePropertyValue));
        }
        return HiveMetadata.firstNonNullable(tablePropertyValue, serdePropertyValue);
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        return ((HiveTableHandle)table).getPartitions().map(partitions -> new HiveInputInfo((List)partitions.stream().map(HivePartition::getPartitionId).collect(ImmutableList.toImmutableList()), false));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllTables(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        tableNames.addAll(this.listMaterializedViews(session, optionalSchemaName));
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent()) {
            if (HiveUtil.isHiveSystemSchema(schemaName.get())) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)schemaName.get());
        }
        return this.listSchemaNames(session);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return (Map)HiveUtil.hiveColumnHandles(table, this.typeManager, HiveSessionProperties.getTimestampPrecision(session)).stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableName).getColumns());
            }
            catch (HiveViewNotSupportedException hiveViewNotSupportedException) {
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (TrinoException e) {
                if (e.getErrorCode().getType().equals((Object)ErrorType.EXTERNAL)) continue;
                throw e;
            }
        }
        return columns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        Map columns = (Map)this.getColumnHandles(session, tableHandle).entrySet().stream().filter(entry -> !((HiveColumnHandle)entry.getValue()).isHidden()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map columnTypes = (Map)columns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.getColumnMetadata(session, tableHandle, (ColumnHandle)entry.getValue()).getType()));
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, new HiveIdentity(session), tableHandle, constraint);
        List<HivePartition> partitions = this.partitionManager.getPartitionsAsList(partitionResult);
        return this.hiveStatisticsProvider.getTableStatistics(session, ((HiveTableHandle)tableHandle).getSchemaTableName(), columns, columnTypes, partitions);
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        Optional<Table> optionalTable;
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        SchemaTableName tableName = prefix.toSchemaTableName();
        if (HiveUtil.isHiveSystemSchema(tableName.getSchemaName())) {
            return ImmutableList.of();
        }
        try {
            optionalTable = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        }
        catch (HiveViewNotSupportedException e) {
            return ImmutableList.of((Object)tableName);
        }
        return (List)optionalTable.filter(table -> !this.hideDeltaLakeTables || !HiveUtil.isDeltaLakeTable(table)).map(table -> ImmutableList.of((Object)tableName)).orElseGet(ImmutableList::of);
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        Optional<String> location = HiveSchemaProperties.getLocation(properties).map(locationUri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), new Path(locationUri));
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
            }
            return locationUri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(owner.getType()).setOwnerName(owner.getName()).build();
        this.metastore.createDatabase(new HiveIdentity(session), database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.metastore.dropDatabase(new HiveIdentity(session), schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(new HiveIdentity(session), source, target);
    }

    public void setSchemaAuthorization(ConnectorSession session, String source, TrinoPrincipal principal) {
        this.metastore.setDatabaseOwner(new HiveIdentity(session), source, HivePrincipal.from(principal));
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional<Object> targetPath;
        boolean external;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (bucketProperty.isPresent() && HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketing columns not supported when Avro schema url is set");
        }
        HiveMetadata.validateTimestampColumns(tableMetadata.getColumns(), HiveSessionProperties.getTimestampPrecision(session));
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy));
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, bucketProperty, new HdfsEnvironment.HdfsContext(session));
        hiveStorageFormat.validateColumns(columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(HiveColumnHandle::toMetastoreColumn).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        String externalLocation = HiveTableProperties.getExternalLocation(tableMetadata.getProperties());
        if (externalLocation != null) {
            if (!this.createsOfNonManagedTablesEnabled) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot create non-managed Hive table");
            }
            external = true;
            targetPath = Optional.of(HiveMetadata.getExternalLocationAsPath(externalLocation));
            this.checkExternalPath(new HdfsEnvironment.HdfsContext(session), targetPath.get());
        } else {
            external = false;
            boolean isTransactional = HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false);
            if (isTransactional && HiveSessionProperties.isDelegateTransactionalManagedTableLocationToMetastore(session)) {
                targetPath = Optional.empty();
            } else {
                LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName, Optional.empty());
                targetPath = Optional.of(this.locationService.getQueryWriteInfo(locationHandle).getTargetPath());
            }
        }
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), schemaName, tableName, session.getUser(), columnHandles, hiveStorageFormat, partitionedBy, bucketProperty, tableProperties, targetPath, external, this.prestoVersion);
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(table.getOwner());
        HiveBasicStatistics basicStatistics = !external && table.getPartitionColumns().isEmpty() ? HiveBasicStatistics.createZeroStatistics() : HiveBasicStatistics.createEmptyStatistics();
        this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), ignoreExisting, new PartitionStatistics(basicStatistics, (Map<String, HiveColumnStatistics>)ImmutableMap.of()));
    }

    private Map<String, String> getEmptyTableProperties(ConnectorTableMetadata tableMetadata, Optional<HiveBucketProperty> bucketProperty, HdfsEnvironment.HdfsContext hdfsContext) {
        String avroSchemaUrl;
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        ImmutableMap.Builder tableProperties = ImmutableMap.builder();
        boolean transactional = HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false);
        tableProperties.put((Object)TRANSACTIONAL, (Object)String.valueOf(transactional));
        bucketProperty.ifPresent(hiveBucketProperty -> tableProperties.put((Object)BUCKETING_VERSION, (Object)Integer.toString(hiveBucketProperty.getBucketingVersion().getVersion())));
        List<String> columns = HiveTableProperties.getOrcBloomFilterColumns(tableMetadata.getProperties());
        if (columns != null && !columns.isEmpty()) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.ORC, "orc_bloom_filter_columns");
            tableProperties.put((Object)ORC_BLOOM_FILTER_COLUMNS_KEY, (Object)Joiner.on((String)",").join(columns));
            tableProperties.put((Object)ORC_BLOOM_FILTER_FPP_KEY, (Object)String.valueOf(HiveTableProperties.getOrcBloomFilterFpp(tableMetadata.getProperties())));
        }
        if ((avroSchemaUrl = HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties())) != null) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.AVRO, "avro_schema_url");
            tableProperties.put((Object)AVRO_SCHEMA_URL_KEY, (Object)this.validateAndNormalizeAvroSchemaUrl(avroSchemaUrl, hdfsContext));
        }
        ImmutableSet csvAndTextFile = ImmutableSet.of((Object)((Object)HiveStorageFormat.TEXTFILE), (Object)((Object)HiveStorageFormat.CSV));
        HiveTableProperties.getHeaderSkipCount(tableMetadata.getProperties()).ifPresent(arg_0 -> HiveMetadata.lambda$getEmptyTableProperties$21(hiveStorageFormat, (Set)csvAndTextFile, tableProperties, arg_0));
        HiveTableProperties.getFooterSkipCount(tableMetadata.getProperties()).ifPresent(arg_0 -> HiveMetadata.lambda$getEmptyTableProperties$22(hiveStorageFormat, (Set)csvAndTextFile, tableProperties, arg_0));
        ImmutableSet allowsNullFormat = ImmutableSet.of((Object)((Object)HiveStorageFormat.TEXTFILE), (Object)((Object)HiveStorageFormat.RCTEXT), (Object)((Object)HiveStorageFormat.SEQUENCEFILE));
        HiveTableProperties.getNullFormat(tableMetadata.getProperties()).ifPresent(arg_0 -> HiveMetadata.lambda$getEmptyTableProperties$23(hiveStorageFormat, (Set)allowsNullFormat, tableProperties, arg_0));
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "textfile_field_separator").ifPresent(separator -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.TEXTFILE, TEXT_FIELD_SEPARATOR_KEY);
            tableProperties.put((Object)TEXT_FIELD_SEPARATOR_KEY, (Object)separator.toString());
        });
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "textfile_field_separator_escape").ifPresent(escape -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.TEXTFILE, TEXT_FIELD_SEPARATOR_ESCAPE_KEY);
            tableProperties.put((Object)TEXT_FIELD_SEPARATOR_ESCAPE_KEY, (Object)escape.toString());
        });
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "csv_escape").ifPresent(escape -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_escape");
            tableProperties.put((Object)CSV_ESCAPE_KEY, (Object)escape.toString());
        });
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "csv_quote").ifPresent(quote -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_quote");
            tableProperties.put((Object)CSV_QUOTE_KEY, (Object)quote.toString());
        });
        HiveTableProperties.getSingleCharacterProperty(tableMetadata.getProperties(), "csv_separator").ifPresent(separator -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_separator");
            tableProperties.put((Object)CSV_SEPARATOR_KEY, (Object)separator.toString());
        });
        tableProperties.put((Object)"numFiles", (Object)"-1");
        tableProperties.put((Object)"totalSize", (Object)"-1");
        tableMetadata.getComment().ifPresent(value -> tableProperties.put((Object)TABLE_COMMENT, value));
        return tableProperties.build();
    }

    private static void checkFormatForProperty(HiveStorageFormat actualStorageFormat, HiveStorageFormat expectedStorageFormat, String propertyName) {
        if (actualStorageFormat != expectedStorageFormat) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", new Object[]{propertyName, actualStorageFormat}));
        }
    }

    private static void checkFormatForProperty(HiveStorageFormat actualStorageFormat, Set<HiveStorageFormat> expectedStorageFormats, String propertyName) {
        if (!expectedStorageFormats.contains((Object)actualStorageFormat)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", new Object[]{propertyName, actualStorageFormat}));
        }
    }

    private String validateAndNormalizeAvroSchemaUrl(String url, HdfsEnvironment.HdfsContext context) {
        try {
            new URL(url).openStream().close();
            return url;
        }
        catch (MalformedURLException e) {
            if (new File(url).exists()) {
                return new File(url).toURI().toString();
            }
            try {
                if (!this.hdfsEnvironment.getFileSystem(context, new Path(url)).exists(new Path(url))) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot locate Avro schema file: " + url);
                }
                return url;
            }
            catch (IOException ex) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Avro schema file is not a valid file system URI: " + url, (Throwable)ex);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot open Avro schema file: " + url, (Throwable)e);
        }
    }

    private static Path getExternalLocationAsPath(String location) {
        try {
            return new Path(location);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI: " + location, (Throwable)e);
        }
    }

    private void checkExternalPath(HdfsEnvironment.HdfsContext context, Path path) {
        try {
            if (!HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path) && !this.hdfsEnvironment.getFileSystem(context, path).isDirectory(path)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location must be a directory: " + path);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI: " + path, (Throwable)e);
        }
    }

    private void checkPartitionTypesSupported(List<Column> partitionColumns) {
        for (Column partitionColumn : partitionColumns) {
            Type partitionType = this.typeManager.getType(partitionColumn.getType().getTypeSignature());
            HiveUtil.verifyPartitionTypeSupported(partitionColumn.getName(), partitionType);
        }
    }

    private static Table buildTableObject(String queryId, String schemaName, String tableName, String tableOwner, List<HiveColumnHandle> columnHandles, HiveStorageFormat hiveStorageFormat, List<String> partitionedBy, Optional<HiveBucketProperty> bucketProperty, Map<String, String> additionalTableParameters, Optional<Path> targetPath, boolean external, String prestoVersion) {
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(HiveColumnHandle::toMetastoreColumn).collect(Collectors.toList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(partitionedBy);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : columnHandles) {
            String name = columnHandle.getName();
            HiveType type = columnHandle.getHiveType();
            if (!partitionColumnNames.contains(name)) {
                Verify.verify((!columnHandle.isPartitionKey() ? 1 : 0) != 0, (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
                columns.add((Object)new Column(name, type, columnHandle.getComment()));
                continue;
            }
            Verify.verify((boolean)columnHandle.isPartitionKey(), (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
        }
        ImmutableMap.Builder tableParameters = ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)queryId).putAll(additionalTableParameters);
        if (external) {
            tableParameters.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(tableOwner).setTableType((external ? TableType.EXTERNAL_TABLE : TableType.MANAGED_TABLE).name()).setDataColumns((List<Column>)columns.build()).setPartitionColumns(partitionColumns).setParameters((Map<String, String>)tableParameters.build());
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat(hiveStorageFormat)).setBucketProperty(bucketProperty).setLocation(targetPath.map(Object::toString));
        return tableBuilder.build();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, handle);
        this.metastore.addColumn(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName(), column.getName(), HiveType.toHiveType(column.getType()), column.getComment());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, hiveTableHandle);
        HiveColumnHandle sourceHandle = (HiveColumnHandle)source;
        this.metastore.renameColumn(new HiveIdentity(session), hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), sourceHandle.getName(), target);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, hiveTableHandle);
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        this.metastore.dropColumn(new HiveIdentity(session), hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), columnHandle.getName());
    }

    public void setTableAuthorization(ConnectorSession session, SchemaTableName table, TrinoPrincipal principal) {
        this.metastore.setTableOwner(new HiveIdentity(session), table.getSchemaName(), table.getTableName(), HivePrincipal.from(principal));
    }

    private void failIfAvroSchemaIsSet(ConnectorSession session, HiveTableHandle handle) {
        Table table = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (table.getParameters().containsKey(AVRO_SCHEMA_URL_KEY) || table.getStorage().getSerdeParameters().containsKey(AVRO_SCHEMA_URL_KEY)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ALTER TABLE not supported when Avro schema url is set");
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.metastore.renameTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName(), newTableName.getSchemaName(), newTableName.getTableName());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.metastore.commentTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName(), comment);
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        this.metastore.commentColumn(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName(), columnHandle.getName(), comment);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        if (this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName()).isEmpty()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        if (this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName()).isEmpty()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        HiveIdentity identity = new HiveIdentity(session);
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = handle.getSchemaTableName();
        Table table = this.metastore.getTable(identity, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        List<Column> partitionColumns = table.getPartitionColumns();
        List partitionColumnNames = (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        HiveTimestampPrecision timestampPrecision = HiveSessionProperties.getTimestampPrecision(session);
        List<HiveColumnHandle> hiveColumnHandles = HiveUtil.hiveColumnHandles(table, this.typeManager, timestampPrecision);
        Map columnTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager, timestampPrecision)));
        Map<List<String>, ComputedStatistics> computedStatisticsMap = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, partitionColumnNames, columnTypes);
        if (partitionColumns.isEmpty()) {
            this.metastore.setTableStatistics(identity, table, this.createPartitionStatistics(columnTypes, computedStatisticsMap.get(ImmutableList.of())));
        } else {
            List partitionValuesList = handle.getAnalyzePartitionValues().isPresent() ? handle.getAnalyzePartitionValues().get() : (List)this.metastore.getPartitionNames(identity, handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(((HiveTableHandle)tableHandle).getSchemaTableName())).stream().map(HiveUtil::toPartitionValues).collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder partitionStatistics = ImmutableMap.builder();
            Map columnStatisticTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !partitionColumnNames.contains(columnHandle.getName())).filter(column -> !column.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> ImmutableSet.copyOf(this.metastore.getSupportedColumnStatistics(column.getType()))));
            Supplier emptyPartitionStatistics = Suppliers.memoize(() -> Statistics.createEmptyPartitionStatistics(columnTypes, columnStatisticTypes));
            int usedComputedStatistics = 0;
            for (List partitionValues : partitionValuesList) {
                ComputedStatistics collectedStatistics = computedStatisticsMap.get(partitionValues);
                if (collectedStatistics == null) {
                    partitionStatistics.put((Object)partitionValues, (Object)((PartitionStatistics)emptyPartitionStatistics.get()));
                    continue;
                }
                ++usedComputedStatistics;
                partitionStatistics.put((Object)partitionValues, (Object)this.createPartitionStatistics(columnTypes, collectedStatistics));
            }
            Verify.verify((usedComputedStatistics == computedStatistics.size() ? 1 : 0) != 0, (String)"All computed statistics must be used", (Object[])new Object[0]);
            this.metastore.setPartitionStatistics(identity, table, (Map<List<String>, PartitionStatistics>)partitionStatistics.build());
        }
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        Optional<Path> externalLocation = Optional.ofNullable(HiveTableProperties.getExternalLocation(tableMetadata.getProperties())).map(HiveMetadata::getExternalLocationAsPath);
        if (!this.createsOfNonManagedTablesEnabled && externalLocation.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Creating non-managed Hive tables is disabled");
        }
        if (!this.writesToNonManagedTablesEnabled && externalLocation.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writes to non-managed Hive tables is disabled");
        }
        boolean isTransactional = HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false);
        if (isTransactional && externalLocation.isEmpty() && HiveSessionProperties.isDelegateTransactionalManagedTableLocationToMetastore(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS is not supported for transactional tables without explicit location if location determining is delegated to metastore");
        }
        if (HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS not supported when Avro schema url is set");
        }
        HiveTableProperties.getHeaderSkipCount(tableMetadata.getProperties()).ifPresent(headerSkipCount -> {
            if (headerSkipCount > 1) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Creating Hive table with data with value of %s property greater than 1 is not supported", SKIP_HEADER_COUNT_KEY));
            }
        });
        HiveTableProperties.getFooterSkipCount(tableMetadata.getProperties()).ifPresent(footerSkipCount -> {
            if (footerSkipCount > 0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Creating Hive table with data with value of %s property greater than 0 is not supported", SKIP_FOOTER_COUNT_KEY));
            }
        });
        HiveStorageFormat tableStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, bucketProperty, new HdfsEnvironment.HdfsContext(session));
        List<HiveColumnHandle> columnHandles = HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy));
        HiveStorageFormat partitionStorageFormat = HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session);
        HiveStorageFormat actualStorageFormat = partitionedBy.isEmpty() ? tableStorageFormat : partitionStorageFormat;
        actualStorageFormat.validateColumns(columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(HiveColumnHandle::toMetastoreColumn).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName, externalLocation);
        boolean transactional = HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false);
        AcidTransaction transaction = transactional ? AcidTransaction.forCreateTable() : AcidTransaction.NO_ACID_TRANSACTION;
        HiveOutputTableHandle result = new HiveOutputTableHandle(schemaName, tableName, columnHandles, this.metastore.generatePageSinkMetadata(new HiveIdentity(session), schemaTableName), locationHandle, tableStorageFormat, partitionStorageFormat, partitionedBy, bucketProperty, session.getUser(), tableProperties, transaction, externalLocation.isPresent());
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), schemaTableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        PartitionStatistics tableStatistics;
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(handle.getLocationHandle());
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), handle.getSchemaName(), handle.getTableName(), handle.getTableOwner(), handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionedBy(), handle.getBucketProperty(), handle.getAdditionalTableParameters(), Optional.of(writeInfo.getTargetPath()), handle.isExternal(), this.prestoVersion);
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(handle.getTableOwner());
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        if (handle.getBucketProperty().isPresent() && HiveSessionProperties.isCreateEmptyBucketFiles(session)) {
            List<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table, true, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                this.createEmptyFiles(session, partitionUpdate.getWritePath(), table, partition, partitionUpdate.getFileNames());
            }
            if (handle.isTransactional()) {
                AcidTransaction transaction = handle.getTransaction();
                List partitionNames = (List)partitionUpdates.stream().map(PartitionUpdate::getName).collect(ImmutableList.toImmutableList());
                this.metastore.addDynamicPartitions(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName(), partitionNames, transaction.getAcidTransactionId(), transaction.getWriteId(), AcidOperation.CREATE_TABLE);
            }
        }
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map<List<String>, ComputedStatistics> partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, handle.getPartitionedBy(), columnTypes);
        if (table.getPartitionColumns().isEmpty()) {
            HiveBasicStatistics basicStatistics = partitionUpdates.stream().map(PartitionUpdate::getStatistics).reduce((first, second) -> Statistics.reduce(first, second, Statistics.ReduceOperator.ADD)).orElse(HiveBasicStatistics.createZeroStatistics());
            tableStatistics = this.createPartitionStatistics(basicStatistics, columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
        } else {
            tableStatistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
        this.metastore.createTable(session, table, principalPrivileges, Optional.of(writeInfo.getWritePath()), false, tableStatistics);
        if (!handle.getPartitionedBy().isEmpty()) {
            if (HiveSessionProperties.isRespectTableFormat(session)) {
                Verify.verify((handle.getPartitionStorageFormat() == handle.getTableStorageFormat() ? 1 : 0) != 0);
            }
            for (PartitionUpdate update : partitionUpdates) {
                Partition partition = this.buildPartitionObject(session, table, update);
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(update.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partition.getValues()));
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), this.buildPartitionObject(session, table, update), update.getWritePath(), partitionStatistics);
            }
        }
        return Optional.of(new HiveWrittenPartitions((List)partitionUpdates.stream().map(PartitionUpdate::getName).collect(ImmutableList.toImmutableList())));
    }

    private List<PartitionUpdate> computePartitionUpdatesForMissingBuckets(ConnectorSession session, HiveWritableTableHandle handle, Table table, boolean isCreateTable, List<PartitionUpdate> partitionUpdates) {
        ImmutableList.Builder partitionUpdatesForMissingBucketsBuilder = ImmutableList.builder();
        HiveStorageFormat storageFormat = table.getPartitionColumns().isEmpty() ? handle.getTableStorageFormat() : handle.getPartitionStorageFormat();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            int bucketCount = handle.getBucketProperty().get().getBucketCount();
            List<String> fileNamesForMissingBuckets = this.computeFileNamesForMissingBuckets(session, storageFormat, partitionUpdate.getTargetPath(), bucketCount, isCreateTable && handle.isTransactional(), partitionUpdate);
            partitionUpdatesForMissingBucketsBuilder.add((Object)new PartitionUpdate(partitionUpdate.getName(), partitionUpdate.getUpdateMode(), partitionUpdate.getWritePath(), partitionUpdate.getTargetPath(), fileNamesForMissingBuckets, 0L, 0L, 0L));
        }
        return partitionUpdatesForMissingBucketsBuilder.build();
    }

    private List<String> computeFileNamesForMissingBuckets(ConnectorSession session, HiveStorageFormat storageFormat, Path targetPath, int bucketCount, boolean transactionalCreateTable, PartitionUpdate partitionUpdate) {
        if (partitionUpdate.getFileNames().size() == bucketCount) {
            return ImmutableList.of();
        }
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        JobConf conf = ConfigurationUtils.toJobConf(this.hdfsEnvironment.getConfiguration(hdfsContext, targetPath));
        CompressionConfigUtil.configureCompression((Configuration)conf, HiveSessionProperties.getCompressionCodec(session));
        String fileExtension = HiveWriterFactory.getFileExtension(conf, StorageFormat.fromHiveStorageFormat(storageFormat));
        ImmutableSet fileNames = ImmutableSet.copyOf(partitionUpdate.getFileNames());
        ImmutableList.Builder missingFileNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < bucketCount; ++i) {
            String fileName = transactionalCreateTable ? HiveWriterFactory.computeBucketedFileName(Optional.empty(), i) + fileExtension : HiveWriterFactory.computeBucketedFileName(Optional.of(session.getQueryId()), i) + fileExtension;
            if (fileNames.contains(fileName)) continue;
            missingFileNamesBuilder.add((Object)fileName);
        }
        ImmutableList missingFileNames = missingFileNamesBuilder.build();
        Verify.verify((fileNames.size() + missingFileNames.size() == bucketCount ? 1 : 0) != 0);
        return missingFileNames;
    }

    private void createEmptyFiles(ConnectorSession session, Path path, Table table, Optional<Partition> partition, List<String> fileNames) {
        StorageFormat format;
        Properties schema;
        JobConf conf = ConfigurationUtils.toJobConf(this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session), path));
        CompressionConfigUtil.configureCompression((Configuration)conf, HiveSessionProperties.getCompressionCodec(session));
        if (partition.isPresent()) {
            schema = MetastoreUtil.getHiveSchema(partition.get(), table);
            format = partition.get().getStorage().getStorageFormat();
        } else {
            schema = MetastoreUtil.getHiveSchema(table);
            format = table.getStorage().getStorageFormat();
        }
        this.hdfsEnvironment.doAs(session.getIdentity(), () -> {
            for (String fileName : fileNames) {
                HiveMetadata.writeEmptyFile(session, new Path(path, fileName), conf, schema, format.getSerDe(), format.getOutputFormat());
            }
        });
    }

    private static void writeEmptyFile(ConnectorSession session, Path target, JobConf conf, Properties properties, String serDe, String outputFormatName) {
        HiveWriteUtils.initializeSerializer((Configuration)conf, properties, serDe);
        FileSinkOperator.RecordWriter recordWriter = HiveWriteUtils.createRecordWriter(target, conf, properties, outputFormatName, session);
        try {
            recordWriter.close(false);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error write empty file to Hive", (Throwable)e);
        }
    }

    public ConnectorTableHandle beginUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        Set partitionColumnNames;
        HiveIdentity identity = new HiveIdentity(session);
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(identity, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        if (!AcidUtils.isFullAcidTable(table.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive update is only supported for ACID transactional tables");
        }
        Set updatedColumnNames = (Set)updatedColumns.stream().map(handle -> ((HiveColumnHandle)handle).getName()).collect(ImmutableSet.toImmutableSet());
        if (!Sets.intersection((Set)updatedColumnNames, (Set)(partitionColumnNames = (Set)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableSet.toImmutableSet()))).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Updating Hive table partition columns is not supported");
        }
        hiveTableHandle.getBucketHandle().ifPresent(handle -> {
            Set bucketColumnNames = (Set)handle.getColumns().stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
            if (!Sets.intersection((Set)updatedColumnNames, (Set)bucketColumnNames).isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Updating Hive table bucket columns is not supported");
            }
        });
        HiveWriteUtils.checkTableIsWritable(table, this.writesToNonManagedTablesEnabled);
        for (Column column : table.getDataColumns()) {
            if (HiveWriteUtils.isWritableType(column.getType())) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Updating a Hive table with column type %s not supported", column.getType()));
        }
        List<HiveColumnHandle> allDataColumns = HiveUtil.getRegularColumnHandles(table, this.typeManager, HiveSessionProperties.getTimestampPrecision(session)).stream().filter(columnHandle -> !columnHandle.isHidden()).collect(Collectors.toList());
        List hiveUpdatedColumns = (List)updatedColumns.stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        if (table.getParameters().containsKey(SKIP_HEADER_COUNT_KEY)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Updating a Hive table with %s property not supported", SKIP_HEADER_COUNT_KEY));
        }
        if (table.getParameters().containsKey(SKIP_FOOTER_COUNT_KEY)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Updating a Hive table with %s property not supported", SKIP_FOOTER_COUNT_KEY));
        }
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table);
        HiveUpdateProcessor updateProcessor = new HiveUpdateProcessor(allDataColumns, hiveUpdatedColumns);
        AcidTransaction transaction = this.metastore.beginUpdate(session, table, updateProcessor);
        HiveTableHandle updateHandle = hiveTableHandle.withTransaction(transaction);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), tableName);
        return updateHandle;
    }

    public void finishUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)handle.isAcidUpdate(), (String)"handle should be a update handle, but is %s", (Object)handle);
        Objects.requireNonNull(fragments, "fragments is null");
        SchemaTableName tableName = handle.getSchemaTableName();
        HiveIdentity identity = new HiveIdentity(session);
        Table table = this.metastore.getTable(identity, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        List<PartitionAndStatementId> partitionAndStatementIds = fragments.stream().map(Slice::getBytes).map(arg_0 -> PartitionAndStatementId.CODEC.fromJson(arg_0)).collect(Collectors.toList());
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
        for (PartitionAndStatementId ps : partitionAndStatementIds) {
            this.createOrcAcidVersionFile(context, new Path(ps.getDeleteDeltaDirectory()));
        }
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.finishUpdate(session, table.getDatabaseName(), table.getTableName(), writeInfo.getWritePath(), partitionAndStatementIds);
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveIdentity identity = new HiveIdentity(session);
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(identity, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        HiveWriteUtils.checkTableIsWritable(table, this.writesToNonManagedTablesEnabled);
        for (Column column : table.getDataColumns()) {
            if (HiveWriteUtils.isWritableType(column.getType())) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table %s with column type %s not supported", tableName, column.getType()));
        }
        List<HiveColumnHandle> handles = HiveUtil.hiveColumnHandles(table, this.typeManager, HiveSessionProperties.getTimestampPrecision(session)).stream().filter(columnHandle -> !columnHandle.isHidden()).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = HiveMetadata.extractHiveStorageFormat(table);
        Optional.ofNullable(table.getParameters().get(SKIP_HEADER_COUNT_KEY)).map(Integer::parseInt).ifPresent(headerSkipCount -> {
            if (headerSkipCount > 1) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table with value of %s property greater than 1 is not supported", SKIP_HEADER_COUNT_KEY));
            }
        });
        if (table.getParameters().containsKey(SKIP_FOOTER_COUNT_KEY)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table with %s property not supported", SKIP_FOOTER_COUNT_KEY));
        }
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table);
        AcidTransaction transaction = AcidUtils.isTransactionalTable(table.getParameters()) ? this.metastore.beginInsert(session, table) : AcidTransaction.NO_ACID_TRANSACTION;
        HiveInsertTableHandle result = new HiveInsertTableHandle(tableName.getSchemaName(), tableName.getTableName(), handles, this.metastore.generatePageSinkMetadata(identity, tableName), locationHandle, table.getStorage().getBucketProperty(), tableStorageFormat, HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session), transaction);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        if (HiveSessionProperties.getInsertExistingPartitionsBehavior(session) == HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE && AcidUtils.isTransactionalTable(table.getParameters()) && writeInfo.getWriteMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Overwriting existing partition in transactional tables doesn't support DIRECT_TO_TARGET_EXISTING_DIRECTORY write mode");
        }
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), tableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)insertHandle;
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = handle.getTableStorageFormat();
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        Table table = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (!table.getStorage().getStorageFormat().getInputFormat().equals(tableStorageFormat.getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
        }
        if (handle.getBucketProperty().isPresent() && HiveSessionProperties.isCreateEmptyBucketFiles(session)) {
            List<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table, false, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Object partition;
                Object object = partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                if (handle.isTransactional() && ((Optional)partition).isPresent()) {
                    PartitionStatistics statistics = PartitionStatistics.builder().setBasicStatistics(partitionUpdate.getStatistics()).build();
                    this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), (Partition)((Optional)partition).get(), partitionUpdate.getWritePath(), statistics);
                }
                this.createEmptyFiles(session, partitionUpdate.getWritePath(), table, (Optional<Partition>)partition, partitionUpdate.getFileNames());
            }
        }
        List partitionedBy = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map<List<String>, ComputedStatistics> partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, partitionedBy, columnTypes);
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            PartitionStatistics partitionStatistics;
            if (partitionUpdate.getName().isEmpty()) {
                if (!table.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
                }
                PartitionStatistics partitionStatistics2 = this.createPartitionStatistics(partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                    PrincipalPrivileges principalPrivileges = PrincipalPrivileges.fromHivePrivilegeInfos(this.metastore.listTablePrivileges(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName(), Optional.empty()));
                    this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
                    this.metastore.createTable(session, table, principalPrivileges, Optional.of(partitionUpdate.getWritePath()), false, partitionStatistics2);
                    continue;
                }
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                    this.metastore.finishInsertIntoExistingTable(session, handle.getSchemaName(), handle.getTableName(), partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics2);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported update mode: " + partitionUpdate.getUpdateMode());
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                List<String> partitionValues = HiveUtil.toPartitionValues(partitionUpdate.getName());
                partitionStatistics = this.createPartitionStatistics(partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partitionValues));
                this.metastore.finishInsertIntoExistingPartition(session, handle.getSchemaName(), handle.getTableName(), partitionValues, partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics);
                continue;
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                Partition partition = this.buildPartitionObject(session, table, partitionUpdate);
                if (!partition.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Partition format changed during insert");
                }
                partitionStatistics = this.createPartitionStatistics(partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partition.getValues()));
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                    if (handle.getLocationHandle().getWriteMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY) {
                        this.removeNonCurrentQueryFiles(session, partitionUpdate.getTargetPath());
                        continue;
                    }
                    this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), partition.getValues(), true);
                    this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition, partitionUpdate.getWritePath(), partitionStatistics);
                    continue;
                }
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition, partitionUpdate.getWritePath(), partitionStatistics);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported update mode: %s", new Object[]{partitionUpdate.getUpdateMode()}));
        }
        if (AcidUtils.isFullAcidTable(table.getParameters())) {
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
            for (PartitionUpdate update : partitionUpdates) {
                long writeId = handle.getTransaction().getWriteId();
                Path deltaDirectory = new Path(String.format("%s/%s/%s", table.getStorage().getLocation(), update.getName(), AcidUtils.deltaSubdir((long)writeId, (long)writeId, (int)0)));
                this.createOrcAcidVersionFile(context, deltaDirectory);
            }
        }
        return Optional.of(new HiveWrittenPartitions((List)partitionUpdates.stream().map(PartitionUpdate::getName).collect(ImmutableList.toImmutableList())));
    }

    private void removeNonCurrentQueryFiles(ConnectorSession session, Path partitionPath) {
        String queryId = session.getQueryId();
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), partitionPath);
            RemoteIterator iterator = fileSystem.listFiles(partitionPath, false);
            while (iterator.hasNext()) {
                Path file = ((LocatedFileStatus)iterator.next()).getPath();
                if (HiveWriteUtils.isFileCreatedByQuery(file.getName(), queryId)) continue;
                fileSystem.delete(file, false);
            }
        }
        catch (Exception ex) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, String.format("Failed to delete partition %s files during overwrite", partitionPath), (Throwable)ex);
        }
    }

    private void createOrcAcidVersionFile(HdfsEnvironment.HdfsContext context, Path deltaDirectory) {
        try {
            FileSystem fs = this.hdfsEnvironment.getFileSystem(context, deltaDirectory);
            AcidUtils.OrcAcidVersion.writeVersionFile((Path)deltaDirectory, (FileSystem)fs);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Exception writing _orc_acid_version file for deltaDirectory " + deltaDirectory, (Throwable)e);
        }
    }

    private Partition buildPartitionObject(ConnectorSession session, Table table, PartitionUpdate partitionUpdate) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionValues(partitionUpdate.getName())).setParameters((Map<String, String>)ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).build()).withStorage(storage -> storage.setStorageFormat(HiveSessionProperties.isRespectTableFormat(session) ? table.getStorage().getStorageFormat() : StorageFormat.fromHiveStorageFormat(HiveSessionProperties.getHiveStorageFormat(session))).setLocation(partitionUpdate.getTargetPath().toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private PartitionStatistics createPartitionStatistics(Map<String, Type> columnTypes, ComputedStatistics computedStatistics) {
        Map computedColumnStatistics = computedStatistics.getColumnStatistics();
        Block rowCountBlock = Optional.ofNullable((Block)computedStatistics.getTableStatistics().get(TableStatisticType.ROW_COUNT)).orElseThrow(() -> new VerifyException("rowCount not present"));
        Verify.verify((!rowCountBlock.isNull(0) ? 1 : 0) != 0, (String)"rowCount must never be null", (Object[])new Object[0]);
        long rowCount = BigintType.BIGINT.getLong(rowCountBlock, 0);
        HiveBasicStatistics rowCountOnlyBasicStatistics = new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(rowCount), OptionalLong.empty(), OptionalLong.empty());
        return this.createPartitionStatistics(rowCountOnlyBasicStatistics, columnTypes, computedColumnStatistics);
    }

    private PartitionStatistics createPartitionStatistics(HiveBasicStatistics basicStatistics, Map<String, Type> columnTypes, Map<ColumnStatisticMetadata, Block> computedColumnStatistics) {
        long rowCount = basicStatistics.getRowCount().orElseThrow(() -> new IllegalArgumentException("rowCount not present"));
        Map<String, HiveColumnStatistics> columnStatistics = Statistics.fromComputedStatistics(computedColumnStatistics, columnTypes, rowCount);
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    private static Map<ColumnStatisticMetadata, Block> getColumnStatistics(Map<List<String>, ComputedStatistics> statistics, List<String> partitionValues) {
        return Optional.ofNullable(statistics.get(partitionValues)).map(ComputedStatistics::getColumnStatistics).orElse((Map)ImmutableMap.of());
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        HiveIdentity identity = new HiveIdentity(session);
        ImmutableMap properties = ImmutableMap.builder().put((Object)TABLE_COMMENT, (Object)PRESTO_VIEW_COMMENT).put((Object)"presto_view", (Object)"true").put((Object)TRINO_CREATED_BY, (Object)"Trino Hive connector").put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).build();
        Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(session.getUser()).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List<Column>)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List<Column>)ImmutableList.of()).setParameters((Map<String, String>)properties).setViewOriginalText(Optional.of(ViewReaderUtil.encodeViewData(definition))).setViewExpandedText(Optional.of(PRESTO_VIEW_EXPANDED_TEXT_MARKER));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(session.getUser());
        Optional<Table> existing = this.metastore.getTable(identity, viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !ViewReaderUtil.isPrestoView(existing.get())) {
                throw new ViewAlreadyExistsException(viewName);
            }
            this.metastore.replaceTable(identity, viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), false, new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of()));
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.metastore.renameTable(new HiveIdentity(session), source.getSchemaName(), source.getTableName(), target.getSchemaName(), target.getTableName());
    }

    public void setViewAuthorization(ConnectorSession session, SchemaTableName viewName, TrinoPrincipal principal) {
        this.setTableAuthorization(session, viewName, principal);
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.getView(session, viewName).isEmpty()) {
            throw new ViewNotFoundException(viewName);
        }
        try {
            this.metastore.dropTable(session, viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> optionalSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllViews(schemaName)) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        Preconditions.checkState((!HiveUtil.isHiveSystemSchema(schemaName.getSchemaName()) ? 1 : 0) != 0, (String)"Schema is not accessible: %s", (Object)schemaName);
        Optional<Database> db = this.metastore.getDatabase(schemaName.getSchemaName());
        if (db.isPresent()) {
            return HiveSchemaProperties.fromDatabase(db.get());
        }
        throw new SchemaNotFoundException(schemaName.getSchemaName());
    }

    public Optional<TrinoPrincipal> getSchemaOwner(ConnectorSession session, CatalogSchemaName schemaName) {
        Preconditions.checkState((!HiveUtil.isHiveSystemSchema(schemaName.getSchemaName()) ? 1 : 0) != 0, (String)"Schema is not accessible: %s", (Object)schemaName);
        Optional<Database> database = this.metastore.getDatabase(schemaName.getSchemaName());
        if (database.isPresent()) {
            return database.flatMap(db -> Optional.of(new TrinoPrincipal(db.getOwnerType(), db.getOwnerName())));
        }
        throw new SchemaNotFoundException(schemaName.getSchemaName());
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        for (SchemaTableName name : this.listViews(session, schemaName)) {
            try {
                this.getView(session, name).ifPresent(view -> views.put((Object)name, view));
            }
            catch (TrinoException e) {
                if (e.getErrorCode().equals((Object)HiveErrorCode.HIVE_VIEW_TRANSLATION_ERROR.toErrorCode()) || e.getErrorCode().equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode())) continue;
                throw e;
            }
        }
        return views.build();
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        if (HiveUtil.isHiveSystemSchema(viewName.getSchemaName())) {
            return Optional.empty();
        }
        return this.metastore.getTable(new HiveIdentity(session), viewName.getSchemaName(), viewName.getTableName()).filter(ViewReaderUtil::canDecodeView).map(view -> {
            if (!this.translateHiveViews && !ViewReaderUtil.isPrestoView(view)) {
                throw new HiveViewNotSupportedException(viewName);
            }
            ConnectorViewDefinition definition = ViewReaderUtil.createViewReader(this.metastore, session, view, this.typeManager).decodeViewData(view.getViewOriginalText().get(), (Table)view, this.catalogName);
            if (view.getOwner() != null && !definition.isRunAsInvoker()) {
                definition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), definition.getComment(), Optional.of(view.getOwner()), false);
            }
            return definition;
        });
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = handle.getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        this.ensureTableSupportsDelete(table);
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table);
        AcidTransaction transaction = this.metastore.beginDelete(session, table);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), handle.getSchemaTableName());
        return handle.withTransaction(transaction);
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)handle.isAcidDelete(), (String)"handle should be a delete handle, but is %s", (Object)handle);
        Objects.requireNonNull(fragments, "fragments is null");
        SchemaTableName tableName = handle.getSchemaTableName();
        HiveIdentity identity = new HiveIdentity(session);
        Table table = this.metastore.getTable(identity, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        this.ensureTableSupportsDelete(table);
        List<PartitionAndStatementId> partitionAndStatementIds = fragments.stream().map(Slice::getBytes).map(arg_0 -> PartitionAndStatementId.CODEC.fromJson(arg_0)).collect(Collectors.toList());
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session);
        for (PartitionAndStatementId ps : partitionAndStatementIds) {
            this.createOrcAcidVersionFile(context, new Path(ps.getDeleteDeltaDirectory()));
        }
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.finishRowLevelDelete(session, table.getDatabaseName(), table.getTableName(), writeInfo.getWritePath(), partitionAndStatementIds);
    }

    private void ensureTableSupportsDelete(Table table) {
        if (table.getParameters().isEmpty() || !AcidUtils.isFullAcidTable(table.getParameters())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Deletes must match whole partitions for non-transactional tables");
        }
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return HiveColumnHandle.getDeleteRowIdColumnHandle();
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        HiveTableHandle table = (HiveTableHandle)tableHandle;
        return HiveColumnHandle.updateRowIdColumnHandle(table.getDataColumns(), updatedColumns);
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        Map<String, String> parameters = ((HiveTableHandle)handle).getTableParameters().orElseThrow(() -> new IllegalStateException("tableParameters missing from handle"));
        return AcidUtils.isFullAcidTable(parameters) ? Optional.empty() : Optional.of(handle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle deleteHandle) {
        HiveTableHandle handle = (HiveTableHandle)deleteHandle;
        Optional<Table> table = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName());
        if (table.isEmpty()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        if (table.get().getPartitionColumns().isEmpty()) {
            this.metastore.truncateUnpartitionedTable(session, handle.getSchemaName(), handle.getTableName());
        } else {
            for (HivePartition hivePartition : this.partitionManager.getOrLoadPartitions(this.metastore, new HiveIdentity(session), handle)) {
                this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), HiveUtil.toPartitionValues(hivePartition.getPartitionId()), true);
            }
        }
        return OptionalLong.empty();
    }

    @VisibleForTesting
    static Predicate<Map<ColumnHandle, NullableValue>> convertToPredicate(TupleDomain<ColumnHandle> tupleDomain) {
        return bindings -> tupleDomain.contains(TupleDomain.fromFixedValues((Map)bindings));
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        HiveTableHandle hiveTable = (HiveTableHandle)table;
        ImmutableList partitionColumns = ImmutableList.copyOf(hiveTable.getPartitionColumns());
        List<HivePartition> partitions = this.partitionManager.getOrLoadPartitions(this.metastore, new HiveIdentity(session), hiveTable);
        TupleDomain<ColumnHandle> predicate = HiveMetadata.createPredicate((List<ColumnHandle>)partitionColumns, partitions);
        Optional<Object> discretePredicates = Optional.empty();
        if (!partitionColumns.isEmpty()) {
            Iterable partitionDomains = Iterables.transform(partitions, hivePartition -> TupleDomain.fromFixedValues(hivePartition.getKeys()));
            discretePredicates = Optional.of(new DiscretePredicates((List)partitionColumns, partitionDomains));
        }
        Optional<Object> tablePartitioning = Optional.empty();
        Object sortingProperties = ImmutableList.of();
        if (hiveTable.getBucketHandle().isPresent()) {
            if (HiveSessionProperties.isPropagateTableScanSortingProperties(session) && !hiveTable.getBucketHandle().get().getSortedBy().isEmpty()) {
                Map<String, ColumnHandle> columnHandles = this.getColumnHandles(session, table);
                sortingProperties = (List)hiveTable.getBucketHandle().get().getSortedBy().stream().map(sortingColumn -> new SortingProperty((Object)((ColumnHandle)columnHandles.get(sortingColumn.getColumnName())), sortingColumn.getOrder().getSortOrder())).collect(ImmutableList.toImmutableList());
            }
            if (HiveSessionProperties.isBucketExecutionEnabled(session)) {
                tablePartitioning = hiveTable.getBucketHandle().map(bucketing -> new ConnectorTablePartitioning((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketing.getBucketingVersion(), bucketing.getReadBucketCount(), (List)bucketing.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), OptionalInt.empty(), false), (List)bucketing.getColumns().stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList())));
            }
        }
        return new ConnectorTableProperties(predicate, tablePartitioning, Optional.empty(), discretePredicates, (List)sortingProperties);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Preconditions.checkArgument((handle.getAnalyzePartitionValues().isEmpty() || constraint.getSummary().isAll() ? 1 : 0) != 0, (Object)"Analyze should not have a constraint");
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, new HiveIdentity(session), handle, constraint);
        HiveTableHandle newHandle = this.partitionManager.applyPartitionResult(handle, partitionResult, constraint.getPredicateColumns());
        if (handle.getPartitions().equals(newHandle.getPartitions()) && handle.getCompactEffectivePredicate().equals(newHandle.getCompactEffectivePredicate()) && handle.getBucketFilter().equals(newHandle.getBucketFilter()) && handle.getConstraintColumns().equals(newHandle.getConstraintColumns())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHandle, partitionResult.getUnenforcedConstraint(), false));
    }

    public void validateScan(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Optional<Set<ColumnHandle>> referencedColumns;
        List<HiveColumnHandle> partitionColumns;
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        if (HiveMetadata.isQueryPartitionFilterRequiredForTable(session, handle.getSchemaTableName()) && handle.getAnalyzePartitionValues().isEmpty() && handle.getEnforcedConstraint().isAll() && !(partitionColumns = handle.getPartitionColumns()).isEmpty() && ((referencedColumns = handle.getConstraintColumns()).isEmpty() || Collections.disjoint((Collection)referencedColumns.get(), partitionColumns))) {
            String partitionColumnNames = partitionColumns.stream().map(HiveColumnHandle::getName).collect(Collectors.joining(", "));
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Filter required on %s.%s for at least one partition column: %s", handle.getSchemaName(), handle.getTableName(), partitionColumnNames));
        }
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        if (!HiveSessionProperties.isProjectionPushdownEnabled(session)) {
            return Optional.empty();
        }
        Set projectedExpressions = (Set)projections.stream().flatMap(expression -> HiveApplyProjectionUtil.extractSupportedProjectedColumns(expression).stream()).collect(ImmutableSet.toImmutableSet());
        Map columnProjections = (Map)projectedExpressions.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), HiveApplyProjectionUtil::createProjectedColumnRepresentation));
        HiveTableHandle hiveTableHandle = (HiveTableHandle)handle;
        if (columnProjections.values().stream().allMatch(HiveApplyProjectionUtil.ProjectedColumnRepresentation::isVariable)) {
            ImmutableSet projectedColumns = ImmutableSet.copyOf(assignments.values());
            if (hiveTableHandle.getProjectedColumns().isPresent() && hiveTableHandle.getProjectedColumns().get().equals(projectedColumns)) {
                return Optional.empty();
            }
            List assignmentsList = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((HiveColumnHandle)assignment.getValue()).getType())).collect(ImmutableList.toImmutableList());
            return Optional.of(new ProjectionApplicationResult((Object)hiveTableHandle.withProjectedColumns((Set<ColumnHandle>)projectedColumns), projections, assignmentsList, false));
        }
        HashMap<String, Assignment> newAssignments = new HashMap<String, Assignment>();
        ImmutableMap.Builder newVariablesBuilder = ImmutableMap.builder();
        ImmutableSet.Builder projectedColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry entry : columnProjections.entrySet()) {
            ColumnHandle projectedColumnHandle;
            String projectedColumnName;
            ConnectorExpression expression2 = (ConnectorExpression)entry.getKey();
            HiveApplyProjectionUtil.ProjectedColumnRepresentation projectedColumn = (HiveApplyProjectionUtil.ProjectedColumnRepresentation)entry.getValue();
            Optional<String> existingColumn = HiveApplyProjectionUtil.find(assignments, projectedColumn);
            if (existingColumn.isPresent()) {
                projectedColumnName = existingColumn.get();
                projectedColumnHandle = assignments.get(projectedColumnName);
            } else {
                HiveColumnHandle oldColumnHandle = (HiveColumnHandle)assignments.get(projectedColumn.getVariable().getName());
                projectedColumnHandle = this.createProjectedColumnHandle(oldColumnHandle, projectedColumn.getDereferenceIndices());
                projectedColumnName = ((HiveColumnHandle)projectedColumnHandle).getName();
            }
            Variable projectedColumnVariable = new Variable(projectedColumnName, expression2.getType());
            Assignment newAssignment = new Assignment(projectedColumnName, projectedColumnHandle, expression2.getType());
            newAssignments.put(projectedColumnName, newAssignment);
            newVariablesBuilder.put((Object)expression2, (Object)projectedColumnVariable);
            projectedColumnsBuilder.add((Object)projectedColumnHandle);
        }
        ImmutableMap newVariables = newVariablesBuilder.build();
        List newProjections = (List)projections.stream().map(arg_0 -> HiveMetadata.lambda$applyProjection$69((Map)newVariables, arg_0)).collect(ImmutableList.toImmutableList());
        List outputAssignments = (List)newAssignments.values().stream().collect(ImmutableList.toImmutableList());
        return Optional.of(new ProjectionApplicationResult((Object)hiveTableHandle.withProjectedColumns((Set<ColumnHandle>)projectedColumnsBuilder.build()), newProjections, outputAssignments, false));
    }

    private HiveColumnHandle createProjectedColumnHandle(HiveColumnHandle column, List<Integer> indices) {
        HiveType oldHiveType = column.getHiveType();
        HiveType newHiveType = oldHiveType.getHiveTypeForDereferences(indices).get();
        HiveColumnProjectionInfo columnProjectionInfo = new HiveColumnProjectionInfo((List<Integer>)ImmutableList.builder().addAll((Iterable)column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceIndices).orElse((List)ImmutableList.of())).addAll(indices).build(), (List<String>)ImmutableList.builder().addAll((Iterable)column.getHiveColumnProjectionInfo().map(HiveColumnProjectionInfo::getDereferenceNames).orElse((List)ImmutableList.of())).addAll(oldHiveType.getHiveDereferenceNames(indices)).build(), newHiveType, newHiveType.getType(this.typeManager));
        return new HiveColumnHandle(column.getBaseColumnName(), column.getBaseHiveColumnIndex(), column.getBaseHiveType(), column.getBaseType(), Optional.of(columnProjectionInfo), column.getColumnType(), column.getComment());
    }

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.hiveRedirectionsProvider.getTableScanRedirection(session, (HiveTableHandle)tableHandle);
    }

    public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        int smallerBucketCount;
        HivePartitioningHandle leftHandle = (HivePartitioningHandle)left;
        HivePartitioningHandle rightHandle = (HivePartitioningHandle)right;
        if (leftHandle.isUsePartitionedBucketing() != rightHandle.isUsePartitionedBucketing()) {
            return Optional.empty();
        }
        if (!leftHandle.getHiveTypes().equals(rightHandle.getHiveTypes())) {
            return Optional.empty();
        }
        if (leftHandle.getBucketingVersion() != rightHandle.getBucketingVersion()) {
            return Optional.empty();
        }
        if (leftHandle.getBucketCount() == rightHandle.getBucketCount()) {
            return Optional.of(leftHandle);
        }
        if (!HiveSessionProperties.isOptimizedMismatchedBucketCount(session)) {
            return Optional.empty();
        }
        int largerBucketCount = Math.max(leftHandle.getBucketCount(), rightHandle.getBucketCount());
        if (largerBucketCount % (smallerBucketCount = Math.min(leftHandle.getBucketCount(), rightHandle.getBucketCount())) != 0) {
            return Optional.empty();
        }
        if (Integer.bitCount(largerBucketCount / smallerBucketCount) != 1) {
            return Optional.empty();
        }
        OptionalInt maxCompatibleBucketCount = HiveMetadata.min(leftHandle.getMaxCompatibleBucketCount(), rightHandle.getMaxCompatibleBucketCount());
        if (maxCompatibleBucketCount.isPresent() && maxCompatibleBucketCount.getAsInt() < smallerBucketCount) {
            return Optional.empty();
        }
        return Optional.of(new HivePartitioningHandle(leftHandle.getBucketingVersion(), smallerBucketCount, leftHandle.getHiveTypes(), maxCompatibleBucketCount, false));
    }

    private static OptionalInt min(OptionalInt left, OptionalInt right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        return OptionalInt.of(Math.min(left.getAsInt(), right.getAsInt()));
    }

    public ConnectorTableHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorPartitioningHandle partitioningHandle) {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        HivePartitioningHandle hivePartitioningHandle = (HivePartitioningHandle)partitioningHandle;
        Preconditions.checkArgument((boolean)hiveTable.getBucketHandle().isPresent(), (Object)"Hive connector only provides alternative layout for bucketed table");
        HiveBucketHandle bucketHandle = hiveTable.getBucketHandle().get();
        ImmutableList bucketTypes = (ImmutableList)bucketHandle.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)hivePartitioningHandle.getHiveTypes().equals(bucketTypes), (String)"Types from the new PartitioningHandle (%s) does not match the TableHandle (%s)", hivePartitioningHandle.getHiveTypes(), (Object)bucketTypes);
        int largerBucketCount = Math.max(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        int smallerBucketCount = Math.min(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        Preconditions.checkArgument((largerBucketCount % smallerBucketCount == 0 && Integer.bitCount(largerBucketCount / smallerBucketCount) == 1 ? 1 : 0) != 0, (Object)"The requested partitioning is not a valid alternative for the table layout");
        return new HiveTableHandle(hiveTable.getSchemaName(), hiveTable.getTableName(), hiveTable.getTableParameters(), hiveTable.getPartitionColumns(), hiveTable.getDataColumns(), hiveTable.getPartitions(), hiveTable.getCompactEffectivePredicate(), hiveTable.getEnforcedConstraint(), Optional.of(new HiveBucketHandle(bucketHandle.getColumns(), bucketHandle.getBucketingVersion(), bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount(), bucketHandle.getSortedBy())), hiveTable.getBucketFilter(), hiveTable.getAnalyzePartitionValues(), hiveTable.getAnalyzeColumnNames(), Optional.empty(), Optional.empty(), hiveTable.getTransaction());
    }

    @VisibleForTesting
    static TupleDomain<ColumnHandle> createPredicate(List<ColumnHandle> partitionColumns, List<HivePartition> partitions) {
        if (partitions.isEmpty()) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(partitionColumns.stream().collect(Collectors.toMap(Function.identity(), column -> HiveMetadata.buildColumnDomain(column, partitions))));
    }

    private static Domain buildColumnDomain(ColumnHandle column, List<HivePartition> partitions) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"partitions cannot be empty");
        boolean hasNull = false;
        boolean hasNaN = false;
        ArrayList<Object> nonNullValues = new ArrayList<Object>();
        Type type = ((HiveColumnHandle)column).getType();
        for (HivePartition partition : partitions) {
            NullableValue value = partition.getKeys().get(column);
            if (value == null) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, String.format("Partition %s does not have a value for partition column %s", partition, column));
            }
            if (value.isNull()) {
                hasNull = true;
                continue;
            }
            if (TypeUtils.isFloatingPointNaN((Type)type, (Object)value.getValue())) {
                hasNaN = true;
            }
            nonNullValues.add(value.getValue());
        }
        Domain domain = nonNullValues.isEmpty() ? Domain.none((Type)type) : (hasNaN ? Domain.notNull((Type)type) : Domain.multipleValues((Type)type, nonNullValues));
        if (hasNull) {
            domain = domain.union(Domain.onlyNull((Type)type));
        }
        return domain;
    }

    public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        if (table.getStorage().getBucketProperty().isPresent()) {
            if (!HiveBucketing.isSupportedBucketing(table)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write to a table bucketed on an unsupported type");
            }
        } else if (AcidUtils.isFullAcidTable(table.getParameters())) {
            table = Table.builder(table).withStorage(storage -> storage.setBucketProperty(Optional.of(new HiveBucketProperty((List<String>)ImmutableList.of(), HiveBucketing.BucketingVersion.BUCKETING_V2, 1, (List<SortingColumn>)ImmutableList.of())))).build();
        }
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(session, table, this.typeManager);
        List<Column> partitionColumns = table.getPartitionColumns();
        if (hiveBucketHandle.isEmpty()) {
            if (partitionColumns.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new ConnectorNewTableLayout((List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList())));
        }
        HiveBucketProperty bucketProperty = table.getStorage().getBucketProperty().orElseThrow(() -> new NoSuchElementException("Bucket property should be set"));
        if (!bucketProperty.getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        ImmutableList.Builder partitioningColumns = ImmutableList.builder();
        hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getName).forEach(arg_0 -> ((ImmutableList.Builder)partitioningColumns).add(arg_0));
        partitionColumns.stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)partitioningColumns).add(arg_0));
        HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(hiveBucketHandle.get().getBucketingVersion(), hiveBucketHandle.get().getTableBucketCount(), hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getHiveType).collect(Collectors.toList()), OptionalInt.of(hiveBucketHandle.get().getTableBucketCount()), !partitionColumns.isEmpty() && HiveSessionProperties.isParallelPartitionedBucketedWrites(session));
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioningHandle, (List)partitioningColumns.build()));
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        HiveMetadata.validateTimestampColumns(tableMetadata.getColumns(), HiveSessionProperties.getTimestampPrecision(session));
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        HiveMetadata.validateColumns(tableMetadata);
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        if (bucketProperty.isEmpty()) {
            if (partitionedBy.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new ConnectorNewTableLayout(partitionedBy));
        }
        if (!bucketProperty.get().getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        List dataColumn = (List)HiveMetadata.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy)).stream().map(HiveColumnHandle::toMetastoreColumn).collect(ImmutableList.toImmutableList());
        if (!HiveBucketing.isSupportedBucketing(bucketProperty.get(), dataColumn, tableMetadata.getTable().getTableName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write to a table bucketed on an unsupported type");
        }
        List<String> bucketedBy = bucketProperty.get().getBucketedBy();
        Map<String, HiveType> hiveTypeMap = tableMetadata.getColumns().stream().collect(Collectors.toMap(ColumnMetadata::getName, column -> HiveType.toHiveType(column.getType())));
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketProperty.get().getBucketingVersion(), bucketProperty.get().getBucketCount(), (List)bucketedBy.stream().map(hiveTypeMap::get).collect(ImmutableList.toImmutableList()), OptionalInt.of(bucketProperty.get().getBucketCount()), !partitionedBy.isEmpty() && HiveSessionProperties.isParallelPartitionedBucketedWrites(session)), (List)ImmutableList.builder().addAll(bucketedBy).addAll(partitionedBy).build()));
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        if (!HiveSessionProperties.isCollectColumnStatisticsOnWrite(session)) {
            return TableStatisticsMetadata.empty();
        }
        if (HiveTableProperties.isTransactional(tableMetadata.getProperties()).orElse(false).booleanValue()) {
            return TableStatisticsMetadata.empty();
        }
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        return this.getStatisticsCollectionMetadata(tableMetadata.getColumns(), partitionedBy, Optional.empty(), false);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        return this.getStatisticsCollectionMetadata(tableMetadata.getColumns(), partitionedBy, HiveTableProperties.getAnalyzeColumns(tableMetadata.getProperties()), true);
    }

    private TableStatisticsMetadata getStatisticsCollectionMetadata(List<ColumnMetadata> columns, List<String> partitionedBy, Optional<Set<String>> analyzeColumns, boolean includeRowCount) {
        Set columnStatistics = (Set)columns.stream().filter(column -> !partitionedBy.contains(column.getName())).filter(column -> !column.isHidden()).filter(column -> analyzeColumns.isEmpty() || ((Set)analyzeColumns.get()).contains(column.getName())).map(this::getColumnStatisticMetadata).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        ImmutableSet tableStatistics = includeRowCount ? ImmutableSet.of((Object)TableStatisticType.ROW_COUNT) : ImmutableSet.of();
        return new TableStatisticsMetadata(columnStatistics, (Set)tableStatistics, partitionedBy);
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(ColumnMetadata columnMetadata) {
        return this.getColumnStatisticMetadata(columnMetadata.getName(), this.metastore.getSupportedColumnStatistics(columnMetadata.getType()));
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(String columnName, Set<ColumnStatisticType> statisticTypes) {
        return (List)statisticTypes.stream().map(type -> new ColumnStatisticMetadata(columnName, type)).collect(ImmutableList.toImmutableList());
    }

    public boolean roleExists(ConnectorSession session, String role) {
        return this.accessControlMetadata.roleExists(session, role);
    }

    public void createRole(ConnectorSession session, String role, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.createRole(session, role, grantor.map(HivePrincipal::from));
    }

    public void dropRole(ConnectorSession session, String role) {
        this.accessControlMetadata.dropRole(session, role);
    }

    public Set<String> listRoles(ConnectorSession session) {
        return this.accessControlMetadata.listRoles(session);
    }

    public Set<RoleGrant> listAllRoleGrants(ConnectorSession session, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
        return ImmutableSet.copyOf(this.accessControlMetadata.listAllRoleGrants(session, roles, grantees, limit));
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, TrinoPrincipal principal) {
        return ImmutableSet.copyOf(this.accessControlMetadata.listRoleGrants(session, HivePrincipal.from(principal)));
    }

    public void grantRoles(ConnectorSession session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.grantRoles(session, roles, HivePrincipal.from(grantees), adminOption, grantor.map(HivePrincipal::from));
    }

    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.revokeRoles(session, roles, HivePrincipal.from(grantees), adminOption, grantor.map(HivePrincipal::from));
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, TrinoPrincipal principal) {
        return this.accessControlMetadata.listApplicableRoles(session, HivePrincipal.from(principal));
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        return this.accessControlMetadata.listEnabledRoles(session);
    }

    public void grantSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.grantSchemaPrivileges(session, schemaName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public void revokeSchemaPrivileges(ConnectorSession session, String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.revokeSchemaPrivileges(session, schemaName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.grantTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.revokeTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
        return this.accessControlMetadata.listTablePrivileges(session, this.listTables(session, schemaTablePrefix));
    }

    private static HiveStorageFormat extractHiveStorageFormat(Table table) {
        StorageFormat storageFormat = table.getStorage().getStorageFormat();
        String outputFormat = storageFormat.getOutputFormat();
        String serde = storageFormat.getSerDe();
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.getOutputFormat().equals(outputFormat) || !format.getSerDe().equals(serde)) continue;
            return format;
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Output format %s with SerDe %s is not supported", outputFormat, serde));
    }

    private static void validateBucketColumns(ConnectorTableMetadata tableMetadata) {
        List<String> bucketedBy;
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (bucketProperty.isEmpty()) {
            return;
        }
        Set allColumns = (Set)tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        if (!allColumns.containsAll(bucketedBy = bucketProperty.get().getBucketedBy())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(bucketedBy), (Set)allColumns)));
        }
        ImmutableSet partitionColumns = ImmutableSet.copyOf(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        if (bucketedBy.stream().anyMatch(((Set)partitionColumns)::contains)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s are also used as partitioning columns", Sets.intersection((Set)ImmutableSet.copyOf(bucketedBy), (Set)partitionColumns)));
        }
        List sortedBy = (List)bucketProperty.get().getSortedBy().stream().map(SortingColumn::getColumnName).collect(ImmutableList.toImmutableList());
        if (!allColumns.containsAll(sortedBy)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Sorting columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf((Collection)sortedBy), (Set)allColumns)));
        }
        if (sortedBy.stream().anyMatch(((Set)partitionColumns)::contains)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Sorting columns %s are also used as partitioning columns", Sets.intersection((Set)ImmutableSet.copyOf((Collection)sortedBy), (Set)partitionColumns)));
        }
    }

    private static void validatePartitionColumns(ConnectorTableMetadata tableMetadata) {
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        List allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        if (!allColumns.containsAll(partitionedBy)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Partition columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(partitionedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        if (allColumns.size() == partitionedBy.size()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Table contains only partition columns");
        }
        if (!allColumns.subList(allColumns.size() - partitionedBy.size(), allColumns.size()).equals(partitionedBy)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_COLUMN_ORDER_MISMATCH, "Partition keys must be the last columns in the table and in the same order as the table properties: " + partitionedBy);
        }
    }

    private static List<HiveColumnHandle> getColumnHandles(ConnectorTableMetadata tableMetadata, Set<String> partitionColumnNames) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        HiveMetadata.validateBucketColumns(tableMetadata);
        HiveMetadata.validateColumns(tableMetadata);
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int ordinal = 0;
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            HiveColumnHandle.ColumnType columnType = partitionColumnNames.contains(column.getName()) ? HiveColumnHandle.ColumnType.PARTITION_KEY : (column.isHidden() ? HiveColumnHandle.ColumnType.SYNTHESIZED : HiveColumnHandle.ColumnType.REGULAR);
            columnHandles.add((Object)HiveColumnHandle.createBaseColumn(column.getName(), ordinal, HiveType.toHiveType(column.getType()), column.getType(), columnType, Optional.ofNullable(column.getComment())));
            ++ordinal;
        }
        return columnHandles.build();
    }

    private static void validateColumns(ConnectorTableMetadata tableMetadata) {
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            String columnName = column.getName();
            if (columnName.startsWith(" ")) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Hive column names must not start with a space: '%s'", columnName));
            }
            if (columnName.endsWith(" ")) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Hive column names must not end with a space: '%s'", columnName));
            }
            if (columnName.contains(",")) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Hive column names must not contain commas: '%s'", columnName));
            }
            HiveType.toHiveType(column.getType());
        }
        if (HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties()) != HiveStorageFormat.CSV) {
            return;
        }
        ImmutableSet partitionedBy = ImmutableSet.copyOf(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        List unsupportedColumns = (List)tableMetadata.getColumns().stream().filter(arg_0 -> HiveMetadata.lambda$validateColumns$79((Set)partitionedBy, arg_0)).filter(columnMetadata -> !columnMetadata.getType().equals(VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList());
        if (!unsupportedColumns.isEmpty()) {
            String joinedUnsupportedColumns = unsupportedColumns.stream().map(columnMetadata -> String.format("%s %s", columnMetadata.getName(), columnMetadata.getType())).collect(Collectors.joining(", "));
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive CSV storage format only supports VARCHAR (unbounded). Unsupported columns: " + joinedUnsupportedColumns);
        }
    }

    private static void validateTimestampColumns(List<ColumnMetadata> columns, HiveTimestampPrecision precision) {
        for (ColumnMetadata column : columns) {
            HiveMetadata.validateTimestampTypes(column.getType(), precision);
        }
    }

    private static void validateTimestampTypes(Type type, HiveTimestampPrecision precision) {
        if (type instanceof TimestampType) {
            if (((TimestampType)type).getPrecision() != precision.getPrecision()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Incorrect timestamp precision for %s; the configured precision is %s", new Object[]{type, precision}));
            }
        } else if (type instanceof ArrayType) {
            HiveMetadata.validateTimestampTypes(((ArrayType)type).getElementType(), precision);
        } else if (type instanceof MapType) {
            HiveMetadata.validateTimestampTypes(((MapType)type).getKeyType(), precision);
            HiveMetadata.validateTimestampTypes(((MapType)type).getValueType(), precision);
        } else if (type instanceof RowType) {
            for (Type fieldType : ((RowType)type).getTypeParameters()) {
                HiveMetadata.validateTimestampTypes(fieldType, precision);
            }
        }
    }

    private static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table) {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        table.getPartitionColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        table.getDataColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        ImmutableList allColumnNames = columnNames.build();
        if (allColumnNames.size() > Sets.newHashSet((Iterable)allColumnNames).size()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Hive metadata for table %s is invalid: Table descriptor contains duplicate columns", table.getTableName()));
        }
        List<Column> tableColumns = table.getDataColumns();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Column field : Iterables.concat(tableColumns, table.getPartitionColumns())) {
            if (field.getComment().isPresent() && !field.getComment().get().equals("from deserializer")) {
                builder.put((Object)field.getName(), field.getComment());
                continue;
            }
            builder.put((Object)field.getName(), Optional.empty());
        }
        builder.put((Object)"$path", Optional.empty());
        if (table.getStorage().getBucketProperty().isPresent()) {
            builder.put((Object)"$bucket", Optional.empty());
        }
        builder.put((Object)"$file_size", Optional.empty());
        builder.put((Object)"$file_modified_time", Optional.empty());
        if (!table.getPartitionColumns().isEmpty()) {
            builder.put((Object)"$partition", Optional.empty());
        }
        if (AcidUtils.isFullAcidTable(table.getParameters())) {
            for (String name : AcidSchema.ACID_COLUMN_NAMES) {
                builder.put((Object)name, Optional.empty());
            }
        }
        ImmutableMap columnComment = builder.build();
        return arg_0 -> HiveMetadata.lambda$columnMetadataGetter$82((Map)columnComment, arg_0);
    }

    @Override
    public void rollback() {
        this.metastore.rollback();
    }

    @Override
    public void commit() {
        if (!this.metastore.isFinished()) {
            this.metastore.commit();
        }
    }

    public void beginQuery(ConnectorSession session) {
        this.metastore.beginQuery(session);
    }

    public void cleanupQuery(ConnectorSession session) {
        this.metastore.cleanupQuery(session);
    }

    public void createMaterializedView(ConnectorSession session, SchemaTableName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        this.hiveMaterializedViewMetadata.createMaterializedView(session, viewName, definition, replace, ignoreExisting);
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        this.hiveMaterializedViewMetadata.dropMaterializedView(session, viewName);
    }

    public List<SchemaTableName> listMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        return this.hiveMaterializedViewMetadata.listMaterializedViews(session, schemaName);
    }

    public Map<SchemaTableName, ConnectorMaterializedViewDefinition> getMaterializedViews(ConnectorSession session, Optional<String> schemaName) {
        return this.hiveMaterializedViewMetadata.getMaterializedViews(session, schemaName);
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return this.hiveMaterializedViewMetadata.getMaterializedView(session, viewName);
    }

    public MaterializedViewFreshness getMaterializedViewFreshness(ConnectorSession session, SchemaTableName name) {
        return this.hiveMaterializedViewMetadata.getMaterializedViewFreshness(session, name);
    }

    public boolean delegateMaterializedViewRefreshToConnector(ConnectorSession session, SchemaTableName viewName) {
        return this.hiveMaterializedViewMetadata.delegateMaterializedViewRefreshToConnector(session, viewName);
    }

    public CompletableFuture<?> refreshMaterializedView(ConnectorSession session, SchemaTableName name) {
        return this.hiveMaterializedViewMetadata.refreshMaterializedView(session, name);
    }

    @SafeVarargs
    private static <T> Optional<T> firstNonNullable(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static boolean isQueryPartitionFilterRequiredForTable(ConnectorSession session, SchemaTableName schemaTableName) {
        Set<String> requiredSchemas = HiveSessionProperties.getQueryPartitionFilterRequiredSchemas(session);
        return HiveSessionProperties.isQueryPartitionFilterRequired(session) && requiredSchemas.isEmpty() || requiredSchemas.contains(schemaTableName.getSchemaName());
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$82(Map columnComment, HiveColumnHandle handle) {
        return ColumnMetadata.builder().setName(handle.getName()).setType(handle.getType()).setComment((Optional)columnComment.get(handle.getName())).setExtraInfo(Optional.ofNullable(HiveUtil.columnExtraInfo(handle.isPartitionKey()))).setHidden(handle.isHidden()).build();
    }

    private static /* synthetic */ boolean lambda$validateColumns$79(Set partitionedBy, ColumnMetadata columnMetadata) {
        return !partitionedBy.contains(columnMetadata.getName());
    }

    private static /* synthetic */ ConnectorExpression lambda$applyProjection$69(Map newVariables, ConnectorExpression expression) {
        return HiveApplyProjectionUtil.replaceWithNewVariables(expression, newVariables);
    }

    private static /* synthetic */ void lambda$getEmptyTableProperties$23(HiveStorageFormat hiveStorageFormat, Set allowsNullFormat, ImmutableMap.Builder tableProperties, String format) {
        HiveMetadata.checkFormatForProperty(hiveStorageFormat, allowsNullFormat, "null_format");
        tableProperties.put((Object)NULL_FORMAT_KEY, (Object)format);
    }

    private static /* synthetic */ void lambda$getEmptyTableProperties$22(HiveStorageFormat hiveStorageFormat, Set csvAndTextFile, ImmutableMap.Builder tableProperties, Integer footerSkipCount) {
        if (footerSkipCount > 0) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, csvAndTextFile, "skip_footer_line_count");
            tableProperties.put((Object)SKIP_FOOTER_COUNT_KEY, (Object)String.valueOf(footerSkipCount));
        }
        if (footerSkipCount < 0) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", "skip_footer_line_count", footerSkipCount));
        }
    }

    private static /* synthetic */ void lambda$getEmptyTableProperties$21(HiveStorageFormat hiveStorageFormat, Set csvAndTextFile, ImmutableMap.Builder tableProperties, Integer headerSkipCount) {
        if (headerSkipCount > 0) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, csvAndTextFile, "skip_header_line_count");
            tableProperties.put((Object)SKIP_HEADER_COUNT_KEY, (Object)String.valueOf(headerSkipCount));
        }
        if (headerSkipCount < 0) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", "skip_header_line_count", headerSkipCount));
        }
    }
}

