/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class HdfsConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private List<File> resourceConfigFiles = ImmutableList.of();
    private String newDirectoryPermissions = "0777";
    private boolean newFileInheritOwnership;
    private boolean verifyChecksum = true;
    private Duration ipcPingInterval = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsTimeout = new Duration(60.0, TimeUnit.SECONDS);
    private Duration dfsConnectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private int dfsConnectMaxRetries = 5;
    private Duration dfsKeyProviderCacheTtl = new Duration(30.0, TimeUnit.MINUTES);
    private String domainSocketPath;
    private HostAndPort socksProxy;
    private boolean wireEncryptionEnabled;
    private int fileSystemMaxCacheSize = 1000;
    private Integer dfsReplication;

    public @NotNull List<@FileExists File> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Config(value="hive.config.resources")
    public HdfsConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = (List)SPLITTER.splitToList((CharSequence)files).stream().map(File::new).collect(ImmutableList.toImmutableList());
        return this;
    }

    public HdfsConfig setResourceConfigFiles(List<File> files) {
        this.resourceConfigFiles = ImmutableList.copyOf(files);
        return this;
    }

    @NotNull
    @Pattern(regexp="0[0-7]{3}", message="must be octal number, with leading 0")
    public @NotNull @Pattern(regexp="0[0-7]{3}", message="must be octal number, with leading 0") String getNewDirectoryPermissions() {
        return this.newDirectoryPermissions;
    }

    @Config(value="hive.fs.new-directory-permissions")
    @ConfigDescription(value="File system permissions for new directories")
    public HdfsConfig setNewDirectoryPermissions(String newDirectoryPermissions) {
        this.newDirectoryPermissions = Objects.requireNonNull(newDirectoryPermissions, "newDirectoryPermissions is null");
        return this;
    }

    public boolean isNewFileInheritOwnership() {
        return this.newFileInheritOwnership;
    }

    @Config(value="hive.fs.new-file-inherit-ownership")
    @ConfigDescription(value="File system permissions for new directories")
    public HdfsConfig setNewFileInheritOwnership(boolean newFileInheritOwnership) {
        this.newFileInheritOwnership = newFileInheritOwnership;
        return this;
    }

    public boolean isVerifyChecksum() {
        return this.verifyChecksum;
    }

    @Config(value="hive.dfs.verify-checksum")
    public HdfsConfig setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public @NotNull @MinDuration(value="1ms") Duration getIpcPingInterval() {
        return this.ipcPingInterval;
    }

    @Config(value="hive.dfs.ipc-ping-interval")
    public HdfsConfig setIpcPingInterval(Duration pingInterval) {
        this.ipcPingInterval = pingInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public @NotNull @MinDuration(value="1ms") Duration getDfsTimeout() {
        return this.dfsTimeout;
    }

    @Config(value="hive.dfs-timeout")
    public HdfsConfig setDfsTimeout(Duration dfsTimeout) {
        this.dfsTimeout = dfsTimeout;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getDfsConnectTimeout() {
        return this.dfsConnectTimeout;
    }

    @Config(value="hive.dfs.connect.timeout")
    public HdfsConfig setDfsConnectTimeout(Duration dfsConnectTimeout) {
        this.dfsConnectTimeout = dfsConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getDfsConnectMaxRetries() {
        return this.dfsConnectMaxRetries;
    }

    @Config(value="hive.dfs.connect.max-retries")
    public HdfsConfig setDfsConnectMaxRetries(int dfsConnectMaxRetries) {
        this.dfsConnectMaxRetries = dfsConnectMaxRetries;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getDfsKeyProviderCacheTtl() {
        return this.dfsKeyProviderCacheTtl;
    }

    @Config(value="hive.dfs.key-provider.cache-ttl")
    public HdfsConfig setDfsKeyProviderCacheTtl(Duration dfsClientKeyProviderCacheTtl) {
        this.dfsKeyProviderCacheTtl = dfsClientKeyProviderCacheTtl;
        return this;
    }

    public String getDomainSocketPath() {
        return this.domainSocketPath;
    }

    @Config(value="hive.dfs.domain-socket-path")
    public HdfsConfig setDomainSocketPath(String domainSocketPath) {
        this.domainSocketPath = domainSocketPath;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="hive.hdfs.socks-proxy")
    public HdfsConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    public boolean isWireEncryptionEnabled() {
        return this.wireEncryptionEnabled;
    }

    @Config(value="hive.hdfs.wire-encryption.enabled")
    @ConfigDescription(value="Should be turned on when HDFS wire encryption is enabled")
    public HdfsConfig setWireEncryptionEnabled(boolean wireEncryptionEnabled) {
        this.wireEncryptionEnabled = wireEncryptionEnabled;
        return this;
    }

    public int getFileSystemMaxCacheSize() {
        return this.fileSystemMaxCacheSize;
    }

    @Config(value="hive.fs.cache.max-size")
    @ConfigDescription(value="Hadoop FileSystem cache size")
    public HdfsConfig setFileSystemMaxCacheSize(int fileSystemMaxCacheSize) {
        this.fileSystemMaxCacheSize = fileSystemMaxCacheSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getDfsReplication() {
        return this.dfsReplication;
    }

    @Config(value="hive.dfs.replication")
    @ConfigDescription(value="Hadoop FileSystem replication factor")
    public HdfsConfig setDfsReplication(Integer dfsReplication) {
        this.dfsReplication = dfsReplication;
        return this;
    }
}

