/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class AcidInfo {
    private final String partitionLocation;
    private final List<DeleteDeltaInfo> deleteDeltas;
    private final List<OriginalFileInfo> originalFiles;
    private final int bucketId;
    private final boolean orcAcidVersionValidated;

    @JsonCreator
    public AcidInfo(@JsonProperty(value="partitionLocation") String partitionLocation, @JsonProperty(value="deleteDeltas") List<DeleteDeltaInfo> deleteDeltas, @JsonProperty(value="originalFiles") List<OriginalFileInfo> originalFiles, @JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="orcAcidVersionValidated") boolean orcAcidVersionValidated) {
        this.partitionLocation = Objects.requireNonNull(partitionLocation, "partitionLocation is null");
        this.deleteDeltas = ImmutableList.copyOf((Collection)Objects.requireNonNull(deleteDeltas, "deleteDeltas is null"));
        this.originalFiles = ImmutableList.copyOf((Collection)Objects.requireNonNull(originalFiles, "originalFiles is null"));
        this.bucketId = bucketId;
        this.orcAcidVersionValidated = orcAcidVersionValidated;
    }

    @JsonProperty
    public List<OriginalFileInfo> getOriginalFiles() {
        return this.originalFiles;
    }

    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public String getPartitionLocation() {
        return this.partitionLocation;
    }

    @JsonProperty
    public List<DeleteDeltaInfo> getDeleteDeltas() {
        return this.deleteDeltas;
    }

    @JsonProperty
    public boolean isOrcAcidVersionValidated() {
        return this.orcAcidVersionValidated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcidInfo that = (AcidInfo)o;
        return this.bucketId == that.bucketId && this.orcAcidVersionValidated == that.orcAcidVersionValidated && Objects.equals(this.partitionLocation, that.partitionLocation) && Objects.equals(this.deleteDeltas, that.deleteDeltas) && Objects.equals(this.originalFiles, that.originalFiles);
    }

    public int hashCode() {
        return Objects.hash(this.partitionLocation, this.deleteDeltas, this.originalFiles, this.bucketId, this.orcAcidVersionValidated);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionLocation", (Object)this.partitionLocation).add("deleteDeltas", this.deleteDeltas).add("originalFiles", this.originalFiles).add("bucketId", this.bucketId).add("orcAcidVersionValidated", this.orcAcidVersionValidated).toString();
    }

    public static Builder builder(Path partitionPath) {
        return new Builder(partitionPath);
    }

    public static Builder builder(AcidInfo acidInfo) {
        return new Builder(acidInfo);
    }

    public static class Builder {
        private final Path partitionLocation;
        private final List<DeleteDeltaInfo> deleteDeltaInfos = new ArrayList<DeleteDeltaInfo>();
        private final ListMultimap<Integer, OriginalFileInfo> bucketIdToOriginalFileInfoMap = ArrayListMultimap.create();
        private boolean orcAcidVersionValidated;

        private Builder(Path partitionPath) {
            this.partitionLocation = Objects.requireNonNull(partitionPath, "partitionPath is null");
        }

        private Builder(AcidInfo acidInfo) {
            this.partitionLocation = new Path(acidInfo.getPartitionLocation());
            this.deleteDeltaInfos.addAll(acidInfo.deleteDeltas);
        }

        public Builder addDeleteDelta(Path deleteDeltaPath) {
            Objects.requireNonNull(deleteDeltaPath, "deleteDeltaPath is null");
            Path partitionPathFromDeleteDelta = deleteDeltaPath.getParent();
            Preconditions.checkArgument((boolean)this.partitionLocation.equals((Object)partitionPathFromDeleteDelta), (String)"Partition location in DeleteDelta '%s' does not match stored location '%s'", (Object)deleteDeltaPath.getParent().toString(), (Object)this.partitionLocation);
            this.deleteDeltaInfos.add(new DeleteDeltaInfo(deleteDeltaPath.getName()));
            return this;
        }

        public Builder addOriginalFile(Path originalFilePath, long originalFileLength, int bucketId) {
            Objects.requireNonNull(originalFilePath, "originalFilePath is null");
            Path partitionPathFromOriginalPath = originalFilePath.getParent();
            Preconditions.checkArgument((boolean)this.partitionLocation.toUri().getPath().equals(partitionPathFromOriginalPath.toUri().getPath()), (String)"Partition location in OriginalFile '%s' does not match stored location '%s'", (Object)originalFilePath.getParent().toString(), (Object)this.partitionLocation);
            this.bucketIdToOriginalFileInfoMap.put((Object)bucketId, (Object)new OriginalFileInfo(originalFilePath.getName(), originalFileLength));
            return this;
        }

        public Builder setOrcAcidVersionValidated(boolean orcAcidVersionValidated) {
            this.orcAcidVersionValidated = orcAcidVersionValidated;
            return this;
        }

        public AcidInfo buildWithRequiredOriginalFiles(int bucketId) {
            Preconditions.checkState((bucketId > -1 && this.bucketIdToOriginalFileInfoMap.containsKey((Object)bucketId) ? 1 : 0) != 0, (String)"Bucket Id to OriginalFileInfo map should have entry for requested bucket id: %s", (int)bucketId);
            ImmutableList deleteDeltas = ImmutableList.copyOf(this.deleteDeltaInfos);
            return new AcidInfo(this.partitionLocation.toString(), (List<DeleteDeltaInfo>)deleteDeltas, this.bucketIdToOriginalFileInfoMap.get((Object)bucketId), bucketId, this.orcAcidVersionValidated);
        }

        public Optional<AcidInfo> build() {
            ImmutableList deleteDeltas = ImmutableList.copyOf(this.deleteDeltaInfos);
            if (deleteDeltas.isEmpty() && this.orcAcidVersionValidated) {
                return Optional.empty();
            }
            return Optional.of(new AcidInfo(this.partitionLocation.toString(), (List<DeleteDeltaInfo>)deleteDeltas, (List<OriginalFileInfo>)ImmutableList.of(), -1, this.orcAcidVersionValidated));
        }
    }

    public static class OriginalFileInfo {
        private final String name;
        private final long fileSize;

        @JsonCreator
        public OriginalFileInfo(@JsonProperty(value="name") String name, @JsonProperty(value="fileSize") long fileSize) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.fileSize = fileSize;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public long getFileSize() {
            return this.fileSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OriginalFileInfo that = (OriginalFileInfo)o;
            return this.fileSize == that.fileSize && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.fileSize);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("fileSize", this.fileSize).toString();
        }
    }

    public static class DeleteDeltaInfo {
        private final String directoryName;

        @JsonCreator
        public DeleteDeltaInfo(@JsonProperty(value="directoryName") String directoryName) {
            this.directoryName = directoryName;
        }

        @JsonProperty
        public String getDirectoryName() {
            return this.directoryName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteDeltaInfo that = (DeleteDeltaInfo)o;
            return Objects.equals(this.directoryName, that.directoryName);
        }

        public int hashCode() {
            return Objects.hash(this.directoryName);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("directoryName", (Object)this.directoryName).toString();
        }
    }
}

