/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.writer.ColumnChunk;
import io.trino.parquet.writer.ColumnWriter;
import io.trino.parquet.writer.repdef.DefLevelIterable;
import io.trino.parquet.writer.repdef.DefLevelIterables;
import io.trino.parquet.writer.repdef.RepLevelIterable;
import io.trino.parquet.writer.repdef.RepLevelIterables;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarMap;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class MapColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapColumnWriter.class).instanceSize();
    private final ColumnWriter keyWriter;
    private final ColumnWriter valueWriter;
    private final int maxDefinitionLevel;
    private final int maxRepetitionLevel;

    public MapColumnWriter(ColumnWriter keyWriter, ColumnWriter valueWriter, int maxDefinitionLevel, int maxRepetitionLevel) {
        this.keyWriter = Objects.requireNonNull(keyWriter, "keyWriter is null");
        this.valueWriter = Objects.requireNonNull(valueWriter, "valueWriter is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.maxRepetitionLevel = maxRepetitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)columnChunk.getBlock());
        ImmutableList defLevelIterables = ImmutableList.builder().addAll(columnChunk.getDefLevelIterables()).add((Object)DefLevelIterables.of(columnarMap, this.maxDefinitionLevel)).build();
        ImmutableList repLevelIterables = ImmutableList.builder().addAll(columnChunk.getRepLevelIterables()).add((Object)RepLevelIterables.of(columnarMap, this.maxRepetitionLevel)).build();
        this.keyWriter.writeBlock(new ColumnChunk(columnarMap.getKeysBlock(), (List<DefLevelIterable>)defLevelIterables, (List<RepLevelIterable>)repLevelIterables));
        this.valueWriter.writeBlock(new ColumnChunk(columnarMap.getValuesBlock(), (List<DefLevelIterable>)defLevelIterables, (List<RepLevelIterable>)repLevelIterables));
    }

    @Override
    public void close() {
        this.keyWriter.close();
        this.valueWriter.close();
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        return ImmutableList.builder().addAll(this.keyWriter.getBuffer()).addAll(this.valueWriter.getBuffer()).build();
    }

    @Override
    public long getBufferedBytes() {
        return this.keyWriter.getBufferedBytes() + this.valueWriter.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.keyWriter.getRetainedBytes() + this.valueWriter.getRetainedBytes();
    }

    @Override
    public void reset() {
        this.keyWriter.reset();
        this.valueWriter.reset();
    }
}

