/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import org.apache.parquet.io.api.Binary;

public class UuidColumnReader
extends PrimitiveColumnReader {
    public UuidColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type trinoType) {
        Preconditions.checkArgument((trinoType == UuidType.UUID ? 1 : 0) != 0, (String)"Unsupported type: %s", (Object)trinoType);
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            Binary binary = this.valuesReader.readBytes();
            Slice slice = Slices.wrappedBuffer((byte[])binary.getBytes());
            trinoType.writeSlice(blockBuilder, slice);
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

