/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.ParquetTimestampUtils;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoder;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TimestampColumnReader
extends PrimitiveColumnReader {
    private final DateTimeZone timeZone;

    public TimestampColumnReader(RichColumnDescriptor descriptor, DateTimeZone timeZone) {
        super(descriptor);
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (type instanceof TimestampWithTimeZoneType) {
                DecodedTimestamp decodedTimestamp = ParquetTimestampUtils.decode(this.valuesReader.readBytes());
                long utcMillis = decodedTimestamp.getEpochSeconds() * 1000L + (long)(decodedTimestamp.getNanosOfSecond() / 1000000);
                type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
            } else {
                TrinoTimestampEncoder trinoTimestampEncoder = TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)((TimestampType)type), (DateTimeZone)this.timeZone);
                trinoTimestampEncoder.write(ParquetTimestampUtils.decode(this.valuesReader.readBytes()), blockBuilder);
            }
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

