/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;

public class Int64TimestampNanosColumnReader
extends PrimitiveColumnReader {
    public Int64TimestampNanosColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long epochNanos = this.valuesReader.readLong();
            if (type == TimestampType.TIMESTAMP_MILLIS) {
                type.writeLong(blockBuilder, Timestamps.round((long)epochNanos, (int)6) / 1000L);
                return;
            } else if (type == TimestampType.TIMESTAMP_MICROS) {
                type.writeLong(blockBuilder, Timestamps.round((long)epochNanos, (int)3) / 1000L);
                return;
            } else {
                if (type != TimestampType.TIMESTAMP_NANOS) throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", new Object[]{type, this.columnDescriptor}));
                type.writeObject(blockBuilder, (Object)new LongTimestamp(Math.floorDiv(epochNanos, 1000), Math.floorMod(epochNanos, 1000) * 1000));
            }
            return;
        } else {
            if (!this.isValueNull()) return;
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readLong();
        }
    }
}

