/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;

public class Int64TimestampMillisColumnReader
extends PrimitiveColumnReader {
    public Int64TimestampMillisColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long utcMillis = this.valuesReader.readLong();
            if (type instanceof TimestampWithTimeZoneType) {
                type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
                return;
            } else {
                if (!(type instanceof TimestampType)) throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", new Object[]{type, this.columnDescriptor}));
                long epochMicros = utcMillis * 1000L;
                if (((TimestampType)type).isShort()) {
                    type.writeLong(blockBuilder, epochMicros);
                    return;
                } else {
                    type.writeObject(blockBuilder, (Object)new LongTimestamp(epochMicros, 0));
                }
            }
            return;
        } else {
            if (!this.isValueNull()) return;
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readLong();
        }
    }
}

