/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.predicate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetTimestampUtils;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.predicate.DictionaryDescriptor;
import io.trino.parquet.predicate.Predicate;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public class TupleDomainParquetPredicate
implements Predicate {
    private final TupleDomain<ColumnDescriptor> effectivePredicate;
    private final List<RichColumnDescriptor> columns;
    private final DateTimeZone timeZone;

    public TupleDomainParquetPredicate(TupleDomain<ColumnDescriptor> effectivePredicate, List<RichColumnDescriptor> columns, DateTimeZone timeZone) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    public boolean matches(long numberOfRows, Map<ColumnDescriptor, Statistics<?>> statistics, ParquetDataSourceId id) throws ParquetCorruptionException {
        if (numberOfRows == 0L) {
            return false;
        }
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        for (RichColumnDescriptor column : this.columns) {
            Domain domain;
            Statistics<?> columnStatistics;
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get((Object)column);
            if (effectivePredicateDomain == null || (columnStatistics = statistics.get((Object)column)) == null || columnStatistics.isEmpty() || effectivePredicateDomain.overlaps(domain = TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), numberOfRows, columnStatistics, id, column.toString(), this.timeZone))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(DictionaryDescriptor dictionary) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get(dictionary.getColumnDescriptor());
        return effectivePredicateDomain == null || this.effectivePredicateMatches(effectivePredicateDomain, dictionary);
    }

    @Override
    public boolean matches(long numberOfRows, ColumnIndexStore columnIndexStore, ParquetDataSourceId id) throws ParquetCorruptionException {
        Objects.requireNonNull(columnIndexStore, "columnIndexStore is null");
        if (numberOfRows == 0L) {
            return false;
        }
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        for (RichColumnDescriptor column : this.columns) {
            Domain domain;
            ColumnIndex columnIndex;
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get((Object)column);
            if (effectivePredicateDomain == null || (columnIndex = columnIndexStore.getColumnIndex(ColumnPath.get((String[])column.getPath()))) == null || this.isEmptyColumnIndex(columnIndex) || effectivePredicateDomain.overlaps(domain = this.getDomain(effectivePredicateDomain.getType(), numberOfRows, columnIndex, id, column))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<FilterPredicate> toParquetFilter(DateTimeZone timeZone) {
        return Optional.ofNullable(this.convertToParquetFilter(timeZone));
    }

    private boolean effectivePredicateMatches(Domain effectivePredicateDomain, DictionaryDescriptor dictionary) {
        return effectivePredicateDomain.overlaps(TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), dictionary, this.timeZone));
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, Statistics<?> statistics, ParquetDataSourceId id, String column, DateTimeZone timeZone) throws ParquetCorruptionException {
        boolean hasNullValue;
        if (statistics == null || statistics.isEmpty()) {
            return Domain.all((Type)type);
        }
        if (statistics.isNumNullsSet() && statistics.getNumNulls() == rowCount) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = !statistics.isNumNullsSet() || statistics.getNumNulls() != 0L;
        if (!statistics.hasNonNullValue() || statistics.genericGetMin() == null || statistics.genericGetMax() == null) {
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
        try {
            return TupleDomainParquetPredicate.getDomain(type, (List<Object>)ImmutableList.of((Object)statistics.genericGetMin()), (List<Object>)ImmutableList.of((Object)statistics.genericGetMax()), hasNullValue, timeZone);
        }
        catch (Exception e) {
            throw TupleDomainParquetPredicate.corruptionException(column, id, statistics, e);
        }
    }

    private static Domain getDomain(Type type, List<Object> minimums, List<Object> maximums, boolean hasNullValue, DateTimeZone timeZone) {
        Preconditions.checkArgument((minimums.size() == maximums.size() ? 1 : 0) != 0, (Object)"Expected minimums and maximums to have the same size");
        if (type.equals(BooleanType.BOOLEAN)) {
            boolean hasFalseValues;
            boolean hasTrueValues = minimums.stream().anyMatch(value -> (Boolean)value) || maximums.stream().anyMatch(value -> (Boolean)value);
            boolean bl = hasFalseValues = minimums.stream().anyMatch(value -> (Boolean)value == false) || maximums.stream().anyMatch(value -> (Boolean)value == false);
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)type);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            throw new VerifyException("Impossible boolean statistics");
        }
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(DateType.DATE) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < minimums.size(); ++i) {
                long max;
                long min = TupleDomainParquetPredicate.asLong(minimums.get(i));
                if (PredicateUtils.isStatisticsOverflow(type, min, max = TupleDomainParquetPredicate.asLong(maximums.get(i)))) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
            }
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            ArrayList<Range> ranges = new ArrayList<Range>();
            if (decimalType.isShort()) {
                for (int i = 0; i < minimums.size(); ++i) {
                    long maxValue;
                    Object min = minimums.get(i);
                    Object max = maximums.get(i);
                    long minValue = min instanceof Binary ? ParquetTypeUtils.getShortDecimalValue(((Binary)min).getBytes()) : TupleDomainParquetPredicate.asLong(min);
                    long l = maxValue = min instanceof Binary ? ParquetTypeUtils.getShortDecimalValue(((Binary)max).getBytes()) : TupleDomainParquetPredicate.asLong(max);
                    if (PredicateUtils.isStatisticsOverflow(type, minValue, maxValue)) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    ranges.add(Range.range((Type)type, (Object)minValue, (boolean)true, (Object)maxValue, (boolean)true));
                }
            } else {
                for (int i = 0; i < minimums.size(); ++i) {
                    Slice min = ParquetTypeUtils.getLongDecimalValue(((Binary)minimums.get(i)).getBytes());
                    Slice max = ParquetTypeUtils.getLongDecimalValue(((Binary)maximums.get(i)).getBytes());
                    ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
                }
            }
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (type.equals(RealType.REAL)) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < minimums.size(); ++i) {
                Float min = (Float)minimums.get(i);
                Float max = (Float)maximums.get(i);
                if (min.isNaN() || max.isNaN()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)Float.floatToRawIntBits(min.floatValue()), (boolean)true, (Object)Float.floatToRawIntBits(max.floatValue()), (boolean)true));
            }
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < minimums.size(); ++i) {
                Double min = (Double)minimums.get(i);
                Double max = (Double)maximums.get(i);
                if (min.isNaN() || max.isNaN()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
            }
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (type instanceof VarcharType) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int i = 0; i < minimums.size(); ++i) {
                Slice min = Slices.wrappedBuffer((ByteBuffer)((Binary)minimums.get(i)).toByteBuffer());
                Slice max = Slices.wrappedBuffer((ByteBuffer)((Binary)maximums.get(i)).toByteBuffer());
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
            }
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (type instanceof TimestampType) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < minimums.size(); ++i) {
                Object min = minimums.get(i);
                Object max = maximums.get(i);
                if (!(min instanceof Binary && max instanceof Binary && min.equals(max))) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                values.add(TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)((TimestampType)type), (DateTimeZone)timeZone).getTimestamp(ParquetTimestampUtils.decode((Binary)min)));
            }
            return Domain.multipleValues((Type)type, values, (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    @VisibleForTesting
    public Domain getDomain(Type type, long rowCount, ColumnIndex columnIndex, ParquetDataSourceId id, RichColumnDescriptor descriptor) throws ParquetCorruptionException {
        boolean hasNullValue;
        if (columnIndex == null) {
            return Domain.all((Type)type);
        }
        String columnName = descriptor.getPrimitiveType().getName();
        if (this.isCorruptedColumnIndex(columnIndex)) {
            throw TupleDomainParquetPredicate.corruptionException(columnName, id, columnIndex, null);
        }
        if (this.isEmptyColumnIndex(columnIndex)) {
            return Domain.all((Type)type);
        }
        long totalNullCount = columnIndex.getNullCounts().stream().mapToLong(value -> value).sum();
        boolean bl = hasNullValue = totalNullCount > 0L;
        if (hasNullValue && totalNullCount == rowCount) {
            return Domain.onlyNull((Type)type);
        }
        try {
            int pageCount = columnIndex.getMinValues().size();
            ColumnIndexValueConverter converter = new ColumnIndexValueConverter();
            Function<ByteBuffer, Object> converterFunction = converter.getConverter(descriptor.getPrimitiveType());
            ArrayList<Object> min = new ArrayList<Object>();
            ArrayList<Object> max = new ArrayList<Object>();
            for (int i = 0; i < pageCount; ++i) {
                min.add(converterFunction.apply((ByteBuffer)columnIndex.getMinValues().get(i)));
                max.add(converterFunction.apply((ByteBuffer)columnIndex.getMaxValues().get(i)));
            }
            return TupleDomainParquetPredicate.getDomain(type, min, max, hasNullValue, this.timeZone);
        }
        catch (Exception e) {
            throw TupleDomainParquetPredicate.corruptionException(columnName, id, columnIndex, e);
        }
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, DictionaryDescriptor dictionaryDescriptor) {
        return TupleDomainParquetPredicate.getDomain(type, dictionaryDescriptor, DateTimeZone.getDefault());
    }

    private static Domain getDomain(Type type, DictionaryDescriptor dictionaryDescriptor, DateTimeZone timeZone) {
        Dictionary dictionary;
        if (dictionaryDescriptor == null) {
            return Domain.all((Type)type);
        }
        ColumnDescriptor columnDescriptor = dictionaryDescriptor.getColumnDescriptor();
        Optional<DictionaryPage> dictionaryPage = dictionaryDescriptor.getDictionaryPage();
        if (dictionaryPage.isEmpty()) {
            return Domain.all((Type)type);
        }
        try {
            dictionary = dictionaryPage.get().getEncoding().initDictionary(columnDescriptor, dictionaryPage.get());
        }
        catch (Exception e) {
            return Domain.all((Type)type);
        }
        int dictionarySize = dictionaryPage.get().getDictionarySize();
        DictionaryValueConverter converter = new DictionaryValueConverter(dictionary);
        Function<Integer, Object> convertFunction = converter.getConverter(columnDescriptor.getPrimitiveType());
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < dictionarySize; ++i) {
            values.add(convertFunction.apply(i));
        }
        return TupleDomainParquetPredicate.getDomain(type, values, values, true, timeZone);
    }

    private static ParquetCorruptionException corruptionException(String column, ParquetDataSourceId id, Statistics<?> statistics, Exception cause) {
        return new ParquetCorruptionException(cause, String.format("Corrupted statistics for column \"%s\" in Parquet file \"%s\": [%s]", column, id, statistics), new Object[0]);
    }

    private static ParquetCorruptionException corruptionException(String column, ParquetDataSourceId id, ColumnIndex columnIndex, Exception cause) {
        return new ParquetCorruptionException(cause, String.format("Corrupted statistics for column \"%s\" in Parquet file \"%s\". Corrupted column index: [%s]", column, id, columnIndex), new Object[0]);
    }

    private boolean isCorruptedColumnIndex(ColumnIndex columnIndex) {
        if (columnIndex.getMaxValues() == null || columnIndex.getMinValues() == null || columnIndex.getNullCounts() == null || columnIndex.getNullPages() == null) {
            return true;
        }
        return columnIndex.getMaxValues().size() != columnIndex.getMinValues().size() || columnIndex.getMaxValues().size() != columnIndex.getNullPages().size() || columnIndex.getMaxValues().size() != columnIndex.getNullCounts().size();
    }

    public static long asLong(Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        throw new IllegalArgumentException("Can't convert value to long: " + value.getClass().getName());
    }

    private boolean isEmptyColumnIndex(ColumnIndex columnIndex) {
        return columnIndex.getMaxValues().size() == 0;
    }

    private FilterPredicate convertToParquetFilter(DateTimeZone timeZone) {
        Operators.UserDefined filter = null;
        for (RichColumnDescriptor column : this.columns) {
            Domain domain = (Domain)((Map)this.effectivePredicate.getDomains().get()).get((Object)column);
            if (domain == null || domain.isNone() || domain.isAll()) continue;
            Operators.UserDefined columnFilter = FilterApi.userDefined((Operators.Column)new TrinoIntColumn(ColumnPath.get((String[])column.getPath())), new DomainUserDefinedPredicate(domain, timeZone));
            if (filter == null) {
                filter = columnFilter;
                continue;
            }
            filter = FilterApi.and((FilterPredicate)filter, (FilterPredicate)columnFilter);
        }
        return filter;
    }

    private static final class TrinoIntColumn
    extends Operators.Column<Integer>
    implements Operators.SupportsLtGt {
        TrinoIntColumn(ColumnPath columnPath) {
            super(columnPath, Integer.class);
        }
    }

    private static class DictionaryValueConverter {
        private final Dictionary dictionary;

        private DictionaryValueConverter(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        private Function<Integer, Object> getConverter(PrimitiveType primitiveType) {
            switch (primitiveType.getPrimitiveTypeName()) {
                case INT32: {
                    return i -> this.dictionary.decodeToInt((int)i);
                }
                case INT64: {
                    return i -> this.dictionary.decodeToLong((int)i);
                }
                case FLOAT: {
                    return i -> Float.valueOf(this.dictionary.decodeToFloat((int)i));
                }
                case DOUBLE: {
                    return i -> this.dictionary.decodeToDouble((int)i);
                }
            }
            return i -> this.dictionary.decodeToBinary((int)i);
        }
    }

    private static class ColumnIndexValueConverter {
        private ColumnIndexValueConverter() {
        }

        private Function<ByteBuffer, Object> getConverter(PrimitiveType primitiveType) {
            switch (primitiveType.getPrimitiveTypeName()) {
                case BOOLEAN: {
                    return buffer -> buffer.get(0) != 0;
                }
                case INT32: {
                    return buffer -> buffer.order(ByteOrder.LITTLE_ENDIAN).getInt(0);
                }
                case INT64: {
                    return buffer -> buffer.order(ByteOrder.LITTLE_ENDIAN).getLong(0);
                }
                case FLOAT: {
                    return buffer -> Float.valueOf(buffer.order(ByteOrder.LITTLE_ENDIAN).getFloat(0));
                }
                case DOUBLE: {
                    return buffer -> buffer.order(ByteOrder.LITTLE_ENDIAN).getDouble(0);
                }
            }
            return buffer -> Binary.fromReusedByteBuffer((ByteBuffer)buffer);
        }
    }

    static class DomainUserDefinedPredicate<T extends Comparable<T>>
    extends UserDefinedPredicate<T>
    implements Serializable {
        private final Domain columnDomain;
        private final DateTimeZone timeZone;

        public DomainUserDefinedPredicate(Domain domain, DateTimeZone timeZone) {
            this.columnDomain = domain;
            this.timeZone = timeZone;
        }

        public boolean keep(T value) {
            return value != null || this.columnDomain.isNullAllowed();
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<T> statistic) {
            if (statistic == null) {
                return false;
            }
            Domain domain = TupleDomainParquetPredicate.getDomain(this.columnDomain.getType(), (List<Object>)ImmutableList.of((Object)statistic.getMin()), (List<Object>)ImmutableList.of((Object)statistic.getMax()), true, this.timeZone);
            return !this.columnDomain.overlaps(domain);
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<T> statistics) {
            return false;
        }
    }
}

