/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.dictionary;

import com.google.common.base.MoreObjects;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.dictionary.Dictionary;
import java.io.IOException;
import org.apache.parquet.column.values.plain.PlainValuesReader;

public class LongDictionary
extends Dictionary {
    private final long[] content;

    public LongDictionary(DictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        this.content = new long[dictionaryPage.getDictionarySize()];
        PlainValuesReader.LongPlainValuesReader longReader = new PlainValuesReader.LongPlainValuesReader();
        longReader.initFromPage(dictionaryPage.getDictionarySize(), ParquetReaderUtils.toInputStream(dictionaryPage));
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = longReader.readLong();
        }
    }

    @Override
    public long decodeToLong(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

