/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.parsetree;

import com.google.common.base.Preconditions;
import com.linkedin.coral.hive.hive2rel.parsetree.UnhandledASTTokenException;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ASTNode;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.Node;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractASTVisitor<R, C> {
    protected R visit(ASTNode node, C ctx) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case 0: {
                return this.visitNil(node, ctx);
            }
            case 863: {
                return this.visitSubquery(node, ctx);
            }
            case 864: {
                return this.visitSubqueryExpr(node, ctx);
            }
            case 865: {
                return this.visitSubqueryOp(node, ctx);
            }
            case 703: {
                return this.visitFrom(node, ctx);
            }
            case 911: 
            case 913: {
                return this.visitUnion(node, ctx);
            }
            case 809: {
                return this.visitQueryNode(node, ctx);
            }
            case 898: {
                return this.visitTabRefNode(node, ctx);
            }
            case 897: {
                return this.visitTabnameNode(node, ctx);
            }
            case 26: 
            case 70: 
            case 71: {
                return this.visitIdentifier(node, ctx);
            }
            case 313: {
                return this.visitStringLiteral(node, ctx);
            }
            case 7: {
                return this.visitBigintLiteral(node, ctx);
            }
            case 729: {
                return this.visitInsert(node, ctx);
            }
            case 826: {
                return this.visitSelectDistinct(node, ctx);
            }
            case 752: {
                return this.visitLimit(node, ctx);
            }
            case 825: {
                return this.visitSelect(node, ctx);
            }
            case 827: {
                return this.visitSelectExpr(node, ctx);
            }
            case 606: {
                return this.visitAllColRef(node, ctx);
            }
            case 717: {
                return this.visitHaving(node, ctx);
            }
            case 928: {
                return this.visitWhere(node, ctx);
            }
            case 714: {
                return this.visitGroupBy(node, ctx);
            }
            case 785: {
                return this.visitOrderBy(node, ctx);
            }
            case 899: {
                return this.visitSortColNameAsc(node, ctx);
            }
            case 900: {
                return this.visitSortColNameDesc(node, ctx);
            }
            case 705: {
                return this.visitFunction(node, ctx);
            }
            case 706: {
                return this.visitFunctionDistinct(node, ctx);
            }
            case 707: {
                return this.visitFunctionStar(node, ctx);
            }
            case 17: {
                return this.visitDotOperator(node, ctx);
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 33: 
            case 153: 
            case 175: 
            case 182: 
            case 212: 
            case 222: 
            case 294: 
            case 295: 
            case 299: 
            case 300: 
            case 301: 
            case 303: 
            case 311: 
            case 314: {
                return this.visitOperator(node, ctx);
            }
            case 297: {
                return this.visitLParen(node, ctx);
            }
            case 265: {
                return this.visitTrue(node, ctx);
            }
            case 107: {
                return this.visitFalse(node, ctx);
            }
            case 764: {
                return this.visitNullToken(node, ctx);
            }
            case 302: {
                return this.visitNumber(node, ctx);
            }
            case 894: {
                return this.visitTableTokOrCol(node, ctx);
            }
            case -1: 
            case 682: {
                return null;
            }
            case 35: 
            case 49: 
            case 50: 
            case 102: 
            case 129: 
            case 132: 
            case 164: 
            case 250: 
            case 287: 
            case 742: 
            case 743: {
                return this.visitKeywordLiteral(node, ctx);
            }
            case 650: {
                return this.visitBoolean(node, ctx);
            }
            case 731: {
                return this.visitInt(node, ctx);
            }
            case 860: {
                return this.visitString(node, ctx);
            }
            case 649: {
                return this.visitBinary(node, ctx);
            }
            case 686: {
                return this.visitDouble(node, ctx);
            }
            case 702: {
                return this.visitFloat(node, ctx);
            }
            case 648: {
                return this.visitBigInt(node, ctx);
            }
            case 906: {
                return this.visitTinyInt(node, ctx);
            }
            case 855: {
                return this.visitSmallInt(node, ctx);
            }
            case 652: {
                return this.visitChar(node, ctx);
            }
            case 676: {
                return this.visitDecimal(node, ctx);
            }
            case 924: {
                return this.visitVarchar(node, ctx);
            }
            case 671: {
                return this.visitDate(node, ctx);
            }
            case 672: {
                return this.visitDateLiteral(node, ctx);
            }
            case 904: {
                return this.visitTimestamp(node, ctx);
            }
            case 745: {
                return this.visitJoin(node, ctx);
            }
            case 748: {
                return this.visitLeftOuterJoin(node, ctx);
            }
            case 821: {
                return this.visitRightOuterJoin(node, ctx);
            }
            case 704: {
                return this.visitFullOuterJoin(node, ctx);
            }
            case 665: {
                return this.visitCrossJoin(node, ctx);
            }
            case 749: {
                return this.visitLeftSemiJoin(node, ctx);
            }
            case 746: {
                return this.visitLateralView(node, ctx);
            }
            case 747: {
                return this.visitLateralViewOuter(node, ctx);
            }
            case 870: {
                return this.visitTabAlias(node, ctx);
            }
            case 666: {
                return this.visitCTE(node, ctx);
            }
        }
        throw new UnhandledASTTokenException(node);
    }

    protected R visitKeywordLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected List<R> visitChildren(ASTNode node, C ctx) {
        Preconditions.checkNotNull((Object)node, ctx);
        Preconditions.checkNotNull(ctx);
        if (node.getChildren() == null) {
            return null;
        }
        return this.visitChildren(node.getChildren(), ctx);
    }

    protected List<R> visitChildren(List<Node> nodes, C ctx) {
        return nodes.stream().map(n -> this.visit((ASTNode)n, ctx)).collect(Collectors.toList());
    }

    protected R visitTabAlias(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLateralView(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLateralViewOuter(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLeftSemiJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitCrossJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFullOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitRightOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLeftOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFalse(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTrue(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNullToken(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLimit(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitUnion(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNumber(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitAllColRef(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitHaving(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitWhere(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSortColNameDesc(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSortColNameAsc(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitOrderBy(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitGroupBy(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitOperator(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDotOperator(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLParen(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunctionStar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunctionDistinct(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunction(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelectExpr(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelectDistinct(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelect(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTabRefNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTabnameNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubqueryOp(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubqueryExpr(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubquery(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFrom(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIdentifier(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitStringLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBigintLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitQueryNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNil(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBoolean(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSmallInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBigInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTinyInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFloat(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDouble(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitVarchar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitChar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitString(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBinary(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDecimal(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDate(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDateLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTimestamp(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTableTokOrCol(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitInsert(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIsNull(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIsNotNull(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitCTE(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }
}

