/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.collect.HashMultimap;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.ImmutableMultimap;
import com.linkedin.coral.com.google.common.collect.Multimap;
import com.linkedin.coral.hive.hive2rel.functions.GenericProjectFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveExplodeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.functions.HiveJsonTupleOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveNamedStructFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveRLikeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveReturnTypes;
import com.linkedin.coral.hive.hive2rel.functions.OperandTypeInference;
import com.linkedin.coral.hive.hive2rel.functions.SameOperandTypeExceptFirstOperandChecker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class StaticHiveFunctionRegistry
implements HiveFunctionRegistry {
    public static final String IS_TEST_MEMBER_ID_CLASS = "com.linkedin.dali.udf.istestmemberid.hive.IsTestMemberId";
    static final Multimap<String, HiveFunction> FUNCTION_MAP = HashMultimap.create();
    public static final Map<String, ImmutableList<String>> UDTF_RETURN_FIELD_NAME_MAP = new HashMap<String, ImmutableList<String>>();

    @Override
    public Collection<HiveFunction> lookup(String functionName) {
        return FUNCTION_MAP.get((Object)functionName.toLowerCase());
    }

    public ImmutableMultimap<String, HiveFunction> getRegistry() {
        return ImmutableMultimap.copyOf(FUNCTION_MAP);
    }

    private static void addFunctionEntry(String functionName, SqlOperator operator) {
        FUNCTION_MAP.put((Object)functionName.toLowerCase(), (Object)new HiveFunction(functionName, operator));
    }

    public static void createAddUserDefinedFunction(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        StaticHiveFunctionRegistry.addFunctionEntry(functionName, StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, operandTypeChecker));
    }

    public static void createAddUserDefinedFunction(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, String dependency) {
        String depPrefix = dependency.substring(0, 6).toLowerCase();
        if (!depPrefix.equals("ivy://")) {
            dependency = "ivy://" + dependency;
        }
        StaticHiveFunctionRegistry.addFunctionEntry(functionName, StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, operandTypeChecker));
    }

    public static void createAddUserDefinedTableFunction(String functionName, ImmutableList<String> returnFieldNames, ImmutableList<?> returnFieldTypes, SqlOperandTypeChecker operandTypeChecker) {
        Preconditions.checkArgument((!returnFieldTypes.isEmpty() && returnFieldTypes.size() == returnFieldNames.size() && (returnFieldTypes.stream().allMatch(type -> type instanceof SqlTypeName) || returnFieldTypes.stream().allMatch(type -> type instanceof SqlReturnTypeInference)) ? 1 : 0) != 0);
        if (returnFieldTypes.get(0) instanceof SqlTypeName) {
            StaticHiveFunctionRegistry.createAddUserDefinedFunction(functionName, HiveReturnTypes.rowOf(returnFieldNames, (ImmutableList<SqlTypeName>)ImmutableList.copyOf((Collection)returnFieldTypes.stream().map(type -> (SqlTypeName)type).collect(Collectors.toList()))), operandTypeChecker);
        } else {
            StaticHiveFunctionRegistry.createAddUserDefinedFunction(functionName, HiveReturnTypes.rowOfInference(returnFieldNames, (ImmutableList<SqlReturnTypeInference>)ImmutableList.copyOf((Collection)returnFieldTypes.stream().map(type -> (SqlReturnTypeInference)type).collect(Collectors.toList()))), operandTypeChecker);
        }
        UDTF_RETURN_FIELD_NAME_MAP.put(functionName, returnFieldNames);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes) {
        return new SqlUserDefinedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), returnTypeInference, operandTypeInference, operandTypeChecker, paramTypes, null);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlUserDefinedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), returnTypeInference, null, operandTypeChecker, null, null);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference) {
        return StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, null);
    }

    private static void addCastOperatorEntries() {
        String[] castFunctions;
        for (String f : castFunctions = new String[]{"tok_boolean", "tok_int", "tok_string", "tok_double", "tok_float", "tok_bigint", "tok_tinyint", "tok_smallint", "tok_char", "tok_decimal", "tok_varchar", "tok_binary", "tok_date", "tok_timestamp"}) {
            FUNCTION_MAP.put((Object)f, (Object)HiveFunction.CAST);
        }
    }

    private static Predicate<Integer> optionalOrd(int ordinal) {
        return input -> input == ordinal;
    }

    private static Predicate<Integer> optionalOrd(List<Integer> ordinals) {
        return ordinals::contains;
    }

    static {
        StaticHiveFunctionRegistry.addFunctionEntry("sum", (SqlOperator)SqlStdOperatorTable.SUM);
        StaticHiveFunctionRegistry.addFunctionEntry("count", (SqlOperator)SqlStdOperatorTable.COUNT);
        StaticHiveFunctionRegistry.addFunctionEntry("avg", (SqlOperator)SqlStdOperatorTable.AVG);
        StaticHiveFunctionRegistry.addFunctionEntry("min", (SqlOperator)SqlStdOperatorTable.MIN);
        StaticHiveFunctionRegistry.addFunctionEntry("max", (SqlOperator)SqlStdOperatorTable.MAX);
        FUNCTION_MAP.put((Object)"in", (Object)HiveFunction.IN);
        StaticHiveFunctionRegistry.addFunctionEntry("rlike", (SqlOperator)HiveRLikeOperator.RLIKE);
        StaticHiveFunctionRegistry.addFunctionEntry("regexp", (SqlOperator)HiveRLikeOperator.REGEXP);
        StaticHiveFunctionRegistry.addFunctionEntry("!=", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS);
        StaticHiveFunctionRegistry.addFunctionEntry("==", (SqlOperator)SqlStdOperatorTable.EQUALS);
        StaticHiveFunctionRegistry.addFunctionEntry("tok_isnull", (SqlOperator)SqlStdOperatorTable.IS_NULL);
        StaticHiveFunctionRegistry.addFunctionEntry("tok_isnotnull", (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL);
        FUNCTION_MAP.put((Object)"when", (Object)HiveFunction.WHEN);
        FUNCTION_MAP.put((Object)"case", (Object)HiveFunction.CASE);
        FUNCTION_MAP.put((Object)"between", (Object)HiveFunction.BETWEEN);
        StaticHiveFunctionRegistry.addFunctionEntry("nullif", (SqlOperator)SqlStdOperatorTable.NULLIF);
        StaticHiveFunctionRegistry.addFunctionEntry("isnull", (SqlOperator)SqlStdOperatorTable.IS_NULL);
        StaticHiveFunctionRegistry.addFunctionEntry("isnotnull", (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("nvl", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.and((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.ANY}), OperandTypes.SAME_SAME}));
        StaticHiveFunctionRegistry.addFunctionEntry("if", StaticHiveFunctionRegistry.createCalciteUDF("if", HiveReturnTypes.ARG1_OR_ARG2, OperandTypeInference.BOOLEAN_ANY_SAME, (SqlOperandTypeChecker)new SameOperandTypeExceptFirstOperandChecker(3, SqlTypeName.BOOLEAN), null));
        StaticHiveFunctionRegistry.addFunctionEntry("coalesce", (SqlOperator)SqlStdOperatorTable.COALESCE);
        StaticHiveFunctionRegistry.addCastOperatorEntries();
        StaticHiveFunctionRegistry.addFunctionEntry("array", (SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR);
        StaticHiveFunctionRegistry.addFunctionEntry("struct", (SqlOperator)SqlStdOperatorTable.ROW);
        StaticHiveFunctionRegistry.addFunctionEntry("map", (SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR);
        StaticHiveFunctionRegistry.addFunctionEntry("named_struct", (SqlOperator)HiveNamedStructFunction.NAMED_STRUCT);
        StaticHiveFunctionRegistry.addFunctionEntry("generic_project", (SqlOperator)GenericProjectFunction.GENERIC_PROJECT);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("binary", HiveReturnTypes.BINARY, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pmod", HiveReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("round", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("bround", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("floor", ReturnTypes.BIGINT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ceil", ReturnTypes.BIGINT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ceiling", ReturnTypes.BIGINT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rand", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(0)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("exp", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ln", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log10", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log2", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pow", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("power", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sqrt", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("hex", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unhex", HiveReturnTypes.BINARY, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("conv", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("abs", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sin", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("asin", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("cos", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("acos", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("tan", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("atan", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("degrees", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("radians", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("positive", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("negative", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sign", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("e", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.NILADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pi", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.NILADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("factorial", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("cbrt", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftleft", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftright", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftrightunsigned", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("greatest", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ANY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("least", ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ANY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("width_bucket", ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ascii", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("base64", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.BINARY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("character_length", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("chr", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("concat", HiveReturnTypes.STRING, OperandTypes.SAME_VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("concat_ws", HiveReturnTypes.STRING, new SqlOperandTypeChecker(){

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.ARRAY}).checkOperandTypes(callBinding, throwOnFailure) || new SameOperandTypeChecker(-1).checkOperandTypes(callBinding, throwOnFailure);
            }

            public SqlOperandCountRange getOperandCountRange() {
                return SqlOperandCountRanges.from((int)2);
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(STRING, ARRAY|STRING, ...)";
            }

            public SqlOperandTypeChecker.Consistency getConsistency() {
                return SqlOperandTypeChecker.Consistency.NONE;
            }

            public boolean isOptional(int i) {
                return false;
            }
        });
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("context_ngrams", ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("decode", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.BINARY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("elt", HiveReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("encode", HiveReturnTypes.BINARY, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("field", ReturnTypes.INTEGER, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("find_in_set", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("format_number", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.NUMERIC_INTEGER);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("get_json_object", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("in_file", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("initcap", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("instr", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("length", ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("levenshtein", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("locate", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.addFunctionEntry("lower", (SqlOperator)SqlStdOperatorTable.LOWER);
        StaticHiveFunctionRegistry.addFunctionEntry("lcase", (SqlOperator)SqlStdOperatorTable.LOWER);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("lpad", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ltrim", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ngrams", ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("octet_length", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("parse_url", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family(Collections.nCopies(3, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("printf", HiveReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("regexp_extract", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("regexp_replace", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("repeat", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.addFunctionEntry("replace", (SqlOperator)SqlStdOperatorTable.REPLACE);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("reverse", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.NULLABLE_LITERAL}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rpad", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rtrim", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sentences", ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("soundex", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("space", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("split", HiveReturnTypes.arrayOfType(SqlTypeName.VARCHAR), (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("str_to_map", HiveReturnTypes.mapOfType(SqlTypeName.VARCHAR, SqlTypeName.VARCHAR), (SqlOperandTypeChecker)OperandTypes.family(Collections.nCopies(3, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd((List<Integer>)ImmutableList.of((Object)1, (Object)2))));
        StaticHiveFunctionRegistry.addFunctionEntry("substr", (SqlOperator)SqlStdOperatorTable.SUBSTRING);
        StaticHiveFunctionRegistry.addFunctionEntry("substring", (SqlOperator)SqlStdOperatorTable.SUBSTRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("substring_index", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_INTEGER);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("translate", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("trim", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unbase64", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.NULLABLE_LITERAL}));
        StaticHiveFunctionRegistry.addFunctionEntry("upper", (SqlOperator)SqlStdOperatorTable.UPPER);
        StaticHiveFunctionRegistry.addFunctionEntry("ucase", (SqlOperator)SqlStdOperatorTable.UPPER);
        StaticHiveFunctionRegistry.addFunctionEntry("initcap", (SqlOperator)SqlStdOperatorTable.INITCAP);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("from_unixtime", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unix_timestamp", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd((List<Integer>)ImmutableList.of((Object)0, (Object)1))));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("to_date", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.DATETIME}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date", ReturnTypes.DATE, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.DATETIME}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("year", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("quarter", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("month", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("day", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("dayofmonth", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("hour", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.DATETIME}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("minute", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("second", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("weekofyear", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("datediff", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_add", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATE, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_sub", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATE, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("from_utc_timestamp", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.TIMESTAMP), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.addFunctionEntry("current_date", (SqlOperator)SqlStdOperatorTable.CURRENT_DATE);
        StaticHiveFunctionRegistry.addFunctionEntry("current_timestamp", (SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("add_months", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("last_day", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("next_day", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("trunc", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("months_between", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATE, SqlTypeFamily.DATE}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_format", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATE, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.TIMESTAMP, SqlTypeFamily.INTEGER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("to_utc_timestamp", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING_STRING, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.addFunctionEntry("size", (SqlOperator)SqlStdOperatorTable.CARDINALITY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("array_contains", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ANY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("map_keys", new SqlReturnTypeInference(){

            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataType operandType = opBinding.getOperandType(0);
                RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
                return typeFactory.createArrayType(operandType.getKeyType(), -1L);
            }
        }, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("map_values", new SqlReturnTypeInference(){

            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataType operandType = opBinding.getOperandType(0);
                RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
                return typeFactory.createArrayType(operandType.getValueType(), -1L);
            }
        }, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("array_contains", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ANY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sort_array", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.ARRAY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("extract_union", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.ANY, OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.INTEGER})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction(IS_TEST_MEMBER_ID_CLASS, ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.urnextractor.hive.UrnExtractor", HiveReturnTypes.ARRAY_OF_STR_STR_MAP, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.STRING, OperandTypes.ARRAY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udf.hdfs.GetDatasetNameFromPathUDF", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.isguestmemberid.hive.IsGuestMemberId", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.watbotcrawlerlookup.hive.WATBotCrawlerLookup", HiveReturnTypes.rowOf((ImmutableList<String>)ImmutableList.of((Object)"iscrawler", (Object)"crawlerid"), (ImmutableList<SqlTypeName>)ImmutableList.of((Object)SqlTypeName.BOOLEAN, (Object)SqlTypeName.VARCHAR)), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd((List<Integer>)ImmutableList.of((Object)2, (Object)3))));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.userinterfacelookup.hive.UserInterfaceLookup", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.portallookup.hive.PortalLookup", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.useragentparser.hive.UserAgentParser", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.maplookup.hive.MapLookup", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.monarch.UrnGenerator", HiveReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.genericlookup.hive.GenericLookup", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.ANY, SqlTypeFamily.ANY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.UrnToID", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.EpochToDateFormat", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.EpochToEpochMilliseconds", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.sanitize.hive.Sanitize", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("org.apache.hadoop.hive.ql.udf.generic.GenericProject", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.GetIdFromUrn", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.GetPermissionsString", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.EpochTimeInSeconds", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.EpochTimeInSecondsNullable", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.PhoneNumberNormalizer", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dwh.udf.profile.GetProfileUrl", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetFamily", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetOrderUrn", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetChooserId", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductName", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductCode", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductId", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("udfs.SeoReferrerTrkUdf", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.vector.daliview.udf.PresentMediaType", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.AdClickClassifier", HiveReturnTypes.rowOf((ImmutableList<String>)ImmutableList.of((Object)"clicks", (Object)"landingPageClicks", (Object)"totalEngagements", (Object)"otherEngagements", (Object)"likes", (Object)"commentLikes", (Object)"comments", (Object)"shares", (Object)"follows", (Object)"oneClickLeadFormOpens", (Object)"companyPageClicks", (Object)"fullScreenPlays", (Object[])new String[]{"viralClicks", "viralLandingPageClicks", "viralLikes", "viralCommentLikes", "viralComments", "viralShares", "viralFollows", "viralOneClickLeadFormOpens", "viralCompanyPageClicks", "viralFullScreenPlays", "viralTotalEngagements", "viralOtherEngagements", "adUnitClicks", "actionClicks", "textUrlClicks", "opens", "cardClicks", "viralCardClicks", "costInUsd", "costInLocalCurrency"}), (ImmutableList<SqlTypeName>)ImmutableList.of((Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.INTEGER, (Object[])new SqlTypeName[]{SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.DOUBLE, SqlTypeName.DOUBLE})), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.MAP, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.MAP, SqlTypeFamily.ANY, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.UnifiedCampaignType", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.ActivityId", HiveReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.AdPlacementClassifier", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.INTEGER}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.SponsoredMessageNodeId", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.EpochToDateFormat", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.EpochToEpochMilliseconds", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.stringudfs.hive.InitCap", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.IsGuestMemberId", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.MapLookup", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.MAP, SqlTypeFamily.STRING, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.PortalLookup", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.Sanitize", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.jemslookup.udf.hive.JemsLookup", HiveReturnTypes.rowOfInference((ImmutableList<String>)ImmutableList.of((Object)"jobproductid", (Object)"jobproductname", (Object)"jobentitlementids", (Object)"jobentitlementnameswithnamespace", (Object)"listingtype", (Object)"sublistingtype", (Object)"istestjob"), (ImmutableList<SqlReturnTypeInference>)ImmutableList.of((Object)HiveReturnTypes.BIGINT, (Object)HiveReturnTypes.STRING, (Object)HiveReturnTypes.arrayOfType(SqlTypeName.BIGINT), (Object)HiveReturnTypes.arrayOfType(SqlTypeName.VARCHAR), (Object)HiveReturnTypes.STRING, (Object)HiveReturnTypes.STRING, (Object)HiveReturnTypes.STRING)), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING, (Object)SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.userinterfacelookup.hive.UserInterfaceLookup", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.parsing.hive.UserAgentParser", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.family(Collections.nCopies(2, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.parsing.hive.Ip2Str", HiveReturnTypes.STRING, (SqlOperandTypeChecker)OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.IsTestMemberId", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING}));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.customudf.date.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.addFunctionEntry("explode", (SqlOperator)HiveExplodeOperator.EXPLODE);
        StaticHiveFunctionRegistry.addFunctionEntry("json_tuple", (SqlOperator)HiveJsonTupleOperator.JSON_TUPLE);
        StaticHiveFunctionRegistry.createAddUserDefinedTableFunction("com.linkedin.tsar.hive.udf.ToJymbiiScores", (ImmutableList<String>)ImmutableList.of((Object)"job_urn", (Object)"rank", (Object)"glmix_score", (Object)"global_model_score", (Object)"sentinel_score", (Object)"job_effect_score", (Object)"member_effect_score"), ImmutableList.of((Object)SqlTypeName.VARCHAR, (Object)SqlTypeName.INTEGER, (Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE, (Object)SqlTypeName.DOUBLE), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY}));
        StaticHiveFunctionRegistry.addFunctionEntry("current_user", (SqlOperator)SqlStdOperatorTable.CURRENT_USER);
    }
}

