/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.linkedin.coral.hive.hive2rel.TypeConverter;
import com.linkedin.coral.hive.hive2rel.functions.ArtifactsResolver;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveGenericUDFReturnTypeInference
implements SqlReturnTypeInference {
    private final String _udfClassName;
    private final List<String> _udfDependencies;
    private final ArtifactsResolver _artifactsResolver;
    private URLClassLoader _udfClassLoader = null;

    public HiveGenericUDFReturnTypeInference(String udfClassName, List<String> udfDependencies) {
        this._udfClassName = udfClassName;
        this._udfDependencies = udfDependencies;
        this._artifactsResolver = new ArtifactsResolver();
    }

    public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
        int operandCount = sqlOperatorBinding.getOperandCount();
        ObjectInspector[] inputObjectInspectors = new ObjectInspector[operandCount];
        for (int i = 0; i < sqlOperatorBinding.getOperandCount(); ++i) {
            inputObjectInspectors[i] = this.getObjectInspector(sqlOperatorBinding.getOperandType(i));
        }
        try {
            Class dynamicallyLoadedUdfClass = this.getDynamicallyLoadedUdfClass();
            return this.getRelDataType(this.getContextObjectInspector(dynamicallyLoadedUdfClass.getMethod("initialize", this.getDynamicallyLoadedObjectInspectorArrayClass()).invoke(dynamicallyLoadedUdfClass.newInstance(), this.getDynamicallyLoadedObjectInspectors(inputObjectInspectors))), sqlOperatorBinding.getTypeFactory());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find org.apache.hadoop.hive.ql.udf.generic.GenericUDF.initialize() on: " + this._udfClassName, e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate a new instance of " + this._udfClassName, e);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Unable to call org.apache.hadoop.hive.ql.udf.generic.GenericUDF.initialize() on: " + this._udfClassName, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class  " + this._udfClassName, e);
        }
    }

    private ObjectInspector getObjectInspector(RelDataType relDataType) {
        TypeInfo typeInfo = TypeConverter.convert(relDataType);
        return TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
    }

    private RelDataType getRelDataType(ObjectInspector hiveObjectInspector, RelDataTypeFactory relDataTypeFactory) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)hiveObjectInspector);
        return TypeConverter.convert(typeInfo, relDataTypeFactory);
    }

    private URLClassLoader getUdfClassLoader() {
        if (this._udfClassLoader == null) {
            URL[] urls = (URL[])this._udfDependencies.stream().flatMap(udfDependency -> this._artifactsResolver.resolve((String)udfDependency).stream()).map(file -> HiveGenericUDFReturnTypeInference.url(file.toURI())).toArray(URL[]::new);
            this._udfClassLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        }
        return this._udfClassLoader;
    }

    private final Class getDynamicallyLoadedUdfClass() throws ClassNotFoundException {
        return Class.forName(this._udfClassName, true, this.getUdfClassLoader());
    }

    private final Class getDynamicallyLoadedObjectInspectorArrayClass() throws ClassNotFoundException {
        return Class.forName("[Lorg.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;", true, this.getUdfClassLoader());
    }

    private final Object getDynamicallyLoadedObjectInspectors(ObjectInspector[] ois) {
        try {
            Class<?> objectInspectorClass = Class.forName("org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector", true, this.getUdfClassLoader());
            Object objectInspectorArray = Array.newInstance(objectInspectorClass, ois.length);
            for (int i = 0; i < ois.length; ++i) {
                Array.set(objectInspectorArray, i, this.getDynamicallyLoadedObjectInspector(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)ois[i]).getQualifiedName()));
            }
            return objectInspectorArray;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not get UDF ObjectInspector from context class loader ObjectInspector.", e);
        }
    }

    private final Object getDynamicallyLoadedObjectInspector(String typeName) {
        try {
            Class<?> typeInfoUtilsClass = Class.forName("org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils", true, this.getUdfClassLoader());
            Class<?> typeInfoClass = Class.forName("org.apache.hadoop.hive.serde2.typeinfo.TypeInfo", true, this.getUdfClassLoader());
            Object typeInfo = typeInfoUtilsClass.getMethod("getTypeInfoFromTypeString", String.class).invoke(null, typeName);
            return typeInfoUtilsClass.getMethod("getStandardJavaObjectInspectorFromTypeInfo", typeInfoClass).invoke(null, typeInfo);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not get UDF ObjectInspector from String type name.", e);
        }
    }

    private final ObjectInspector getContextObjectInspector(Object oi) {
        try {
            Class<?> objectInspectorClass = Class.forName("org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector", true, this.getUdfClassLoader());
            Class<?> typeInfoUtilsClass = Class.forName("org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils", true, this.getUdfClassLoader());
            Class<?> typeInfoClass = Class.forName("org.apache.hadoop.hive.serde2.typeinfo.TypeInfo", true, this.getUdfClassLoader());
            Object typeInfo = typeInfoUtilsClass.getMethod("getTypeInfoFromObjectInspector", objectInspectorClass).invoke(null, oi);
            String typeInfoString = (String)typeInfoClass.getMethod("getQualifiedName", new Class[0]).invoke(typeInfo, new Object[0]);
            return TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)typeInfoString));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not get Context ObjectInspector from dynamically loaded ObjectInspector.", e);
        }
    }

    private static URL url(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + uri, e);
        }
    }
}

