/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.hive.hive2rel.HiveTable;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.functions.HiveGenericUDFReturnTypeInference;
import com.linkedin.coral.hive.hive2rel.functions.HiveRLikeOperator;
import com.linkedin.coral.hive.hive2rel.functions.SqlFunctionIdentifier;
import com.linkedin.coral.hive.hive2rel.functions.UnknownSqlFunctionException;
import com.linkedin.coral.hive.hive2rel.functions.VersionedSqlUserDefinedFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveFunctionResolver {
    public final HiveFunctionRegistry registry;
    private final ConcurrentHashMap<String, HiveFunction> dynamicFunctionRegistry;
    private final List<SqlOperator> operators;

    public HiveFunctionResolver(HiveFunctionRegistry registry, ConcurrentHashMap<String, HiveFunction> dynamicRegistry) {
        this.registry = registry;
        this.dynamicFunctionRegistry = dynamicRegistry;
        this.operators = new ArrayList<SqlOperator>(SqlStdOperatorTable.instance().getOperatorList());
        this.operators.add((SqlOperator)HiveRLikeOperator.REGEXP);
        this.operators.add((SqlOperator)HiveRLikeOperator.RLIKE);
    }

    public SqlOperator resolveUnaryOperator(String name) {
        String lowerCaseOperator = name.toLowerCase();
        List matches = this.operators.stream().filter(o -> o.getName().toLowerCase().equals(lowerCaseOperator) && o instanceof SqlPrefixOperator).collect(Collectors.toList());
        Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0, (String)"%s operator %s", (Object[])new Object[]{this.operators.isEmpty() ? "Unknown" : "Ambiguous", name});
        return (SqlOperator)matches.get(0);
    }

    public SqlOperator resolveBinaryOperator(String name) {
        HiveFunction f;
        String lowerCaseOperator = name.toLowerCase();
        List matches = this.operators.stream().filter(o -> o.getName().toLowerCase().equals(lowerCaseOperator) && (o instanceof SqlBinaryOperator || o instanceof SqlSpecialOperator)).collect(Collectors.toList());
        if (matches.size() == 0 && (f = this.tryResolve(lowerCaseOperator, null, 2)) != null) {
            matches.add(f.getSqlOperator());
        }
        if (lowerCaseOperator.equals("+")) {
            return SqlStdOperatorTable.PLUS;
        }
        if (lowerCaseOperator.equals("-")) {
            return SqlStdOperatorTable.MINUS;
        }
        Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0, (String)"%s operator %s", (Object[])new Object[]{this.operators.isEmpty() ? "Unknown" : "Ambiguous", name});
        return (SqlOperator)matches.get(0);
    }

    public HiveFunction tryResolve(@Nonnull String functionName, @Nullable Table hiveTable, int numOfOperands) {
        Preconditions.checkNotNull((Object)functionName);
        Collection<HiveFunction> functions = this.registry.lookup(functionName);
        if (functions.isEmpty() && hiveTable != null) {
            functions = this.tryResolveAsDaliFunction(functionName, hiveTable, numOfOperands);
        }
        if (functions.isEmpty()) {
            throw new UnknownSqlFunctionException(functionName);
        }
        if (functions.size() == 1) {
            return functions.iterator().next();
        }
        return this.unresolvedFunction(functions.iterator().next().getSqlOperator().getName(), hiveTable);
    }

    public Collection<HiveFunction> resolve(String functionName) {
        Collection<HiveFunction> staticLookup = this.registry.lookup(functionName);
        if (!staticLookup.isEmpty()) {
            return staticLookup;
        }
        ImmutableList dynamicLookup = ImmutableList.of();
        HiveFunction hiveFunction = this.dynamicFunctionRegistry.get(functionName);
        if (hiveFunction != null) {
            dynamicLookup = ImmutableList.of((Object)hiveFunction);
        }
        return dynamicLookup;
    }

    public Collection<HiveFunction> tryResolveAsDaliFunction(String functionName, @Nonnull Table table, int numOfOperands) {
        com.linkedin.coral.com.google.common.base.Preconditions.checkNotNull((Object)table);
        String functionPrefix = String.format("%s_%s_", table.getDbName(), table.getTableName());
        if (!functionName.toLowerCase().startsWith(functionPrefix.toLowerCase())) {
            return ImmutableList.of();
        }
        String funcBaseName = functionName.substring(functionPrefix.length());
        HiveTable hiveTable = new HiveTable(table);
        Map<String, String> functionParams = hiveTable.getDaliFunctionParams();
        String funcClassName = functionParams.get(funcBaseName);
        if (funcClassName == null) {
            return ImmutableList.of();
        }
        Collection<HiveFunction> hiveFunctions = this.registry.lookup(funcClassName);
        if (hiveFunctions.size() == 0) {
            Collection<HiveFunction> dynamicResolvedHiveFunctions = this.resolveDaliFunctionDynamically(functionName, funcClassName, hiveTable, numOfOperands);
            if (dynamicResolvedHiveFunctions.size() == 0) {
                throw new UnknownSqlFunctionException(funcClassName);
            }
            return dynamicResolvedHiveFunctions;
        }
        return hiveFunctions.stream().map(f -> new HiveFunction(f.getHiveFunctionName(), (SqlOperator)new VersionedSqlUserDefinedFunction((SqlUserDefinedFunction)f.getSqlOperator(), hiveTable.getDaliUdfDependencies(), functionName))).collect(Collectors.toList());
    }

    @Nonnull
    private Collection<HiveFunction> resolveDaliFunctionDynamically(String functionName, String funcClassName, HiveTable hiveTable, int numOfOperands) {
        HiveFunction hiveFunction = new HiveFunction(funcClassName, (SqlOperator)new VersionedSqlUserDefinedFunction(new SqlUserDefinedFunction(new SqlIdentifier(funcClassName, SqlParserPos.ZERO), (SqlReturnTypeInference)new HiveGenericUDFReturnTypeInference(funcClassName, hiveTable.getDaliUdfDependencies()), null, this.createSqlOperandTypeChecker(numOfOperands), null, null), hiveTable.getDaliUdfDependencies(), functionName));
        this.dynamicFunctionRegistry.put(funcClassName, hiveFunction);
        return ImmutableList.of((Object)hiveFunction);
    }

    @Nonnull
    private HiveFunction unresolvedFunction(String functionName, Table table) {
        SqlIdentifier funcIdentifier = this.createFunctionIdentifier(functionName, table);
        return new HiveFunction(functionName, (SqlOperator)new SqlUnresolvedFunction(funcIdentifier, null, null, null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION));
    }

    @Nonnull
    private SqlIdentifier createFunctionIdentifier(String functionName, @Nullable Table table) {
        if (table == null) {
            return new SqlIdentifier((List)ImmutableList.of((Object)functionName), SqlParserPos.ZERO);
        }
        return new SqlFunctionIdentifier(functionName, (List<String>)ImmutableList.of((Object)table.getDbName(), (Object)table.getTableName()));
    }

    @Nonnull
    private SqlOperandTypeChecker createSqlOperandTypeChecker(int numOfOperands) {
        ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
        for (int i = 0; i < numOfOperands; ++i) {
            families.add(SqlTypeFamily.ANY);
        }
        FamilyOperandTypeChecker sqlOperandTypeChecker = OperandTypes.family(families);
        return sqlOperandTypeChecker;
    }
}

