/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactsResolver.class);
    private static final String IVY_SETTINGS_LOCATION = "IVY_SETTINGS_LOCATION";
    private static final String IVY_SETTINGS_FILE_NAME = "ivy.settings.xml";
    private static final String IVY_LOG_LEVEL = "IVY_LOG_LEVEL";
    private final Ivy _ivyInstance;

    public ArtifactsResolver() {
        Message.setDefaultLogger((MessageLogger)new DefaultMessageLogger(0));
        IvySettings settings = ArtifactsResolver.setupIvySettings();
        this._ivyInstance = Ivy.newInstance((IvySettings)settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> resolve(String dependencySpecString) {
        ArrayList<File> uris = new ArrayList<File>();
        try {
            this._ivyInstance.pushContext();
            ResolveReport report = this.getDependencies(ArtifactsResolver.createDependencySpec(dependencySpecString));
            for (ArtifactDownloadReport adr : report.getAllArtifactsReports()) {
                if (adr.getLocalFile() == null) continue;
                uris.add(adr.getLocalFile());
            }
            ArrayList<File> arrayList = uris;
            return arrayList;
        }
        finally {
            this._ivyInstance.popContext();
        }
    }

    private static DependencySpec createDependencySpec(String dependencySpecString) {
        DependencySpec dependencySpec = new DependencySpec();
        String withoutIvy = dependencySpecString.startsWith("ivy://") ? dependencySpecString.replaceFirst("ivy://", "") : dependencySpecString;
        String[] withParameters = withoutIvy.split("\\?");
        String[] withExtension = withParameters[0].split("@");
        String[] parts = withExtension[0].split(":");
        if (withParameters.length == 2) {
            for (String parameter : withParameters[1].split("&")) {
                String[] parameterKeyValue = parameter.trim().split("=");
                if (parameterKeyValue[0].toLowerCase().equals("classifier")) {
                    dependencySpec.classifier = parameterKeyValue[1];
                    continue;
                }
                if (!parameterKeyValue[0].toLowerCase().equals("transitive")) continue;
                dependencySpec.transitive = Boolean.parseBoolean(parameterKeyValue[1]);
            }
        }
        if (withExtension.length == 2) {
            dependencySpec.ext = withExtension[1];
        }
        dependencySpec.group = parts[0];
        dependencySpec.module = parts[1];
        dependencySpec.version = parts[2];
        if (parts.length > 3) {
            dependencySpec.classifier = parts[3];
        }
        return dependencySpec;
    }

    private ResolveReport getDependencies(DependencySpec dependencySpec) {
        long millis = System.currentTimeMillis();
        DefaultModuleDescriptor md = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"caller", (String)"all-caller", (String)("working-" + millis)));
        ModuleRevisionId mrid = dependencySpec.mrid();
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)md, mrid, true, false, true);
        dd.addDependencyConfiguration("default", "*");
        md.addDependency((DependencyDescriptor)dd);
        if (dependencySpec.classifier != null || dependencySpec.ext != null) {
            ImmutableMap attrs = dependencySpec.classifier != null ? ImmutableMap.of((Object)"classifier", (Object)dependencySpec.classifier) : null;
            DefaultDependencyArtifactDescriptor dad = new DefaultDependencyArtifactDescriptor((DependencyDescriptor)dd, mrid.getName(), dependencySpec.type, dependencySpec.ext, null, (Map)attrs);
            dad.addConfiguration("*");
            dd.addDependencyArtifact("default", (DependencyArtifactDescriptor)dad);
        }
        ResolveOptions resolveOptions = new ResolveOptions().setConfs(new String[]{"default"}).setOutputReport(true).setValidate(true).setTransitive(dependencySpec.transitive);
        resolveOptions.setLog("quiet");
        try {
            ResolveReport report = this._ivyInstance.resolve((ModuleDescriptor)md, resolveOptions);
            if (report.hasError()) {
                LOG.warn("Unable to fetch dependencies: " + report.getAllProblemMessages());
            }
            return report;
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException("Unable to fetch dependencies", e);
        }
    }

    private static IvySettings setupIvySettings() {
        IvySettings settings = new IvySettings();
        try {
            if (System.getenv().containsKey(IVY_SETTINGS_LOCATION)) {
                File settingsFile = ArtifactsResolver.getSettingsFile();
                LOG.info("Reading Ivy settings from: " + settingsFile);
                settings.load(settingsFile);
            } else {
                URL settingsUrl = ArtifactsResolver.class.getClassLoader().getResource(IVY_SETTINGS_FILE_NAME);
                LOG.info("Reading Ivy settings from: " + settingsUrl);
                settings.load(settingsUrl);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to configure Ivy", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to configure Ivy", e);
        }
        ArtifactsResolver.setupCacheDir(settings.getDefaultCache());
        settings.setVariable("ivy.default.configuration.m2compatible", "true");
        return settings;
    }

    private static File getSettingsFile() {
        String s = System.getenv().get(IVY_SETTINGS_LOCATION);
        if (s == null) {
            return null;
        }
        File file = new File(s);
        if (!file.exists()) {
            throw new RuntimeException("Ivy settings file: " + file + " does not exist");
        }
        return file;
    }

    private static void setupCacheDir(File cache) {
        if (!cache.exists()) {
            if (!cache.mkdirs()) {
                throw new RuntimeException("Unable to create cache directory: " + cache);
            }
        } else if (!cache.isDirectory()) {
            throw new RuntimeException("Default cache is not a directory: " + cache);
        }
    }

    private static int getIvyLogLevel() {
        String r = System.getenv(IVY_LOG_LEVEL);
        if (Strings.isNullOrEmpty((String)r)) {
            return 2;
        }
        try {
            return Integer.parseInt(r);
        }
        catch (NumberFormatException ignore) {
            LOG.warn("Could not parse number: " + r + " corresponding to key: " + IVY_LOG_LEVEL);
            return 2;
        }
    }

    private static class DependencySpec {
        String module;
        String type = "jar";
        String ext = "jar";
        String classifier;
        String group;
        String version;
        boolean transitive = true;

        private DependencySpec() {
        }

        ModuleRevisionId mrid() {
            return ModuleRevisionId.newInstance((String)this.group, (String)this.module, (String)this.version);
        }
    }
}

