/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linkedin.coral.hive.hive2rel.DaliOperatorTable;
import com.linkedin.coral.hive.hive2rel.HiveConvertletTable;
import com.linkedin.coral.hive.hive2rel.HiveMetastoreClient;
import com.linkedin.coral.hive.hive2rel.HiveSchema;
import com.linkedin.coral.hive.hive2rel.HiveSqlConformance;
import com.linkedin.coral.hive.hive2rel.HiveSqlToRelConverter;
import com.linkedin.coral.hive.hive2rel.HiveSqlValidator;
import com.linkedin.coral.hive.hive2rel.HiveTypeSystem;
import com.linkedin.coral.hive.hive2rel.HiveViewExpander;
import com.linkedin.coral.hive.hive2rel.LocalMetastoreHiveSchema;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.functions.StaticHiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.parsetree.ParseTreeBuilder;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;

public class RelContextProvider {
    private final FrameworkConfig config;
    private final HiveMetastoreClient hiveMetastoreClient;
    private RelBuilder relBuilder;
    private CalciteCatalogReader catalogReader;
    private HiveSqlValidator sqlValidator;
    private RelOptCluster cluster;
    private SqlToRelConverter relConverter;
    private final HiveConvertletTable convertletTable = new HiveConvertletTable();
    private Driver driver;
    private HiveFunctionRegistry registry;
    private ConcurrentHashMap<String, HiveFunction> dynamicRegistry;
    private HiveSchema schema;
    private LocalMetastoreHiveSchema localMetastoreSchema;

    public RelContextProvider(@Nonnull HiveMetastoreClient hiveMetastoreClient) {
        Preconditions.checkNotNull((Object)hiveMetastoreClient);
        this.hiveMetastoreClient = hiveMetastoreClient;
        this.schema = new HiveSchema(hiveMetastoreClient);
        SchemaPlus schemaPlus = Frameworks.createRootSchema((boolean)false);
        schemaPlus.add("hive", (Schema)this.schema);
        this.registry = new StaticHiveFunctionRegistry();
        this.dynamicRegistry = new ConcurrentHashMap();
        this.driver = new Driver();
        this.config = Frameworks.newConfigBuilder().convertletTable((SqlRexConvertletTable)this.convertletTable).defaultSchema(schemaPlus).typeSystem((RelDataTypeSystem)new HiveTypeSystem()).traitDefs((List)null).operatorTable(ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{SqlStdOperatorTable.instance(), new DaliOperatorTable(this.registry, this.dynamicRegistry)})).programs(new Program[]{Programs.ofRules((Iterable)Programs.RULE_SET)}).build();
    }

    public RelContextProvider(Map<String, Map<String, List<String>>> localMetaStore) {
        this.hiveMetastoreClient = null;
        this.localMetastoreSchema = new LocalMetastoreHiveSchema(localMetaStore);
        SchemaPlus schemaPlus = Frameworks.createRootSchema((boolean)false);
        schemaPlus.add("hive", (Schema)this.localMetastoreSchema);
        this.registry = new StaticHiveFunctionRegistry();
        this.dynamicRegistry = new ConcurrentHashMap();
        this.driver = new Driver();
        this.config = Frameworks.newConfigBuilder().convertletTable((SqlRexConvertletTable)this.convertletTable).defaultSchema(schemaPlus).typeSystem((RelDataTypeSystem)new HiveTypeSystem()).traitDefs((List)null).operatorTable(ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{SqlStdOperatorTable.instance(), new DaliOperatorTable(this.registry, this.dynamicRegistry)})).programs(new Program[]{Programs.ofRules((Iterable)Programs.RULE_SET)}).build();
    }

    public HiveFunctionRegistry getHiveFunctionRegistry() {
        return this.registry;
    }

    public ConcurrentHashMap<String, HiveFunction> getDynamicHiveFunctionRegistry() {
        return this.dynamicRegistry;
    }

    public FrameworkConfig getConfig() {
        return this.config;
    }

    ParseTreeBuilder.Config getParseTreeBuilderConfig() {
        return new ParseTreeBuilder.Config().setCatalogName("hive").setDefaultDB("default");
    }

    HiveMetastoreClient getHiveMetastoreClient() {
        return this.hiveMetastoreClient;
    }

    Schema getHiveSchema() {
        return this.schema != null ? this.schema : this.localMetastoreSchema;
    }

    public RelBuilder getRelBuilder() {
        if (this.relBuilder == null) {
            Hook.REL_BUILDER_SIMPLIFY.add(Hook.propertyJ((Object)false));
            this.relBuilder = RelBuilder.create((FrameworkConfig)this.config);
        }
        return this.relBuilder;
    }

    CalciteCatalogReader getCalciteCatalogReader() {
        CalciteConnectionConfig connectionConfig;
        if (this.config.getContext() != null) {
            connectionConfig = (CalciteConnectionConfig)this.config.getContext().unwrap(CalciteConnectionConfig.class);
        } else {
            Properties properties = new Properties();
            properties.setProperty(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(false));
            connectionConfig = new CalciteConnectionConfigImpl(properties);
        }
        if (this.catalogReader == null) {
            this.catalogReader = new MultiSchemaPathCalciteCatalogReader((CalciteSchema)this.config.getDefaultSchema().unwrap(CalciteSchema.class), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"hive", (Object)"default"), (Object)ImmutableList.of((Object)"hive"), (Object)ImmutableList.of()), this.getRelBuilder().getTypeFactory(), connectionConfig);
        }
        return this.catalogReader;
    }

    HiveSqlValidator getHiveSqlValidator() {
        if (this.sqlValidator == null) {
            this.sqlValidator = new HiveSqlValidator(this.config.getOperatorTable(), this.getCalciteCatalogReader(), (JavaTypeFactory)this.relBuilder.getTypeFactory(), HiveSqlConformance.HIVE_SQL);
        }
        return this.sqlValidator;
    }

    RelOptCluster getRelOptCluster() {
        if (this.cluster == null) {
            this.cluster = RelOptCluster.create((RelOptPlanner)new VolcanoPlanner(), (RexBuilder)this.getRelBuilder().getRexBuilder());
        }
        return this.cluster;
    }

    HiveViewExpander getViewExpander() {
        return new HiveViewExpander(this);
    }

    SqlToRelConverter getSqlToRelConverter() {
        if (this.relConverter == null) {
            this.relConverter = new HiveSqlToRelConverter(this.getViewExpander(), (SqlValidator)this.getHiveSqlValidator(), (Prepare.CatalogReader)this.getCalciteCatalogReader(), this.getRelOptCluster(), (SqlRexConvertletTable)this.convertletTable, SqlToRelConverter.configBuilder().build());
        }
        return this.relConverter;
    }

    public static class MultiSchemaPathCalciteCatalogReader
    extends CalciteCatalogReader {
        public MultiSchemaPathCalciteCatalogReader(CalciteSchema rootSchema, List<List<String>> schemaPathList, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
            super(rootSchema, SqlNameMatchers.withCaseSensitive((config != null && config.caseSensitive() ? 1 : 0) != 0), Util.immutableCopy(schemaPathList), typeFactory, config);
        }
    }
}

