/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.linkedin.coral.hive.hive2rel.TypeConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTable
implements ScannableTable {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTable.class);
    protected final Table hiveTable;
    private Deserializer deserializer;
    static final String TBLPROPERTIES_FUNCTIONS_KEY = "functions";
    static final String TBLPROPERTIES_DEPENDENCIES_KEY = "dependencies";
    private static Splitter tblpropertiesSplitter = Splitter.on((Pattern)Pattern.compile("\\s+")).omitEmptyStrings().trimResults();
    private static Splitter.MapSplitter functionsKeyValueSplitter = tblpropertiesSplitter.withKeyValueSeparator(Splitter.on((String)":").limit(2));

    public HiveTable(Table hiveTable) {
        Preconditions.checkNotNull((Object)hiveTable);
        this.hiveTable = hiveTable;
    }

    public Map<String, String> getDaliFunctionParams() {
        this.checkDaliTable();
        String functionsValue = (String)this.hiveTable.getParameters().get(TBLPROPERTIES_FUNCTIONS_KEY);
        Map<String, String> params = new HashMap<String, String>();
        if (functionsValue != null) {
            params = functionsKeyValueSplitter.split((CharSequence)functionsValue);
        }
        return params;
    }

    public List<String> getDaliUdfDependencies() {
        this.checkDaliTable();
        String propertyValue = (String)this.hiveTable.getParameters().get(TBLPROPERTIES_DEPENDENCIES_KEY);
        if (propertyValue != null) {
            return tblpropertiesSplitter.splitToList((CharSequence)propertyValue).stream().map(s -> s.toLowerCase().startsWith("ivy://") ? s : "ivy://" + s).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    public boolean isDaliTable() {
        return this.hiveTable.getOwner().equalsIgnoreCase("daliview");
    }

    private void checkDaliTable() {
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        List<FieldSchema> cols = this.getColumns();
        ArrayList fieldTypes = new ArrayList(cols.size());
        ArrayList fieldNames = new ArrayList(cols.size());
        Iterable allCols = Iterables.concat(cols, (Iterable)this.hiveTable.getPartitionKeys());
        allCols.forEach(col -> {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)col.getType());
            RelDataType relType = TypeConverter.convert(typeInfo, typeFactory);
            String colName = col.getName();
            if (!fieldNames.contains(colName)) {
                fieldNames.add(colName);
                fieldTypes.add(relType);
            }
        });
        return typeFactory.createStructType(fieldTypes, fieldNames);
    }

    private List<FieldSchema> getColumns() {
        StorageDescriptor sd = this.hiveTable.getSd();
        String serDeLib = this.getSerializationLib();
        if (serDeLib == null || serDeLib.isEmpty()) {
            return sd.getCols();
        }
        try {
            return MetaStoreUtils.getFieldsFromDeserializer((String)this.hiveTable.getTableName(), (Deserializer)this.getDeserializer());
        }
        catch (Exception e) {
            LOG.warn("Failed to get columns using deserializer", (Throwable)e);
            return sd.getCols();
        }
    }

    private String getSerializationLib() {
        return this.hiveTable.getSd().getSerdeInfo().getSerializationLib();
    }

    private Deserializer getDeserializer() {
        if (this.deserializer == null) {
            this.deserializer = this.getDeserializerFromMetaStore();
        }
        return this.deserializer;
    }

    private Deserializer getDeserializerFromMetaStore() {
        try {
            return MetaStoreUtils.getDeserializer((Configuration)new Configuration(false), (Table)this.hiveTable, (boolean)false);
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    public Schema.TableType getJdbcTableType() {
        TableType tableType = Enum.valueOf(TableType.class, this.hiveTable.getTableType());
        switch (tableType) {
            case VIRTUAL_VIEW: {
                return Schema.TableType.VIEW;
            }
            case MANAGED_TABLE: {
                return Schema.TableType.TABLE;
            }
            case INDEX_TABLE: {
                return Schema.TableType.INDEX;
            }
        }
        throw new RuntimeException("Unknown table type: " + this.hiveTable.getTableType());
    }

    public boolean isRolledUp(String s) {
        return false;
    }

    public boolean rolledUpColumnValidInsideAgg(String s, SqlCall sqlCall, SqlNode sqlNode, CalciteConnectionConfig calciteConnectionConfig) {
        return true;
    }

    public Enumerable<Object[]> scan(DataContext dataContext) {
        throw new RuntimeException("Calcite runtime is not supported");
    }
}

