/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.base.Preconditions;
import com.linkedin.coral.hive.hive2rel.HiveSchema;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;

public class HiveSchemaUtils {
    private HiveSchemaUtils() {
    }

    public static Optional<Schema> getDb(@Nonnull HiveSchema schema, @Nonnull String db) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)schema);
        return Optional.ofNullable(schema.getSubSchema(db));
    }

    public static Optional<Table> getTable(@Nonnull HiveSchema schema, @Nonnull String db, @Nonnull String table) {
        Preconditions.checkNotNull((Object)table);
        Optional<Schema> dbSchema = HiveSchemaUtils.getDb(schema, db);
        if (dbSchema.isPresent()) {
            return Optional.ofNullable(dbSchema.get().getTable(table));
        }
        return Optional.empty();
    }
}

